unit udscanner_relativeurl;

{$mode objfpc}{$H+}

interface

uses
  Classes, udirectoryscanner, SysUtils;

type
  { TDirectoryScanner_relative_url }

  TDirectoryScanner_relative_url = class(TDirectoryScanner)
    procedure scan(const carpeta_raiz: string); override;
    procedure procesar_archivo(const carpeta, nombre_archivo: string); override;
  end;


implementation


{ TDirectoryScanner_relative_url }

procedure TDirectoryScanner_relative_url.scan(const carpeta_raiz: string);
begin
  procesar_carpeta(carpeta_raiz, '*.html');
end;

procedure TDirectoryScanner_relative_url.procesar_archivo(
  const carpeta, nombre_archivo: string);
var
  fent, fsal: textfile;
  r: ansistring;
  i: integer;
  s: string;
begin
  s := archi(carpeta, nombre_archivo);

  writeln('Procesando ...: ', s);

  assignfile(fent, s);
  reset(fent);

  assignfile(fsal, 'tmp.txt');
  rewrite(fsal);

  while not EOF(fent) do
  begin
    readln(fent, r);
    i := pos('"/', r);
    while i > 0 do
    begin
      r := copy(r, 1, i) + copy(r, i + 2, length(r) - (i + 1));
      i := pos('"/', r);
    end;

    i := pos('"../', r);
    while i > 0 do
    begin
      r := copy(r, 1, i) + copy(r, i + 3, length(r) - (i + 3) + 1);
      i := pos('"../', r);
    end;

    i := pos('"/', r);
    while i > 0 do
    begin
      r := copy(r, 1, i) + copy(r, i + 2, length(r) - (i + 1));
      i := pos('"/', r);
    end;

    i := pos('''/', r);
    while i > 0 do
    begin
      r := copy(r, 1, i) + copy(r, i + 2, length(r) - (i + 1));
      i := pos('''/', r);
    end;

    writeln(fsal, r);
  end;

  closefile(fsal);
  closefile(fent);

  DeleteFile(s);
  RenameFile('tmp.txt', s);

end;


end.

