unit udscanner_tolowercase;

{$mode Delphi}{$H+}

interface

uses
  Classes, udirectoryscanner, SysUtils;

type
  { TDirectoryScanner_ToLowerCase }

  TDirectoryScanner_ToLowerCase = class(TDirectoryScanner)
    procedure scan(const carpeta_raiz: string); override;
    procedure procesar_archivo(const carpeta, nombre_archivo: string); override;
  end;


implementation

{ TDirectoryScanner_ToLowerCase }

procedure TDirectoryScanner_ToLowerCase.scan(const carpeta_raiz: string);
begin
  procesar_carpeta(carpeta_raiz, '*.pas');
  procesar_carpeta(carpeta_raiz, '*.pp');
end;

procedure TDirectoryScanner_ToLowerCase.procesar_archivo(
  const carpeta, nombre_archivo: string);
var
  slc: string;
begin
  slc := LowerCase(nombre_archivo);
  RenameFile(carpeta + DirectorySeparator + nombre_archivo, carpeta +
    DirectorySeparator + 'xxxx_' + slc);
  RenameFile(carpeta + DirectorySeparator + 'xxxx_' + slc, carpeta +
    DirectorySeparator + slc);
end;



end.

