unit ufilterlines;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    cbIgnoreCase: TCheckBox;
    eArchi: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    nopals: TMemo;
    sipals: TMemo;
    OpenDialog1: TOpenDialog;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure nopalsChange(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.lfm}

{ TForm1 }

procedure TForm1.nopalsChange(Sender: TObject);
begin

end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
    eArchi.Text:= OpenDialog1.FileName;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  f: textfile;
  pal: string;
  r: string;
  k: integer;
  flg_ok: boolean;
  archi: string;
  ent, sal: TextFile;
  sext: string;
  lst: TStrings;

begin
  filemode:= 0;
  assignfile( ent, eArchi.text );
  reset( ent );

  archi:= eArchi.Text;
  sext:= ExtractFileExt( archi );
  if length( sext ) > 0 then
    delete( archi, length( archi ) - length( sext ) +1, length( sext ) );
  archi:= archi+'_filtered_'+sext;

  filemode:= 2;
  assignfile( sal, archi );
  rewrite( sal );
  while not eof( ent ) do
  begin
    readln( ent, r );
    if cbIgnoreCase.Checked then
       r:= UpperCase( r );
    flg_ok:= true;
    k:= 0;
    lst:= sipals.Lines;
    while flg_ok and ( k< lst.Count) do
    begin
      pal:= lst[k];
      if cbIgnoreCase.Checked then
         pal:= UpperCase( pal );
      if pos( pal, r ) = 0 then
        flg_ok:= false
      else
        inc( k );
    end;
    lst:= nopals.Lines;
    while flg_ok and ( k< lst.Count) do
    begin
      pal:= lst[k];
      if cbIgnoreCase.Checked then
         pal:= UpperCase( pal );
      if pos( pal, r ) > 0 then
        flg_ok:= false
      else
        inc( k );
    end;
    if flg_ok then
      writeln( sal, r );
  end;
  closefile( sal );
  closefile( ent );
end;

end.

