unit uarchivos_dat;

{$mode delphi}

interface

uses
  Classes, SysUtils; 

type
TRec_Archivos_dat = class
  valor: string;
  constructor Create_red( var f: textfile );
end;

TArchivos_dat = class
  recs: TList;
  constructor Create_Read( var f: textfile );
  procedure Free;
end;
(*
  Registro Colunas Formato Descrição
1 31 a 42 A12 Nome do arquivo de dados gerais.
2 31 a 42 A12 Nome do arquivo de dados dos subsistemas.
3 31 a 42 A12 Nome do arquivo de dados da configuração hidroelétrica.
4 31 a 42 A12 Nome do arquivo de dados de alteração da configuração de usinas hidroelétricas.
5 31 a 42 A12 Nome do arquivo de dados da configuração termoelétrica.
6 31 a 42 A12 Nome do arquivo de dados das usinas termoelétricas.
7 31 a 42 A12 Nome do arquivo de dados de classes térmicas.
8 31 a 42 A12 Nome do arquivo de dados que contém a expansão das usinas hidroelétricas.
9 31 a 42 A12 Nome do arquivo de dados que contém a expansão das usinas termoelétricas.
10 31 a 42 A12 Nome do arquivo de dados que contém os patamares de mercado.
11 31 a 42 A12 Nome do arquivo que contém a função de custo futuro - cortes de Benders.
12 31 a 42 A12 Nome do arquivo que contém os apontadores de início da função de custo futuro de cada estágio.
13 31 a 42 A12 Nome do arquivo que contém o relatório de acompanhamento do programa.
15 31 a 42 A12 Nome do arquivo que contém os dados para obtenção do relatório opcional detalhado de acompanhamento da simulação forward.
16 31 a 42 A12 Nome do arquivo que contém o cabeçalho do arquivo de acompanhamento da simulação forward.
17 31 a 42 A12 Nome do arquivo que contém os parâmetros necessários à simulação com a série histórica.
18 31 a 42 A12 Nome do arquivo que contém informações sobre manutenções programadas em usinas térmicas, para o cálculo da indisponibilidade programada.
19 31 a 42 A12 Nome do arquivo de saída que contém as configurações dos sistemas, das usinas térmicas e das hidroelétricas.
20 31 a 42 A12 Nome do arquivo que contém a tendência hidrológica.
21 31 a 42 A12 Nome do arquivo que contém os dados referentes à usina de Itaipu (não usado).
22 31 a 42 A12 Nome do arquivo que contém informações sobre o “bidding” de demanda (não implementado).
23 31 a 42 A12 Nome do arquivo que contém dados de cargas adicionais.
24 31 a 42 A12 Nome do arquivo que contém informações sobre perdas.
25 31 a 42 A12 Nome do arquivo descrevendo geração térmica mínima por patamar.
26 31 a 42 A12 Nome do arquivo com os índices mensais ENSO (não implementado).
27 31 a 42 A12 Nome do arquivo com as fases ENSO p/ cada subsistema (não implementado).
28 31 a 42 A12 Nome do arquivo com outros usos da água (irrigação, por exemplo).
29 31 a 42 A12 Nome do arquivo com penalidades
30 31 a 42 A12 Nome do arquivo com dados da curva de aversão ou com penalidades para o não atendimento ao volume mínimo operativo.
31 31 a 42 A12 Nome do arquivo com dados de agrupamentos de intercâmbio
32 31 a 42 A12 Nome do arquivo com dados de antecipação de despacho de usinas térmicas a gás natural liquefeito (GNL)14 31 a 42 A12 Nome do arquivo que contém o relatório de acompanhamento do modelo PAR(p).
*)

implementation

constructor TRec_Archivos_dat.Create_red( var f: textfile );
var
  r: string;
begin
  readln( f, r );
  if length( r ) > 30 then
  begin
    delete( r, 0, 30 );
    if length( r ) > 12 then
      valor:= trim( copy( r, 1, 12 ) )
    else
      valor:= trim( r );
  end
  else
    valor:= '';
end;

constructor TArchivos_dat.Create_Read( var f: textfile );
var
  k: Integer;
begin
  recs:= TList.Create;
  for k:= 1 to 32 do
    recs.add( TRec_Archivos_dat.Create_red( f ) );
end;

procedure TArchivos_dat.Free;
var
  k: Integer;
begin
  for k:= 0 to recs.Count-1 do
    TRec_Archivos_dat( recs[k]).Free;
  recs.Free;
  inherited Free;
end;

end.

