program macrovars;
(*****
Sintáxis:

macrovars archi_defs archi_text archi_sal

La idea es que lea de archi_defs un conjunto de definiciones de la forma:

nombre = valor

En el archivo de definciones se pueden incluir marcovariables en el valor
y también se puede especificar incluir definicones de otro achivo.
Ej.

nombre = valor{$una_var}
#include = otroarchivo.txt


Luego abre archi_text y sustituye las apariciones de {$nombre} por valor y
crea el archivo archi_sal

En archi_text y archi_sal pueden usarse también valores de MacroVariables

Por ejemplo


macrovars archi_defs a_{$mes}.txt  s_{$mes}.txt

es un allamada válida si en archi_defs está definida la MarcoVariable $mes.

***)


{$mode objfpc}{$H+}

uses
  {$IFDEF UNIX}{$IFDEF UseCThreads}
  cthreads,
  {$ENDIF}{$ENDIF}
  SysUtils,
  Classes, upreprocesador;

{$R *.res}

procedure WriteAyuda;
begin
  writeln( 'Sintaxis: ');
  writeln( '     macrovars archi_defs archi_texto archi_resultado ' );
  halt( 1 );
end;


procedure Pause;
begin
  writeln('... Presione ENTER para continuar ...');
  readln;
end;

var
  ListaDeVariables: TListaDeVariablesPP;
  archi_defs: string;
  archi_text: string;
  archi_resultado: string;
  nombre: string;
  valor: string;
  k: integer;
  f: textfile;
  r: string;
begin
  if ParamCount < 3 then
    WriteAyuda;
  writeln( 'macrovars ... v201207130634 ... zonaexterior.net' );

  archi_defs:= ParamStr( 1 );
  if not FileExists( archi_defs ) then
  begin
    writeln( 'Imposible encontrar el archivo de definiciones: '+archi_defs );
    pause;
    exit;
  end;

  // cargamos el archivo de definiciones
  ListaDeVariables:= TListaDeVariablesPP.Create;
  for k:= 1 to ParamCount do
    ListaDeVariables.Agregar( IntToStr( k ), paramStr( k ));
  LeerDefiniciones_fromArchi( archi_defs, ListaDeVariables );



  archi_text:= ParamStr( 2 );
  archi_text:= SustituirVariables( archi_text, ListaDeVariables );
  if not FileExists( archi_text ) then
  begin
    writeln( 'Imposible encontrar el archivo de texto: '+archi_text );
    pause;
    exit;
  end;

    assignfile( f, ParamStr( 2 ) );
    reset( f );
    archi_text:= '';
    while not eof( f ) do
    begin
      readln( f, r );
      archi_text:= archi_text +r+#13#10;
    end;
    closefile( f );



  archi_resultado:= ParamStr( 3 );
  archi_resultado:= SustituirVariables( archi_resultado, ListaDeVariables );
  assignfile( f, archi_resultado );
  {$I-}
  rewrite( f );
  {$I+}
  if ioresult <> 0 then
  begin
    writeln( 'Imposible crear el archivo de resultados: '+archi_resultado );
    pause;
    exit;
  end;
  closefile( f );

  archi_resultado:= SustituirVariables( archi_text, ListaDeVariables );
  assignfile( f, ParamStr( 3 ) );
  rewrite( f );
  write( f , archi_resultado );
  closefile( f );

  ListaDeVariables.Free;

end.

