unit formTMiner2;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, miner2, uBatMiner2, uRandMiner2, TMiner2, MatReal,
  xMatDefs;

type
  TfTMiner2 = class(TForm)
    sgResults: TStringGrid;
    BMiner2: TButton;
    BBatMiner2: TButton;
    BRandMiner2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure BMiner2Click(Sender: TObject);
    procedure BBatMiner2Click(Sender: TObject);
    procedure BRandMiner2Click(Sender: TObject);
  private
    procedure imprimir(X: TVectR; ValCosto, t: NReal);
  public
    { Public declarations }
  end;

var
  fTMiner2: TfTMiner2;

implementation

{$R *.lfm}

procedure TfTMiner2.imprimir(X: TVectR; ValCosto, t: NReal);
var
  i: integer;
begin
  sgResults.RowCount := X.n + 2;
  for i := 0 to sgResults.RowCount - 3 do
  begin
    sgResults.Cells[0, i] := 'X' + IntToStr(i + 1);
    sgResults.Cells[1, i] := FloatToStr(X.e(i + 1));
  end;
  sgResults.Cells[0, sgResults.RowCount - 2] := 'f(x)';
  sgResults.Cells[1, sgResults.RowCount - 2] := FloatToStr(ValCosto);
  sgResults.Cells[0, sgResults.RowCount - 1] := 'Tiempo Tomado';
  sgResults.Cells[1, sgResults.RowCount - 1] := FloatToStr(t * 24 * 3600);

  for i := 0 to sgResults.ColCount - 1 do ;
end;

procedure TfTMiner2.FormCreate(Sender: TObject);
var
  i: integer;
begin
  for i := 0 to sgResults.RowCount - 3 do
    sgResults.Cells[0, i] := 'X' + IntToStr(i + 1);
  sgResults.Cells[0, sgResults.RowCount - 2] := 'f(x)';
  sgResults.Cells[0, sgResults.RowCount - 1] := 'Tiempo Tomado';
end;

procedure TfTMiner2.BMiner2Click(Sender: TObject);
var
  x: TVectR;
  NIters, NItersRel: longint;
  ValCosto: NReal;
  Convergio: boolean;
  tIni: TDateTime;
begin
  Miner2.Init(2, 2);
  Miner2.DefFunc(0, costo, grad);
  Miner2.DefFunc(1, fr1, gr1);
  Miner2.DefFunc(2, fr2, gr2);

  x := TVectR.Create_Init(2);
  x.pon_e(1, 10);
  x.pon_e(2, 10);

  tIni := now();
  Miner2.Minimizar(X, TMiner2.pasoini, TMiner2.errx,
    TMiner2.MaxNitersrel, NItersRel,
    TMiner2.MaxNIters, NIters,
    ValCosto, Convergio);
  imprimir(X, ValCosto, now() - tIni);
  x.Free;
end;

procedure TfTMiner2.BBatMiner2Click(Sender: TObject);
var
  x: TVectR;
  NIters, NItersRel: longint;
  ValCosto: NReal;
  Convergio: boolean;
  tIni: TDateTime;
begin
  uBatMiner2.Init(2, 2);
  uBatMiner2.DefFunc(0, costo);
  uBatMiner2.DefFunc(1, fr1);
  uBatMiner2.DefFunc(2, fr2);

  x := TVectR.Create_Init(2);
  x.pon_e(1, 10);
  x.pon_e(2, 10);

  tIni := now();
  uBatMiner2.Minimizar(X, TMiner2.pasoini, TMiner2.errx,
    TMiner2.MaxNitersrel, NItersRel,
    TMiner2.MaxNIters, NIters,
    ValCosto, Convergio);
  imprimir(X, ValCosto, now() - tIni);
  x.Free;
end;

procedure TfTMiner2.BRandMiner2Click(Sender: TObject);
var
  x: TVectR;
  NIters, NItersRel: longint;
  ValCosto: NReal;
  Convergio: boolean;
  tIni: TDateTime;
begin
  uRandMiner2.Init(2, 2);
  uRandMiner2.DefFunc(0, costo);
  uRandMiner2.DefFunc(1, fr1);
  uRandMiner2.DefFunc(2, fr2);

  x := TVectR.Create_Init(2);
  x.pon_e(1, 10);
  x.pon_e(2, 10);

  tIni := now();
  uRandMiner2.Minimizar(X, TMiner2.pasoini, TMiner2.errx,
    10000, NItersRel,
    1000, NIters,
    ValCosto, Convergio, 100);
  imprimir(X, ValCosto, now() - tIni);
  x.Free;
end;

end.
