unit uredcf;



interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls, uestados,
  xmatdefs, MatReal;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 


var
  Form1: TForm1; 
  CF: TAdminEstados;


implementation

{$R *.lfm}

{ TForm1 }

procedure TForm1.Button1Click(Sender: TObject);
var
  k, j: integer;

  x, y: TVectR;
  MR, MA: TMatR;

  m, n: Integer;
  cx, cy: NReal;
  error: NReal;
  kPuntoT: integer;
begin

  kPuntoT:= 1; (*inicializo a un punto de tiempo luego esto va a tener que ser
   un parametro *)
   (* acordarse que KPuntoT es el indice de tiempo y no el tiempo KPuntoT
   para obtener el tiempo k  hay que hacer N-KPuntoT siendo N la dimension
   del espacio de tiempo*)

  if CF = nil then
    CF :=  TAdminEstados.CreateLoadFromArchi( 'CF.bin' );
  //varsContinuas son las variables que necesitan ser discretizadas
  //VarsDiscretas son las variables enteras que ya están discretizadas
  n:= CF.nVarsContinuas;
  m:= n-1;

  y:= TVectR.Create_init( m );
  x:= TVectR.Create_init( n );

  MR:= TMatR.Create_Init( m, n );
  MA:= TMatR.Create_init( n, m );
  for k:= 1 to m do
    for j:= 1 to n do
    begin
      MR.pon_e(k,j, k+j);
      MA.pon_e(j,k, k+j);
    end;

  writeln( 'NContinuas: ', CF.nVarsContinuas );
  writeln( 'NDiscretas: ', CF.nVarsDiscretas );
  writeln( 'NPuntosT: ', CF.nPuntosT );
  writeln( 'NEstrellitas: ', CF.nEstrellasPorPuntoT );


  error:= 0;
  CF.setEstrellaCERO;
  repeat
    CF.SetEstadoToEstrella;

    for k:= 0 to CF.nVarsContinuas-1 do
        x.pon_e( k+1, CF.xr[k] );
    //se carga el costo futuro para una estrella del tiempo kPuntoT
    cx:= CF.costoEstrella( kPuntoT );
    write ('cx=',cx:4:2);

    (*a seguir se crea un nuevo vector de estado x multiplicando el viejo
    por las matrices Mr y Ma*)
    MR.Transformar( y, x );  (* toma el vector x lo multiplica por la matriz
    Mr y deja el resultado en Y*)
    MA.Transformar( x, y );

    for k:= 0 to CF.nVarsContinuas-1 do
        CF.xr[k]:= x.e(k+1);
    (* se calcula el CF para una estrella nueva que no es ninguna de las ya
    conocidas. Para esto se itera *)
    cy:= CF.costoContinuo( kPuntoT );
    error:= error + sqr(cx - cy );
  until not CF.IncEstrella;

  writeln( 'ERROR: ', error: 12:5 );
  x.free;
  y.free;
  MA.Free;
  MR.Free;
end;

procedure TForm1.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
   if CF <> nil then CF.free;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   CF:= nil;
end;

end.

