unit uredcfgen;


interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ActnList, Grids, ExtCtrls, uestados, xmatdefs, MatReal, optimizadorreductor,
  dbPlanesPruebareductor, uplanreductor;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    ComboBox1: TComboBox;
    Edit1: TEdit;
    EditPoblacionInicial: TEdit;
    EditMaxIter: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    LabelTimeInit: TLabel;
    LabelTimeFin: TLabel;
    StringGrid1: TStringGrid;
    StringGrid2: TStringGrid;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure TimerReductorTimer(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;
{TCadenaAdn}
TCadenaAdn = Class
 ReductorDeEstados: Array of TDAofNReal;
 //adn
 MR, MA: TMatR;
 // y seria el vector de estado de dimension m<n reducido
 x, y: TVectR;
 Xmin,Xmax: NReal;
 Error:NReal;
 kPuntoT,m,n: integer;
 function XToWord(X:NReal):word;
 function WordToX(R:word):NReal;
 procedure Evaluar;
 Constructor Create;
end;



var
  Form1: TForm1; 
  CF: TAdminEstados;
  a:TCadenaAdn;
 { x, y: TVectR;}
  AUXILIAR:NReal;

 //hola mundo


implementation

{$R *.lfm}

{ TForm1 }
Constructor TCadenaAdn.Create;
begin
inherited create;
 n:= CF.nVarsContinuas; //cantidad de variables continuas
 m:=  n-1;    //defino la dimension del nuevo espacio de estados
 y:= TVectR.Create_init( m );   //empieza en 0
 x:= TVectR.Create_init( n );
 MR:= TMatR.Create_Init( m, n );  //empiezo en fila 1 no 0
 MA:= TMatR.Create_init( n, m );
 kPuntoT:= INDTIEMPO ;
 (*inicializo a un punto de tiempo luego esto va a tener que ser
   un parametro *)
   (* acordarse que KPuntoT es el indice de tiempo y no el tiempo KPuntoT
   para obtener el tiempo k  hay que hacer N-KPuntoT siendo N la dimension
   del espacio de tiempo*)
 error:= 0;
end;

Function TCadenaAdn.XToWord(x:NReal):word;
{var
  Z :TCadenaAdn;
  A:array of TDAofNReal;}
Begin
  {A:= Z.ReductorDeEstados;}

end;
Function TCadenaAdn.wordToX(R:word):NReal;
Begin

end;


procedure TForm1.Button1Click(Sender: TObject);
var
  k, j: integer;

begin
 if CF = nil then
  CF :=  TAdminEstados.CreateLoadFromArchi( 'CF.bin' );
  //varsContinuas son las variables que necesitan ser discretizadas
  //VarsDiscretas son las variables enteras que ya están discretizadas

 a:= TCadenaAdn.Create;


 (* A CONTINUACION COMPLETO A LAS MATRICES CON VALORES ARBITRARIOS(K+J)
 LUEGO ME  LO TENDRA QUE DAR EL ALGORITMO GENETICO*)
 for k:= 1 to a.m do
  for j:= 1 to a.n do
   begin
    a.MR.pon_e(k,j, k+j);
    a.MA.pon_e(j,k, k+j);
   end;

 writeln( 'NContinuas: ', CF.nVarsContinuas );
 writeln( 'NDiscretas: ', CF.nVarsDiscretas );
 writeln( 'NPuntosT: ', CF.nPuntosT );
 writeln( 'NEstrellitas: ', CF.nEstrellasPorPuntoT );
 a.Evaluar;
 writeln( 'ERROR: ', a.error: 12:5 );
 a.Free;

end;

procedure TForm1.Button2Click(Sender: TObject);
begin
   Writeln('comienza optimizacion...');
   randomize;
   optimizadorreductor.NPOBLACION_PARTIDA:=StrToInt(EditPoblacionInicial.Text);
   optimizadorreductor.MAX_ITER:=StrToInt(EditMaxIter.Text);
   LabelTimeFin.Caption := '';
   LabelTimeInit.Caption := TimeToStr(Time);
   OptimizarPoblacion;
   LabelTimeFin.Caption := TimeToStr(Time);
   Writeln('Optimizacion finalizada...');
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  plan : TPlanReductor;
  idPlan : String;
  i,j,m,n    : Integer;
begin



 //selecciono el plan
 idPlan := ComboBox1.Text;
 plan	:= returnOne(StrToInt(idPlan));

 m:=plan.m;
 n:=plan.n;

 //matriz reductora
 for i:=1 to m do
  for j:=1 to n do
      StringGrid1.Cells[j,i] := FloatToStr(plan.MR.e(i,j));

 //matriz amplificadora
 for i:=1 to n do
  for j:=1 to m do
      StringGrid2.Cells[j,i] := FloatToStr(plan.MA.e(i,j));


 //cargar error
 Edit1.Text:=FloatToStr(plan.fCriterio1);


end;

procedure TForm1.Button4Click(Sender: TObject);
var
  arrPlanes : TDaOfTPlanPrueba;
  NIndividuos,i : Integer;
  plan : TPlanReductor;
begin
  //rellenar el combobox
  combobox1.Clear;
   NIndividuos := Poblacion_Count;
  setlength(arrPlanes, NIndividuos);

  arrPlanes:=dbPlanesPruebaReductor.returnOrdList(NIndividuos, 0);

  for i := 0 to NIndividuos - 1 do
   begin
        plan := arrPlanes[i];
        ComboBox1.Items.add(IntToStr(Plan.IdPlan));
    end;

end;


procedure TForm1.ComboBox1Change(Sender: TObject);
begin

end;



 procedure TCadenaAdn.Evaluar;
 var
  k:Integer;
  cx, cy: NReal;
 begin
  CF.setEstrellaCERO;
  repeat
   CF.SetEstadoToEstrella;
   for k:= 0 to CF.nVarsContinuas-1 do
   begin
    x.pon_e( k+1, CF.xr[k] );
    writeln('x=',x.e(k+1):3:2);
   end;
   cx:= CF.costoEstrella( kPuntoT );
   (*a seguir se crea un nuevo vector de estado x multiplicando el viejo
   por las matrices Mr y Ma*)
   MR.Transformar( y, x ); (*tomar vector X multiplicarlo por la matriz MR
   y obtener el vector y*)
   MA.Transformar( x, y );
   for k:= 0 to CF.nVarsContinuas-1 do
    CF.xr[k]:= x.e(k+1);
   (* se calcula el CF para una estrella nueva que no es ninguna de las ya
   conocidas. Para esto se itera *)
   cy:= CF.costoContinuo( kPuntoT );
   a.error:= a.error + sqr(cx - cy );
   (*tenemos una forma de determinar cuando terminamos el algoritmo
   evaluando cuando entre una iteracion y la siguiente ya no mejora mas*)
  until not CF.IncEstrella;
 end;

procedure TForm1.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
 if CF <> nil then CF.free;

end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 CF:= nil;
 {a.Create;}
end;

procedure TForm1.TimerReductorTimer(Sender: TObject);
begin

end;

end.

