//simula el comportamiento de un actor : simplex de dos variables
unit uactor1;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Math, xMatDefs, matreal,
  ubibfun_onl, udescripcionproblema_onl;

var
   my_idvar, my_ivae, my_ires : NInt;
   x_opt, mi_func_opt : NReal;

procedure opt_nvers(var ivar, ivae, ires: NInt);
procedure opt_cargue(p: TProblema_onl);
procedure opt_fijarRestriccionesDeCaja(p: TProblema_onl);
procedure opt_LeerSolucion(p: TProblema_onl);

implementation

procedure opt_nvers(var ivar, ivae, ires: NInt);
begin
     //guardo donde comienzan mis variables
     my_idvar := ivar;
     my_ivae := ivae;
     my_ires := ires;

     ivar := ivar + 2;  //agrego varibables
     ires := ires + 2;  //agrego restricciones
end;

procedure opt_cargue(p: Tproblema_onl);
var
   mf : TFunc_CombinacionLineal;
   vc : TVectR;
   vIdvars : TDAOFNInt;
   res: TFunc_CombinacionLineal;
begin
     //agregar función de costo : 2*x1 + x2
     vc:=TVectR.Create_Init(2); vc.pon_e(1,2); vc.pon_e(2,1);
     mf := TFunc_CombinacionLineal.Create_Init(2, vc);
     setlength(vIdVars,2); vIdvars[0]:=my_idvar; vIdvars[1]:=my_idvar+1;
     mf.SetIdVars(vIdVars);
     p.AgregarFObjetivo(mf);

     //restriccion 1 : x1 + x2 >= 4
     vc:=TVectR.Create_Init(2); vc.pon_e(1,1); vc.pon_e(2,1);
     res := TFunc_CombinacionLineal.Create_Init(2, vc, -4);
     setlength(vIdVars,2); vIdvars[0]:=my_idvar; vIdvars[1]:=my_idvar+1;
     res.SetIdVars(vIdVars);
     p.AgregarRestriccionDeDesigualdad(res);


     //restriccion 2 : 3*x1 + x2 >= 6
     vc:=TVectR.Create_Init(2); vc.pon_e(1,3); vc.pon_e(2,1);
     res := TFunc_CombinacionLineal.Create_Init(2, vc, -6);
     setlength(vIdVars,2); vIdvars[0]:=my_idvar; vIdvars[1]:=my_idvar+1;
     res.SetIdVars(vIdVars);
     p.AgregarRestriccionDeDesigualdad(res);


     //restriccion 3 : x1 >= 0
     vc:=TVectR.Create_Init(1);
     vc.pon_e(1,1);
     res := TFunc_CombinacionLineal.Create_Init(1, vc);
     setlength(vIdVars,2); vIdvars[0]:=my_idvar; vIdvars[1]:=my_idvar+1;
     res.SetIdVars(vIdVars);
     p.AgregarRestriccionDeDesigualdad(res);


     //restriccion 4 : x2 >= 0
     vc.pon_e(1,1);
     res := TFunc_CombinacionLineal.Create_Init(1, vc);
     setlength(vIdVars,2); vIdvars[0]:=my_idvar; vIdvars[1]:=my_idvar+1;
     res.SetIdVars(vIdVars);
     p.AgregarRestriccionDeDesigualdad(res);

end;

procedure opt_fijarRestriccionesDeCaja(p: TProblema_onl);
begin
    //sin terminar
end;

procedure opt_LeerSolucion(p: TProblema_onl);
begin
     x_opt := p.xval(my_idvar);
     mi_func_opt := p.fval();
end;


end.

