unit uex_17_TFunc_Bloque_Productoria;
//min f(x) = (x1-6)**2 + (x2-7)**2
//s.a.
//     g1 : -3*x1-2*x2+6 <= 0
//     g2 : -x1+x2-3 <= 0
//     g3 : x1+x2-7 <= 0
//     g4 : 2/3*x1-x2-4/3 <= 0
//ejemplo 17 de las notas del MIT pero utilizando la clase TFunc_Bloque_Productoria
//para definir la función objetivo
{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Math, xMatDefs, matreal,
  ubibfun_onl, udescripcionproblema_onl;

var
   my_idvar, my_ivae, my_ires : NInt;
   x_opt, mi_func_opt : NReal;

procedure opt_nvers(var ivar, ivae, ires: NInt);
procedure opt_cargue(p: TProblema_onl);
procedure opt_fijarRestriccionesDeCaja(p: TProblema_onl);
procedure opt_LeerSolucion(p: TProblema_onl);

implementation

procedure opt_nvers(var ivar, ivae, ires: NInt);
begin
     //guardo donde comienzan mis variables
     my_idvar := ivar;
     my_ivae := ivae;
     my_ires := ires;

     ivar := ivar + 2;   //agrego dos variables
     ires := ires + 4;  //agrego cuatro restricciones
end;


procedure opt_cargue(p: Tproblema_onl);
var
   mf : TFunc_UD;
   idv: TDAOfNInt;
   vIdVars : TDAOfNInt;
   res: TFunc_CombinacionLineal;
   pol_1, pol_2 : TFunc_Polinomio;
   vc : TVectR;
   fbp : TFunc_Bloque_Productoria;
begin
     //agregar función de costo
     vc:=TVectR.Create_Init(1); vc.pon_e(1,1);
     res:=TFunc_CombinacionLineal.Create_Init(1,vc,-6);
     setlength(vIdVars,1); vIdVars[0] := my_idvar;
     res.setIdVars(vIdVars);
     fbp:=TFunc_Bloque_Productoria.Create();
     fbp.Agregar_f(res);
     fbp.Agregar_f(res);
     p.AgregarFObjetivo(fbp);

     vc:=TVectR.Create_Init(1); vc.pon_e(1,1);
     res:=TFunc_CombinacionLineal.Create_Init(1,vc,-7);
     setlength(vIdVars,1); vIdVars[0]:= my_idvar+1;
     res.setIdVars(vIdVars);
     fbp:=TFunc_Bloque_Productoria.Create();
     fbp.Agregar_f(res);
     fbp.Agregar_f(res);
     p.AgregarFObjetivo(fbp);

     //AGREGAR RESTRICCIONES

     setlength(vIdVars,2); vIdvars[0]:=my_idvar; vIdvars[1]:=my_idvar+1;

     //g1
     vc:=TVectR.Create_Init(2); vc.pon_e(1,3); vc.pon_e(2,2);
     res := TFunc_CombinacionLineal.Create_Init(2, vc, -3);
     res.SetIdVars(vIdVars);
     p.AgregarRestriccionDeDesigualdad(res);


     //g2
     vc:=TVectR.Create_Init(2); vc.pon_e(1,1); vc.pon_e(2,-1);
     res := TFunc_CombinacionLineal.Create_Init(2, vc, 3);
     res.SetIdVars(vIdVars);
     p.AgregarRestriccionDeDesigualdad(res);


     //g3
     vc:=TVectR.Create_Init(2); vc.pon_e(1,-1); vc.pon_e(2,-1);
     res := TFunc_CombinacionLineal.Create_Init(2, vc, 7);
     res.SetIdVars(vIdVars);
     p.AgregarRestriccionDeDesigualdad(res);

     //g4
     vc:=TVectR.Create_Init(2); vc.pon_e(1,-2/3); vc.pon_e(2,1);
     res := TFunc_CombinacionLineal.Create_Init(2, vc, 4/3);
     res.SetIdVars(vIdVars);
     p.AgregarRestriccionDeDesigualdad(res);

end;

procedure opt_fijarRestriccionesDeCaja(p: TProblema_onl);
begin
    //sin terminar
end;

procedure opt_LeerSolucion(p: TProblema_onl);
begin
     x_opt := p.xval(my_idvar);
     mi_func_opt := p.fval();
end;


end.

