//simula el comportamiento de un actor : simplex de dos variables
//con restricciones de igualdad y de desigualdad y restricciones de caja para
//las variables x1, x2. todas lineales.

unit uex_mixed_spx_c3;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Math, xMatDefs, matreal,
  ubibfun_onl, udescripcionproblema_onl, usimplex;

var
   my_idvar, my_ivae, my_ires : NInt;
   x_opt, mi_func_opt : NReal;

procedure opt_nvers(var ivar, ivae, ires: NInt);
procedure opt_cargue(p: TProblema_onl);
procedure opt_fijarRestriccionesDeCaja(p: TProblema_onl);
procedure opt_LeerSolucion(p: TProblema_onl);

implementation

procedure opt_nvers(var ivar, ivae, ires: NInt);
begin
     //guardo donde comienzan mis variables
     my_idvar := ivar;
     my_ivae := ivae;
     my_ires := ires;

     ivar := ivar + 2;
     ires := ires + 2;
end;

procedure opt_cargue(p: Tproblema_onl);
var
   mf : TFunc_CombinacionLineal;
   vc : TVectR;
   vIdvars : TDAOFNInt;
   res: TFunc_CombinacionLineal;
   spx : TSimplex;
begin

  //crear simplex:
  spx:= TSimplex.Create_init(3, 3, NIL, NIL);

   //Cargamos la fila objetivo z
  spx.pon_e(spx.nf, 1, -2);
  spx.pon_e(spx.nf, 2, -1);

  //restricción r1
  spx.pon_e(1, 1, -2/3);
  spx.pon_e(1, 2, -1);
  spx.pon_e(1, spx.nc, 2);

  //restricción r3, de igualdad
  spx.pon_e(2, 1, 1);
  spx.pon_e(2, 2, -1);
  spx.pon_e(2, spx.nc, -4);
  spx.FijarRestriccionIgualdad(2);

  p.spx:=spx;

  //Vuelco el simplex al archivo 'ProblemaEjemplo.xlt' para verificar
  //que el problema armado sea el que quería
 // spx.DumpSistemaToXLT('Problema_uactor1.xlt', '');
end;

procedure opt_fijarRestriccionesDeCaja(p: TProblema_onl);
begin
  //restricciones de caja de x1
  p.spx.cota_inf_set(1, 0);
  p.spx.cota_sup_set(1,4);

  //restricciones de caja de x2
  p.spx.cota_inf_set(2, -2);
  p.spx.cota_sup_set(2, 2);
end;

procedure opt_LeerSolucion(p: TProblema_onl);
begin
     x_opt := p.xval(my_idvar);
     mi_func_opt := p.fval();
end;


end.

