//simula el comportamiento de un actor : simplex de tres variables
//pero solo dos de ellas intervienen en la función de costo
unit uex_mixed_spx_c4;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Math, xMatDefs, matreal,
  ubibfun_onl, udescripcionproblema_onl, usimplex;

var
   my_idvar, my_ivae, my_ires : NInt;
   x_opt, mi_func_opt : NReal;

procedure opt_nvers(var ivar, ivae, ires: NInt);
procedure opt_cargue(p: TProblema_onl);
procedure opt_fijarRestriccionesDeCaja(p: TProblema_onl);
procedure opt_LeerSolucion(p: TProblema_onl);

implementation

procedure opt_nvers(var ivar, ivae, ires: NInt);
begin
     //guardo donde comienzan mis variables
     my_idvar := ivar;
     my_ivae := ivae;
     my_ires := ires;

     ivar := ivar + 3;
     ires := ires + 2;
end;

procedure opt_cargue(p: Tproblema_onl);
var
   mf : TFunc_CombinacionLineal;
   vc : TVectR;
   vIdvars : TDAOFNInt;
   res: TFunc_CombinacionLineal;
   spx : TSimplex;
begin

  //crear simplex:
  spx:= TSimplex.Create_init(3, 4, NIL, NIL);

  //Cargamos la fila objetivo z
  spx.pon_e(spx.nf, 1, -2);
  spx.pon_e(spx.nf, 2, -1);

  //restricción r1
  spx.pon_e(1, 1, 1/3);
  spx.pon_e(1, 2, 1);
  spx.pon_e(1, 3, 0);
  spx.pon_e(1, spx.nc, -1);

  //restricción r2, de igualdad
  spx.pon_e(2, 1, 0);
  spx.pon_e(2, 2, 1);
  spx.pon_e(2,3,1);
  spx.pon_e(2, spx.nc, -5);
  spx.FijarRestriccionIgualdad(2);

  p.spx:=spx;


end;

procedure opt_fijarRestriccionesDeCaja(p: TProblema_onl);
begin

  p.spx.cota_inf_set(1, 0);
  p.spx.cota_inf_set(2, 0);
  p.spx.cota_inf_set(3, 0);

end;

procedure opt_LeerSolucion(p: TProblema_onl);
begin
     x_opt := p.xval(my_idvar);
     mi_func_opt := p.fval();
end;
end.

