//prueba el algoritmo de linesearch cuadrático
unit main;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  xmatdefs, matreal,
  linesearchCuadratico;

type

  { TForm1 }

  TForm1 = class(TForm)
   Button1: TButton;
   procedure Button1Click(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 

implementation

{$R *.lfm}

{ TForm1 }

procedure TForm1.Button1Click(Sender: TObject);
var
  x0,x1,x2: NReal;
  f0,f1,f2: NReal;
  TolX, TolFun: NReal;
  kmax: NInt;
  xopt: NReal;
  kniters: NInt;
begin
     x0:=0.0; x1:= 1.0; x2:= 3.0;
     f0:=linesearchCuadratico.evaluar(x0);
     f1:=linesearchCuadratico.evaluar(x1);
     f2:=linesearchCuadratico.evaluar(x2);
     TolX:=1e-6;
     TolFun:=1e-8;
     kmax:=25;

     xopt:= linesearchCuadratico.opt_quad(x0,x1,x2,f0,f1,f2,TolX,TolFun,kmax,kniters);

     writeln('. . . resultado, xopt = ',xopt:4:4);
     writeln('. . . num iters, kniters = ',kniters);
end;

end.

