//en esta unit se ensayan los algoritmos de ONL.

unit onl_sj;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, ComCtrls, Menus, ActnList, types,
  ugestor, matreal, xMatDefs, parametrosGlobales;

type

  { TFormMain }

  TFormMain = class(TForm)
   ButtonRecorrerSala: TButton;
    ButtonImprimirResultados: TButton;
    ButtonOptimizar: TButton;
    ButtonImprimirRestricciones: TButton;
    ButtonEspecificarCoeficientesFC: TButton;
    ButtonFuncionDeCosto: TButton;
    CBAlgoritmo: TComboBox;
    CheckBox1: TCheckBox;
    CBEscenario: TComboBox;
    CBLinesearchMethod: TComboBox;
    ComboBoxSelTipo: TComboBox;
    GBAgregarTermino: TGroupBox;
    GBAgregarRestriccion: TGroupBox;
    GBTestingPreliminar: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label5: TLabel;
    MainMenu1: TMainMenu;
    MemoDescripcionAlgoritmos: TMemo;
    MemoDescripcionEscenario: TMemo;
    MenuItemSalir: TMenuItem;
    PCMain: TPageControl;
    SB: TStatusBar;
    TSAuxiliares: TTabSheet;
    TSOptimizar: TTabSheet;
    TSAlgoritmoDeOptimizacion: TTabSheet;
    TSRestricciones: TTabSheet;
    TSFuncionDeCosto: TTabSheet;
    procedure ButtonEspecificarCoeficientesFCClick(Sender: TObject);
    procedure ButtonImprimirEnArchivoClick(Sender: TObject);
    procedure ButtonImprimirRestriccionesClick(Sender: TObject);
    procedure ButtonOptimizarClick(Sender: TObject);
    procedure ButtonOptimizarFuncionEscalarConLineSearchCuadraticoClick(
     Sender: TObject);
    procedure ButtonRecorrerSalaClick(Sender: TObject);
    procedure CBAlgoritmoChange(Sender: TObject);
    procedure CBEscenarioChange(Sender: TObject);
    procedure ComboBoxSelTipoChange(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure GBAgregarTerminoClick(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure MemoDescripcionAlgoritmosChange(Sender: TObject);
    procedure MenuItem1Click(Sender: TObject);
    procedure MenuItemSalirClick(Sender: TObject);
    procedure PageControl2ContextPopup(Sender: TObject; MousePos: TPoint;
      var Handled: Boolean);
    procedure TabControl1Change(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  FormMain: TFormMain;

implementation

{$R *.lfm}

{ TFormMain }

procedure TFormMain.MenuItemSalirClick(Sender: TObject);
begin
  Close;
end;

procedure TFormMain.PageControl2ContextPopup(Sender: TObject; MousePos: TPoint;
  var Handled: Boolean);
begin

end;

procedure TFormMain.TabControl1Change(Sender: TObject);
begin

end;

procedure TFormMain.MenuItem1Click(Sender: TObject);
begin
  Close;
end;

procedure TFormMain.ListBox1Click(Sender: TObject);
begin

end;

procedure TFormMain.MemoDescripcionAlgoritmosChange(Sender: TObject);
begin

end;

procedure TFormMain.ComboBoxSelTipoChange(Sender: TObject);
begin

end;

procedure TFormMain.Edit1Change(Sender: TObject);
begin

end;

procedure TFormMain.FormCreate(Sender: TObject);
begin

end;

procedure TFormMain.GBAgregarTerminoClick(Sender: TObject);
begin

end;

procedure TFormMain.ButtonEspecificarCoeficientesFCClick(Sender: TObject);
begin

end;

procedure TFormMain.ButtonImprimirEnArchivoClick(Sender: TObject);
var
   fileOut		:	TextFile;
   XOpt         :   TVectR;
   i            :   NInt;
begin
     AssignFile(fileOut, 'salida_onl.txt');
     //assign (fileOut, 'salida_onl.txt');
     rewrite (fileOut);


     XOpt := TVectR.Create_Clone(ugestor.XOpt);

     writeln('- - - - - - - - - - - - - - - - - - - - - - - - - - - -  ');
     for i:= 1 to XOpt.n do
     begin
       writeln(fileOut, 'variable # ',i, ' valor optimo = ', XOpt.e(i-1));
       writeln('variable # ',i, ' valor optimo = ', XOpt.e(i-1));
     end;

     CloseFile(fileOut);
     writeln('- - - - - - - - - - - - - - - - - - - - - - - - - - - -  ');
     SB.SimpleText:= 'la salida se copió en salida_onl.txt';

end;

procedure TFormMain.ButtonImprimirRestriccionesClick(Sender: TObject);
begin

end;

procedure TFormMain.ButtonOptimizarClick(Sender: TObject);
begin
  if (CBAlgoritmo.Text ='Steepest Descent Method (sin restricciones)') then
     parametrosGlobales.AlgoritmoDeOptimizacion:=parametrosGlobales.Steepest_Descent_Method
  else if (CBAlgoritmo.Text ='Método de Penalización (con restricciones, relajación)') then
     parametrosGlobales.AlgoritmoDeOptimizacion:=parametrosGlobales.Penalizacion;
end;

procedure TFormMain.ButtonOptimizarFuncionEscalarConLineSearchCuadraticoClick(
 Sender: TObject);
begin

end;

procedure TFormMain.ButtonRecorrerSalaClick(Sender: TObject);
begin

  //setear algoritmo de optimización
  if (CBAlgoritmo.Text = '') then begin
     SB.SimpleText:='error: debe elegir el algoritmo de optimización';
     exit();
  end;
  if (CBAlgoritmo.Text[1] ='1') then
     parametrosGlobales.AlgoritmoDeOptimizacion:=parametrosGlobales.Steepest_Descent_Method
  else if (CBAlgoritmo.Text[1] = '2') then
     parametrosGlobales.AlgoritmoDeOptimizacion := parametrosGlobales.Penalizacion
  else if (CBAlgoritmo.Text[1] = '3') then
     parametrosGlobales.AlgoritmoDeOptimizacion := parametrosGlobales.Penalizacion_Con_Igualdades
  else if (CBAlgoritmo.Text[1] = '4') then
     parametrosGlobales.AlgoritmoDeOptimizacion := parametrosGlobales.Penalizacion_Con_Igualdades_m3
  else begin
     SB.SimpleText:='error: el módulo de optimización seleccionado no está disponible';
     exit();
  end;
     //setear escenario
     parametrosGlobales.Escenario:=CBEscenario.Text;

     SB.SimpleText:='ingresando a la sala. . .';

     ugestor.recorrerSala();

     SB.SimpleText:='optimizacion terminada';


end;

procedure TFormMain.CBAlgoritmoChange(Sender: TObject);
begin
 CBLinesearchMethod.Clear;
 if CBAlgoritmo.Text[1] = '1' then begin
    CBLinesearchMethod.Items.Add('Linesearch cuadrático');
 end else if CBAlgoritmo.Text[1] = '2' then begin
    CBLinesearchMethod.Items.Add('Criterio de Armijo');
    CBLinesearchMethod.Items.Add('Cuadrático');
    CBLinesearchMethod.Items.Add('Reducción constante: alfa_k <- alfa_k / C');
 end;

 //agrego descripción en el memo
 MemoDescripcionAlgoritmos.Lines.Clear;
 if CBAlgoritmo.Text[1]='1' then begin
    MemoDescripcionAlgoritmos.Lines.Add('optimización global sin restricciones');
    MemoDescripcionAlgoritmos.Lines.Add('por el método de máximo descenso');
 end;
  if CBAlgoritmo.Text[1]='2' then begin
    MemoDescripcionAlgoritmos.Lines.Add('optimización por el método de penalización cuadrática');
    MemoDescripcionAlgoritmos.Lines.Add('solo maneja restricciones de >= 0');
 end;
   if CBAlgoritmo.Text[1]='3' then begin
    MemoDescripcionAlgoritmos.Lines.Add('optimización c restr por el método de penalización cuadrática');
    MemoDescripcionAlgoritmos.Lines.Add('maneja restricciones de desigualdad y de igualdad');
    MemoDescripcionAlgoritmos.Lines.Add('las restricciones de igualdad son ponderadas en los puntos de no factibilidad <> 0 por una función de costo cuadrática');

 end;
    if CBAlgoritmo.Text[1]='4' then begin
    MemoDescripcionAlgoritmos.Lines.Add('optimización c restr por el método de penalización cuadrática');
    MemoDescripcionAlgoritmos.Lines.Add('maneja restricciones de desigualdad y de igualdad');
    MemoDescripcionAlgoritmos.Lines.Add('cada restricción de igualdad se cambia por dos restricciones de desigualdad que se van activando');

 end;

end;

procedure TFormMain.CBEscenarioChange(Sender: TObject);
begin
 MemoDescripcionEscenario.Lines.Clear;
 if CBEscenario.Text='uactor1' then begin
    MemoDescripcionEscenario.Lines.Add('simplex : dos variables, restricciones de desigualdad');
    MemoDescripcionEscenario.Lines.Add('');
    MemoDescripcionEscenario.Lines.Add('min :  2x1 + x2');
    MemoDescripcionEscenario.Lines.Add('restriccion 1 : x1 + x2 >= 4');
    MemoDescripcionEscenario.Lines.Add('restriccion 2 : 3x1 + x2 >= 6');
    MemoDescripcionEscenario.Lines.Add('x1 >= 0 , x2 >= 0');
    MemoDescripcionEscenario.Lines.Add('óptimo (1 , 3)');
 end;

 if CBEscenario.Text='uactor2' then begin
    MemoDescripcionEscenario.Lines.Add('Rosenbrock parabolic valley (sin restricciones)');
    MemoDescripcionEscenario.Lines.Add('');
    MemoDescripcionEscenario.Lines.Add('min :  100*(x2-x1*x1)**2 + (1 - x1)**2');
    MemoDescripcionEscenario.Lines.Add('');
    MemoDescripcionEscenario.Lines.Add('óptimo = (1, 1)');
 end;

 if CBEscenario.Text='uex_17' then begin
    MemoDescripcionEscenario.Lines.Add('función de costo parabólica con restricciones lineales');
    MemoDescripcionEscenario.Lines.Add('');
    MemoDescripcionEscenario.Lines.Add('min f(x) = (x1-6)**2 + (x2-7)**2');
    MemoDescripcionEscenario.Lines.Add('');
    MemoDescripcionEscenario.Lines.Add('s.a.:');
    MemoDescripcionEscenario.Lines.Add('g1 : -3*x1-2*x2+6 <= 0');
    MemoDescripcionEscenario.Lines.Add('g2 : -x1+x2-3 <= 0');
    MemoDescripcionEscenario.Lines.Add('g3 : x1+x2-7 <= 0');
    MemoDescripcionEscenario.Lines.Add('g4 : 2/3*x1-x2-4/3 <= 0');
    MemoDescripcionEscenario.Lines.Add('//ejemplo 17 de las notas del MIT');
    MemoDescripcionEscenario.Lines.Add('');
    MemoDescripcionEscenario.Lines.Add('óptimo = (3 , 4)');
 end;

 if CBEscenario.Text='uactor1cargandospx' then begin
    MemoDescripcionEscenario.Lines.Add('el simplex de uactor1 pero cargando de entrada un simplex (i.e. p.spx <> nil)');
    MemoDescripcionEscenario.Lines.Add('');
    MemoDescripcionEscenario.Lines.Add('min :  2x1 + x2');
    MemoDescripcionEscenario.Lines.Add('restriccion 1 : x1 + x2 >= 4');
    MemoDescripcionEscenario.Lines.Add('restriccion 2 : 3x1 + x2 >= 6');
    MemoDescripcionEscenario.Lines.Add('x1 >= 0 , x2 >= 0');
    MemoDescripcionEscenario.Lines.Add('óptimo (1 , 3)');
 end;

 if CBEscenario.Text='uex_mixed_spx_c1' then begin
    MemoDescripcionEscenario.Lines.Add('simplex : dos variables');
    MemoDescripcionEscenario.Lines.Add('');
    MemoDescripcionEscenario.Lines.Add('min :  2 x1 + x2');
    MemoDescripcionEscenario.Lines.Add('0 <= x1 <= 4,   -2 <= x2 <= 2');
    MemoDescripcionEscenario.Lines.Add('');
    MemoDescripcionEscenario.Lines.Add('óptimo A = (0, -2)');
 end;

 if CBEscenario.Text='uex_mixed_spx_c2' then begin
    MemoDescripcionEscenario.Lines.Add('simplex : dos variables');
    MemoDescripcionEscenario.Lines.Add('');
    MemoDescripcionEscenario.Lines.Add('min :  2 x1 + x2');
    MemoDescripcionEscenario.Lines.Add('0 <= x1 <= 4,   -2 <= x2 <= 2');
    MemoDescripcionEscenario.Lines.Add('s.a. : r1) x2 <= -2/3 x1 + 2');
    MemoDescripcionEscenario.Lines.Add('        r2) x2 = x1 - 1');
    MemoDescripcionEscenario.Lines.Add('');
    MemoDescripcionEscenario.Lines.Add('óptimo B = (0, -1)');
 end;

 if CBEscenario.Text='uex_mixed_spx_c3' then begin
    MemoDescripcionEscenario.Lines.Add('simplex : dos variables');
    MemoDescripcionEscenario.Lines.Add('');
    MemoDescripcionEscenario.Lines.Add('min :  2 x1 + x2');
    MemoDescripcionEscenario.Lines.Add('0 <= x1 <= 4,   -2 <= x2 <= 2');
    MemoDescripcionEscenario.Lines.Add('s.a. : r1) x2 <= -2/3 x1 + 2');
    MemoDescripcionEscenario.Lines.Add('        r3) x2 = x1 - 4');
    MemoDescripcionEscenario.Lines.Add('');
    MemoDescripcionEscenario.Lines.Add('óptimo C = (2, -2)');
 end;
end;



end.

