unit ugestor;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, xMatDefs, matreal,
  uactor1,
  uactor2,
  uex_17,
  udescripcionproblema_onl,
  uactor1cargandospx,
  ubibfun_onl,
  uex_mixed_spx_c1,
  uex_mixed_spx_c2,
  uex_mixed_spx_c3,
  udump_simsee_1,
  uex_mixed_spx_c4,
  parametrosGlobales;

var
  XOpt : TVectR;
  currentProblema : TProblema_onl;
  ivar : NInt;    //índice de las variables de control
  ires : NInt;    //índice de restricciones adicionales
  ivae : NInt;    //índice de variables enteras

procedure recorrerSala();

implementation

procedure recorrerSala();
var
  p : TProblema_onl;
  a:NREal;
  x1sup, x1inf, x2sup, x2inf : NReal;
  pol_aux : TFunc_Polinomio;
  vcaux, xeval,xgrad : TVectR;
  xaux1, xaux2 : NReal;
  idV:TDAOfNInt;
begin

  //cada ACTOR dice la cantidad de variables de optimización que se deben asignar
  //para él asi como la cantidad de restricciones que él quiere imponer
  ivar := 1;
  ires := 1;
  ivae := 1;

  if (parametrosGlobales.Escenario='uactor2') then begin
     uactor2.opt_nvers(ivar, ivae, ires);
     p := TProblema_onl.Create_Init(ires, ivar);
     uactor2.opt_cargue(p);
     uactor2.opt_fijarRestriccionesDeCaja(p);
     p.Resolver();
     uactor2.opt_LeerSolucion(p);
  end
  else if (parametrosGlobales.Escenario='uactor1') then begin
     uactor1.opt_nvers(ivar, ivae, ires);
     p := TProblema_onl.Create_Init(ires, ivar);
     uactor1.opt_cargue(p);
     uactor1.opt_fijarRestriccionesDeCaja(p);
     p.Resolver();
     uactor1.opt_LeerSolucion(p);
  end
  else if (parametrosGlobales.Escenario='uex_17') then begin
     uex_17.opt_nvers(ivar, ivae, ires);
     p := TProblema_onl.Create_Init(ires, ivar);
     uex_17.opt_cargue(p);
     uex_17.opt_fijarRestriccionesDeCaja(p);
     p.Resolver();
     uex_17.opt_LeerSolucion(p);
  end
  else if (parametrosGlobales.Escenario='uactor1cargandospx') then begin
    uactor1cargandospx.opt_nvers(ivar, ivae, ires);
    p := TProblema_onl.Create_Init(ires, ivar);
    uactor1cargandospx.opt_cargue(p);
    uactor1cargandospx.opt_fijarRestriccionesDeCaja(p);
    p.Resolver();
    uactor1cargandospx.opt_LeerSolucion(p);
  end
  else if (parametrosGlobales.Escenario='uex_mixed_spx_c1') then begin
    uex_mixed_spx_c1.opt_nvers(ivar, ivae, ires);
    p := TProblema_onl.Create_Init(ires, ivar);
    uex_mixed_spx_c1.opt_cargue(p);
    uex_mixed_spx_c1.opt_fijarRestriccionesDeCaja(p);
    p.Resolver();
    uex_mixed_spx_c1.opt_LeerSolucion(p);
  end
  else if (parametrosGlobales.Escenario='uex_mixed_spx_c2') then begin
    uex_mixed_spx_c2.opt_nvers(ivar, ivae, ires);
    p := TProblema_onl.Create_Init(ires, ivar);
    uex_mixed_spx_c2.opt_cargue(p);
    uex_mixed_spx_c2.opt_fijarRestriccionesDeCaja(p);

      //Vuelco el simplex al archivo 'ProblemaEjemplo.xlt' para verificar
  //que el problema armado sea el que quería
 // p.spx.DumpSistemaToXLT('uc2.xlt', '');

    p.Resolver();
    uex_mixed_spx_c2.opt_LeerSolucion(p);
  end
  else if (parametrosGlobales.Escenario='uex_mixed_spx_c3') then begin
    uex_mixed_spx_c3.opt_nvers(ivar, ivae, ires);
    p := TProblema_onl.Create_Init(ires, ivar);
    uex_mixed_spx_c3.opt_cargue(p);
    uex_mixed_spx_c3.opt_fijarRestriccionesDeCaja(p);
    p.Resolver();
    uex_mixed_spx_c3.opt_LeerSolucion(p);
  end
  else if (parametrosGlobales.Escenario='udump_simsee_1') then begin
    udump_simsee_1.opt_nvers(ivar, ivae, ires);
    p := TProblema_onl.Create_Init(ires, ivar);
    udump_simsee_1.opt_cargue(p);
    p.Resolver();
  end
  else if (parametrosGlobales.Escenario='uex_mixed_spx_c4') then begin
    uex_mixed_spx_c4.opt_nvers(ivar, ivae, ires);
    p := TProblema_onl.Create_Init(ires, ivar);
    uex_mixed_spx_c4.opt_cargue(p);
    uex_mixed_spx_c4.opt_fijarRestriccionesDeCaja(p);
    p.Resolver();
    uex_mixed_spx_c4.opt_LeerSolucion(p);
  end;

  //A continuación es como queda en el simsee, de forma 'genérica':
    (*
  for k:= 0 to high(Actores) do
      Actores[k].opt_nvers(ivar, ivae, ires);
  *)
  //recorro los actores llamando al procedimiento opt_cargue para que cada actor
  //cargue sus correspondientes funciones
  (*
  for k:= 0 to high(Actores) do
      Actores[k].opt_cargue(p);
  *)

  //le doy la oportunidad a cada actor a imponer restricciones de caja
  (*
  for k:= 0 to high(Actores) do
      Actores[k].opt_fijarRestriccionesDeCaja(p);
  *)

  //ahora estamos en condiciones de resolver el problema
  //p.Resolver();

  //lectura de los resultados del despacho
  (*
  for k:= 0 to high(Actores) do
      Actores[k].opt_LeerSolucion(p);
  *)

  //lo siguiente es para debug
  if (p <> nil) then begin
     XOpt := TVectR.Create_Clone(p.XOpt);
     p.Free;
  end;

end;

end.
