unit uresolvedor_onl;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, xMatDefs, matreal,
  ubibfun_onl,
  usteepestdescent_quad,
  unewton_quad,
  upenaltyMethod_m1,
  upenaltyMethod_m2,
  upenaltyMethod_m3,
  parametrosGlobales;   //esta unit tiene la información del algoritmo de optimización que se desea utilizar

procedure optimizar (f_costo : TFunc_Bloque;
                     g_resDesigualdad,
                     h_resIgualdad : TDAOfTFunc_Bloque;
                     nvars,
                     nres_desigualdad,
                     nres_igualdad : NInt;
                     var XOpt : TVectR;
                     vparams : TParams_onl);

implementation

procedure optimizar (f_costo : TFunc_Bloque;
                     g_resDesigualdad,
                     h_resIgualdad : TDAOfTFunc_Bloque;
                     nvars,
                     nres_desigualdad,
                     nres_igualdad : NInt;
                     var XOpt : TVectR;
                     vparams : TParams_onl);
var
  TolX, TolFun: NReal;
  MaxIter: NInt;
  alfa0: NReal;
  x0 : TVectR;
begin
  TolX := vparams.Num[0];
  TolFun := vparams.Num[1];
  alfa0 := vparams.Num[2];
  MaxIter := trunc(vparams.Num[3]);

  x0 := vparams.Vec[0];

  //Aquí se elije qué algoritmo utilizar
  if (parametrosGlobales.AlgoritmoDeOptimizacion = Steepest_Descent_Method) then
     usteepestdescent_quad.optimizar(f_costo, nvars, XOpt, x0, TolX, TolFun, alfa0, MaxIter);

  if (parametrosGlobales.AlgoritmoDeOptimizacion = Penalizacion ) then
     upenaltyMethod_m1.optimizar(f_costo, g_resDesigualdad, h_resIgualdad, XOpt, x0, TolX, TolFun, alfa0, MaxIter);

  if (parametrosGlobales.AlgoritmoDeOptimizacion = Penalizacion_Con_Igualdades ) then
     upenaltyMethod_m2.optimizar(f_costo, nvars, g_resDesigualdad, h_resIgualdad, XOpt, x0, TolX, TolFun, alfa0, MaxIter);

  if (parametrosGlobales.AlgoritmoDeOptimizacion = Penalizacion_Con_Igualdades_m3 ) then
     upenaltyMethod_m3.optimizar(f_costo, g_resDesigualdad, h_resIgualdad, XOpt, x0, TolX, TolFun, alfa0, MaxIter);



end;

end.

