program optgen_gpa;

uses
    sysutils, uplanes, uConstantesSimSEE, uauxiliares,
    Interfaces;

var
 CarpetaOrigen: string;

begin
  setSeparadoresGlobales;
  SetLength(TrueBoolStrs,1);
  SetLength(FalseBoolStrs,1);
  TrueBoolStrs[0]:='1';
  FalseBoolStrs[0]:='0';

  if ParamCount < 1 then
  begin
    writeln( 'Debe pasar por lo menos un parametro para identificacion del Ejecutor' );
    exit;
  end;
  idEjecutor:= paramStr( 1 );

  if ParamCount < 2 then
    idnodo:= 0 // el cluster
  else
    idnodo:= StrToInt( paramStr( 2 ) );

  {$IFDEF LINUX}
  carpetaOrigen:= '/home/simsee/simsee/corridas/optgen_gpa/';
  tmp_rundir:= '/tmp/simsee/'+idEjecutor;
  if not DirectoryExists ( '/tmp/simsee' ) then CreateDir( '/tmp/simsee' );
  if not DirectoryExists ( tmp_rundir ) then CreateDir( tmp_rundir );
  {$ELSE}
  carpetaOrigen:= '\simsee\corridas\optgen_gpa\';

  tmp_rundir:= '\simsee\tmp_rundir\'+idEjecutor;
  if not DirectoryExists ( '\simsee\tmp_rundir' ) then CreateDir( '\simsee\tmp_rundir' );
  if not DirectoryExists ( tmp_rundir ) then CreateDir( tmp_rundir );
  {$ENDIF}
  if tmp_rundir <> '' then
    limpiarCarpeta( tmp_rundir );

  writeln('Cambiando el directorio a : ',tmp_rundir );
  chdir( tmp_rundir );

  tmp_rundir:= tmp_rundir+DirectorySeparator;
  writeln('******** comienzo copia de archivos ***********');
  copiarArchivos( carpetaOrigen, tmp_rundir,[
                  'optgen_agosto2011_base.txt',
                  'series_BPS50.txt',
                  'fuente_petroleo_ve1d2.txt',
                  'fuentesHidroUY_1VE_BPS50ov3.txt',
                  'vientos_uy.txt',
                  'aniobase2007.bin'
                  , ArchMonitor_vcads,
                  archPlantillaSimRes3_vcads
                  ]);


  writeln( '******** fin copia de archivos ***********');

(*
  if not DirectoryExists( tmp_rundir+DirectorySeparator+nombresala ) then
     CreateDir( tmp_rundir+DirectorySeparator+nombresala );
*)

  randomize;

  OptimizarPoblacion;

  if tmp_rundir <> '' then
  begin
    limpiarCarpeta( tmp_rundir );
    removeDir( tmp_rundir );
  end;


end.

