unit uvisorresultados;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  StdCtrls, uauxiliares, uDataSetGenerico,
  urosx, xMatDefs, uplanes, uConstantesSimSEE,
  matreal, uaproxcuadratica;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    eNid: TEdit;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 

implementation

{ TForm1 }

procedure TForm1.Button1Click(Sender: TObject);
var
  a: TPlan;
  carpetaOrigen: string;

begin
  idEjecutor := '00';

  carpetaOrigen:= '\simsee\corridas\optgen_agosto2011\';

  tmp_rundir:= '\simsee\tmp_rundir\'+idEjecutor;
  if not DirectoryExists ( '\simsee\tmp_rundir' ) then CreateDir( '\simsee\tmp_rundir' );
  if not DirectoryExists ( tmp_rundir ) then CreateDir( tmp_rundir );

  if tmp_rundir <> '' then
    limpiarCarpeta( tmp_rundir );

  writeln('Cambiando el directorio a : ',tmp_rundir );
  chdir( tmp_rundir );

  tmp_rundir:= tmp_rundir+DirectorySeparator;
  writeln('******** comienzo copia de archivos ***********');
  copiarArchivos( carpetaOrigen, tmp_rundir,[
                  'optgen_agosto2011_base.txt',
                  'series_BPS50.txt',
                  'fuente_petroleo_ve1d2.txt',
                  'fuentesHidroUY_1VE_BPS50ov3.txt',
                  'vientos_uy.txt',
                  'aniobase2007.bin'
                  , ArchMonitor_vcads,
                  archPlantillaSimRes3_vcads
                  ]);


  writeln( '******** fin copia de archivos ***********');

(*
  if not DirectoryExists( tmp_rundir+DirectorySeparator+nombresala ) then
     CreateDir( tmp_rundir+DirectorySeparator+nombresala );
*)

  randomize;
  uplanes.Inicializar;
  a:= LeerPlan( StrToInt( eNid.Text ) );
  if a <> nil then
    a.CrearSala( false );
  showmessage('La sala fue creada en: '+tmp_rundir );
  a.Free;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  A: TMatR;
  B: TVectR;
  c: NReal;

  X, Y: TVectR;
  N: integer;
  k, j: integer;

  rq2: TAproxCuadratica;

  f: textfile;
  mval: NReal;
  M: integer;
begin
  N:= 3;
  M := (( N+1 ) * N ) div 2 + (N + 1);
  randomize;

  A:= TMatR.Create_Init( N, N );
  A.Ceros;
  for k:= 1 to N do a.pon_e(k, k, k );
  (*
  for k:= 1 to N do
    for j:= k to N do
      a.pon_e( k, j, random );

  for k:= 2 to N do
    for j:= 1 to k-1 do
      a.pon_e( k, j, a.e( j, k ));

*)
  B:= TVectR.Create_Init( N );
  for k:= 1 to N do
//    b.pon_e(k, random );
    b.pon_e(k, -k );

//  c:= random;
  c:= 14;

  X:= TVectR.Create_Init( N );
  Y:= TVectR.Create_Init( N );

  rq2:= TAproxCuadratica.Create( N );
  rq2.clear;


  for j:= 1 to N do
  begin
    x.Ceros;
    x.pon_e( j, 1);
    A.PorVector( X, Y );
    mval:= Y.PEV( X );
    mval:= mval + B.PEV( X ) + c;
    rq2.AgregarPunto( X, mval, 1 );
    writeln( 'k: ', k, ', mval:', mval );
  end;
  readln;

  for j:= 0 to 10 * M do
  begin
    x.random;
    A.PorVector( X, Y );
    mval:= Y.PEV( X );
    mval:= mval + B.PEV( X ) + c;
    rq2.AgregarPunto( X, mval, 1 );
  end;


  assignfile( f, 'rq2.xlt' );
  rewrite( f );
  writeln( f , 'datos' );
  A.WriteXLT( f );
  B.WriteXLT( f );
  writeln( f, c );

  if rq2.Resolver( f ) then
  begin
    writeln(f, 'Resultados ' );
    writeln( 'Ok resuelto.' );
    rq2.A.WriteXLT( f );
    rq2.B.WriteXLT( f );
    writeln( f, rq2.C );
  end
  else
  begin
    writeln( 'No pude resolver el sistema ' );
  end;
  closefile( f );
  rq2.Free;
  A.Free;
  B.Free;
  Y.Free;
  X.Free;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  X: TVectR;
  N: integer;
  k, j: integer;

  rq2: TAproxCuadratica;

  f: textfile;
  mval: NReal;

begin
  N:= 1;

  X:= TVectR.Create_Init( N );

  rq2:= TAproxCuadratica.Create( N );
  rq2.clear;
  x.pon_e(1, 0 ); mval:= 3;
  rq2.AgregarPunto( X, mval, 1 );
  x.pon_e(1, 1 ); mval:= 6;
  rq2.AgregarPunto( X, mval, 1 );
  x.pon_e(1, 2 ); mval:= 11;
  rq2.AgregarPunto( X, mval, 1 );


  assignfile( f, 'rq2.xlt' );
  rewrite( f );

  if rq2.Resolver( f ) then
  begin
    writeln(f, 'Resultados ' );
    writeln( 'Ok resuelto.' );
    rq2.A.WriteXLT( f );
    rq2.B.WriteXLT( f );
    writeln( f, rq2.C );
  end
  else
  begin
    writeln( 'No pude resolver el sistema ' );
  end;
  closefile( f );
  rq2.Free;
  X.Free;
end;


initialization
  {$I uvisorresultados.lrs}
end.

