unit uparqueseolicos;

{$mode delphi}

interface

uses
  Classes, SysUtils, xmatdefs;

type
  TParqueEolico = class
    top, left: integer;
    Activo: integer; // -1 Parece que no se hace, 0 En construcción, 1 En Operación.

    CentralGeneradora: string;
    AgenteGenerador: string;
    EstadoActual: string;
    Departamento: string;
    Localidad: string;
    FechaEntradaEnServicio: TDateTime;
    Tension_kV: string;
    Potencia_Autorizada_MW: double;
    Latitud: double;
    Longitud: double;
    Fabricante: string;
    Modelo: string;
    PotenciaAerogenerador_MW: double;
    CantidadAerogeneradores: integer;

    // auxiliares para estimador
    viento_dir_gr: NReal;
    viento_vel_mps: NReal;

    constructor Create(Activo: integer; CentralGeneradora: string;
      AgenteGenerador: string; EstadoActual: string; Departamento: string;
      Localidad: string; FechaEntradaEnServicio: string; // En formato de Fecha Local
      Tension_kV: string; Potencia_Autorizada_MW: double; Latitud: double;
      Longitud: double; Fabricante: string; Modelo: string;
      PotenciaAerogenerador_MW: double; CantidadAerogeneradores: integer);
  end;

// Crea la lista de parques conocidos
function Create_Parques_Uruguay: TList;

implementation




constructor TParqueEolico.Create(Activo: integer; CentralGeneradora: string;
  AgenteGenerador: string; EstadoActual: string; Departamento: string;
  Localidad: string; FechaEntradaEnServicio: string; Tension_kV: string;
  Potencia_Autorizada_MW: double; Latitud: double; Longitud: double;
  Fabricante: string; Modelo: string; PotenciaAerogenerador_MW: double;
  CantidadAerogeneradores: integer);
begin
  Self.Activo := Activo;

  Self.CentralGeneradora := CentralGeneradora;
  Self.AgenteGenerador := AgenteGenerador;
  Self.EstadoActual := EstadoActual;
  Self.Departamento := Departamento;
  Self.Localidad := Localidad;
  if (FechaEntradaEnServicio <> '') then
    Self.FechaEntradaEnServicio := StrToDateTime(FechaEntradaEnServicio)
  else
    Self.FechaEntradaEnServicio := StrToDateTime('1/1/3000');

  Self.Tension_kV := Tension_kV;
  Self.Potencia_Autorizada_MW := Potencia_Autorizada_MW;
  Self.Latitud := Latitud;
  Self.Longitud := Longitud;
  Self.Fabricante := Fabricante;
  Self.Modelo := Modelo;
  Self.PotenciaAerogenerador_MW := PotenciaAerogenerador_MW;
  Self.CantidadAerogeneradores := CantidadAerogeneradores;
  viento_dir_gr:= 0;
  viento_vel_mps:= 0;
end;



function Create_Parques_Uruguay: TList;
var
  Parques: Tlist;
  ap: TParqueEolico;
begin

Parques := TList.Create;


ap := TParqueEolico.Create(-1, 'LIBERTADOR I',
  'CENTRAL DE GENERACIÓN EÓLICA LIBERTADOR I S.A.', 'Convenio suscripto',
  'LAVALLEJA', 'LAVALLEJA - MALDONADO', '', '63', 50.00, -34.478127,
  -55.138639, 'V87 Impsa Vensys ful converter', '', 0, 0);
Parques.add(ap);

ap := TParqueEolico.Create(-1, 'LIBERTADOR II',
  'CENTRAL DE GENERACIÓN EÓLICA LIBERTADOR I S.A.', 'Convenio suscripto',
  'LAVALLEJA', 'LAVALLEJA Y MALDONADO', '', '63', 7.50, -34.47791,
  -55.135116, 'V87 Impsa Vensys ful converter', '', 0, 0);
Parques.add(ap);

ap := TParqueEolico.Create(-1, 'LIBERTADOR III',
  'CENTRAL DE GENERACIÓN EÓLICA LIBERTADOR I S.A.', 'Convenio suscripto',
  'MALDONADO', 'MALDONADO', '', '63', 7.50, -34.46791, -55.125116,
  'V87 Impsa Vensys full converter', '', 0, 0);
Parques.add(ap);

ap := TParqueEolico.Create(-1, 'LIBERTADOR IV',
  'CENTRAL DE GENERACIÓN EÓLICA ARTIGAS S.A.', 'Convenio suscripto',
  'LAVALLEJA', 'Minas', '', '150', 50.00, -34.422323, -54.980816,
  'V87 Impsa Vensys ful converter', '', 0, 0);
Parques.add(ap);

ap := TParqueEolico.Create(0, 'MELOWIND', 'ESTRELLADA S.A.',
  'Convenio suscripto', 'CERRO LARGO', 'Arbolito', '', '150', 50.00,
  -32.582846, -54.230207, 'Nordex', 'N100', 0, 0);
Parques.add(ap);

ap := TParqueEolico.Create(-1, 'MOLINO DE ROSAS 50 MW', 'MOLINO DE ROSAS S.A.',
  'Convenio suscripto', 'MALDONADO', 'Pan de Azúcar', '', '150',
  50.00, -34.712553, -55.219573, '', '', 0, 0);
Parques.add(ap);

ap := TParqueEolico.Create(0, 'PARQUE CERRO GRANDE', 'LADANER S.A.',
  'Convenio suscripto', 'CERRO LARGO', '', '', '150', 50.00,
  -32.242580, -53.907256, '', '', 0, 0);
Parques.add(ap);

ap := TParqueEolico.Create(0, 'PARQUE EÓLICO CARAPÉ I', 'FINGANO S.A.',
  'Convenio suscripto', 'MALDONADO', 'Cerro Catedral', '', '150',
  50.00, -34.395021, -54.695066, 'Vestas', 'V112 - 3MW', 3, 17);
Parques.add(ap);

ap := TParqueEolico.Create(0, 'PARQUE EÓLICO KIYÚ', 'COBRA INGENIERÍA URUGUAY S.A.',
  'Convenio suscripto', 'SAN JOSÉ', 'Kiyú', '', '150', 48.60, -34.669759,
  -56.8018, 'Vestas', 'V90 - 3MW', 3, 16);
Parques.add(ap);

ap := TParqueEolico.Create(1, 'PARQUE EÓLICO ROSARIO', 'TOGELY COMPANY S.A.',
  'Convenio suscripto', 'COLONIA', 'Rosario', '', '63', 9.00,
  -34.22651, -57.336608, '', '', 0, 0);
Parques.add(ap);

ap := TParqueEolico.Create(0, 'PERALTA 1 GCEE', 'AGUA LEGUAS S.A.',
  'Convenio suscripto', 'TACUAREMBÓ', 'Cuchilla Peralta', '', '150',
  50.00, -32.582638, -56.394636, 'Enercon', 'E92', 2.35, 25);
Parques.add(ap);

ap := TParqueEolico.Create(0, 'PERALTA 2 GCEE', 'AGUA LEGUAS S.A.',
  'Convenio suscripto', 'TACUAREMBÓ', 'Cuchilla Peralta', '', '150',
  50.00, -32.600400, -56.419570, 'Enercon', 'E92', 2.35, 25);
Parques.add(ap);

ap := TParqueEolico.Create(0, 'TALAS DEL MACIEL I', 'ASTIDEY S.A.',
  'Convenio suscripto', 'FLORES', 'Talas del Maciel', '', '150',
  50.00, -33.634783, -56.721357, 'Gamesa', 'Gamesa G97', 0, 0);
Parques.add(ap);

ap := TParqueEolico.Create(0, 'TALAS DEL MACIEL II', 'CADONAL S.A.',
  'Convenio suscripto', 'FLORES', 'Talas del Maciel', '', '150',
  50.00, -33.605045, -56.711654, 'Gamesa ', 'G97', 0, 0);
Parques.add(ap);

ap := TParqueEolico.Create(1,
  'CARACOLES 1 del PARQUE EÓLICO ING. EMANUELE CAMBILARGIU',
  'UTE', 'En servicio', 'MALDONADO', 'Sierra de los Caracoles',
  '10/02/2009', '31.5', 10.00, -34.626901, -54.957502, 'Vestas', 'V80', 2, 5);
Parques.add(ap);

ap := TParqueEolico.Create(1,
  'CARACOLES 2 del PARQUE EÓLICO ING. EMANUELE CAMBILARGIU',
  'UTE', 'En servicio', 'MALDONADO', 'Sierra de los Caracoles',
  '23/06/2010', '31.5', 10.00, -34.648089, -54.966066, 'Vestas', 'V80', 2, 5);
Parques.add(ap);

ap := TParqueEolico.Create(1, 'PARQUE DE VACACIONES UTE-ANTEL',
  'UTE-ANTEL', 'En servicio', 'LAVALLEJA', 'Minas', '01/04/2010',
  '6.4', 0.15, -34.425003, -55.183542, '', '', 0, 0);
Parques.add(ap);

ap := TParqueEolico.Create(1, 'AGROLAND', 'AGROLAND S.A.',
  'En servicio (Habilitación Final)', 'MALDONADO', 'Paraje Garzón',
  '30/04/2008', '15', 0.25, -34.634532, -54.612077, 'Bonus', '150', 0, 0);
Parques.add(ap);

ap := TParqueEolico.Create(1, 'CUCHILLA DEL PERALTA I', 'PALMATIR S.A.',
  'En servicio (Habilitación Final)', 'TACUAREMBÓ', 'Cuchilla Peralta',
  '13/05/2014', '150', 50.00, -32.570107, -56.443977, 'Gamesa', 'Gamesa G90', 2, 25);
Parques.add(ap);

ap := TParqueEolico.Create(1, 'LUZ DE MAR', 'LUZ DE MAR S.A.',
  'En servicio (Habilitación Final)', 'FLORIDA', 'PARAJE PINTADO',
  '27/08/2014', '31.5', 18.00, -33.876277, -56.350492, 'Vestas', 'V112 - 3 MW', 3, 6);
Parques.add(ap);

ap := TParqueEolico.Create(1, 'LUZ DE RÍO', 'LUZ DE RÍO S.A.',
  'En servicio (Habilitación Final)', 'FLORIDA', 'PARAJE PINTADO',
  '01/08/2014', '150', 50.00, -33.88554, -56.442846, 'Vestas', 'V112 - 3 MW', 3, 17);
Parques.add(ap);

ap := TParqueEolico.Create(1, 'NUEVO MANANTIAL CENTRAL 2',
  'NUEVO MANANTIAL S.A.', 'En servicio (Habilitación Final)', 'ROCHA',
  '19 DE ABRIL', '02/12/2009', '63', 4.00, -34.286155, -54.060287, '', '', 0, 0);
Parques.add(ap);

ap := TParqueEolico.Create(1, 'PARQUE EÓLICO LIBERTAD', 'TOGELY COMPANY S.A.',
  'En servicio (Habilitación Final)', 'SAN JOSÉ', 'SAN JOSÉ',
  '22/07/2014', '31.5', 7.70, -34.634590, -56.586462, 'VESTAS', 'V100-1.8MW', 1925, 4);
Parques.add(ap);

ap := TParqueEolico.Create(1, 'PARQUE EÓLICO LOMA ALTA - CENTRAL 1',
  'NUEVO MANANTIAL S.A.', 'En servicio (Habilitación Final)', 'ROCHA',
  '19 de Abril', '25/06/2008', '63', 7.80, -34.286155, -54.060287,
  'NedWind / Nordic Windpower', 'NW40 / 1000/59', 0, 25);
Parques.add(ap);

ap := TParqueEolico.Create(1, 'PARQUE EÓLICO MAGDALENA', 'KENTILUX S.A.',
  'En servicio (Habilitación Final)', 'SAN JOSÉ', '', '29/04/2011',
  '31.5', 17.20, -34.745844, -56.573067, 'Vestas', 'V90 2.0 MW / V100 1.8 MW', 0, 9);
Parques.add(ap);

ap := TParqueEolico.Create(1, 'PARQUE EÓLICO MALDONADO', 'R DEL SUR S.A.',
  'En servicio (Habilitación Final)', 'MALDONADO', 'Sierra de los Caracoles',
  '10/04/2014', '150', 50.00, -34.467151, -54.931297, 'Gamesa', 'Gamesa G97', 2, 25);
Parques.add(ap);

ap := TParqueEolico.Create(1, 'ENGRAW', 'ENGRAW EXPORT & IMPORT CO. S.A.',
  'En servicio (Habilitación Parcial)', 'FLORIDA', 'Fray Marcos',
  '25/10/2012', '31.5', 3.60, -34.204154, -55.74796, 'Vestas',
  'V100 - 1.8 MW', 1.8, 1);
Parques.add(ap);

ap := TParqueEolico.Create(1, 'LUZ DE LOMA', 'LUZ DE LOMA S.A.',
  'En servicio (Habilitación Parcial)', 'FLORIDA', 'PARAJE PINTADO',
  '27/08/2014', '31.5', 20.00, -33.866277, -56.340492, 'Vestas', 'V112 - 3 MW', 3, 7);
Parques.add(ap);

ap := TParqueEolico.Create(1, 'MINAS I', 'GENERACIÓN EÓLICA MINAS S.A. - GEMSA',
  'En servicio (Habilitación Parcial)', 'LAVALLEJA', '', '15/09/2014',
  '150', 42.00, -34.464674, -55.306549, 'Vestas', 'V112 - 3 MW', 3, 14);
Parques.add(ap);

ap := TParqueEolico.Create(1, 'PARQUE EÓLICO FLORIDA I', 'POLESINE S.A.',
  'En servicio (Habilitación Parcial)', 'FLORIDA', 'Ruta 56',
  '23/09/2014', '150', 50.00, -34.072142, -56.02797, 'Nordex', 'N117', 2.4, 21);
Parques.add(ap);

ap := TParqueEolico.Create(-1, 'ANDRESITO', 'UTE + Accionistas',
  'En suspenso', 'FLORES', 'Andresito', '', '', 50.00, -33.157526,
  -57.137823, '', '', 0, 0);
Parques.add(ap);

ap := TParqueEolico.Create(0, 'ARIAS', 'UTE + Accionistas',
  'Resolución de Adjudicación', 'FLORES', 'Colonia Arias', '', '',
  70.00, -33.828853, -56.573928, 'Gamesa', 'G114', 0, 0);
Parques.add(ap);

ap := TParqueEolico.Create(1, 'JUAN PABLO TERRA', 'UTE',
  'Resolución de Adjudicación', 'ARTIGAS', 'Javier de Viana', '',
  '150', 67.20, -30.408981, -56.640095, 'Nordex', 'N117', 2.4, 28);
Parques.add(ap);

ap := TParqueEolico.Create(0, 'PALOMAS', 'UTE', 'Resolución de Adjudicación',
  'SALTO', '', '', '', 71.00, -31.179298, -57.706112, 'Vestas', 'V112', 0, 0);
Parques.add(ap);

ap := TParqueEolico.Create(0, 'PAMPA', 'UTE + Accionistas',
  'Resolución de Adjudicación', 'TACUAREMBÓ', '', '', '150', 140.00,
  -32.246667, -56.215, 'Nordex', 'N117', 2.4, 0);
Parques.add(ap);

ap := TParqueEolico.Create(0, 'PARQUE EÓLICO ARTILLEROS', 'ROUAR S.A.',
  'Resolución de Adjudicación', 'COLONIA', 'Rosendo Mendoza',
  '31/1/2015', '150', 65.10, -34.349932, -57.555393, 'Suzlon', 'S 95', 2.1, 31);
Parques.add(ap);

ap := TParqueEolico.Create(0, 'VALENTINES', 'UTE + Accionistas',
  'Resolución de Adjudicación', 'FLORIDA', 'Valentines', '', '150',
  70.00, -33.267167, -55.10208, 'Gamesa', 'G114 T9m', 2, 35);
Parques.add(ap);

ap := TParqueEolico.Create(1, 'SANTA FE', 'LAVADERO DE LANAS BLENGIO S.A.',
  'Solicitud de Ampliación', 'SAN JOSÉ', 'Libertad', '24/07/2013',
  '31.5', 0.90, -34.647349, -56.593221, 'Vestas', 'V100', 1.8, 1);
Parques.add(ap);
result:= Parques;
end;


end.

