unit uTestSimplex;
interface

uses
  LCLIntf, LCLType, LMessages, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,
  xMatDefs,
  uSimplex, uMIPSImplex,
  uConstantesSimSEE, uListaViolacionesPermitidasSimplex;

const
  WM_DBGMONSPX = WM_USER + 1;

type

  { TformTestSimplex }

  TformTestSimplex = class(TForm)
    btAbrir: TButton;
    BTCerrar: TButton;
    OpenDialog1: TOpenDialog;
    BTActualizar: TButton;
    memo: TMemo;
    btContinuar: TButton;
    eCntLlamadas: TEdit;
    eCntHasta: TEdit;
    procedure btAbrirClick(Sender: TObject);
    procedure BTCerrarClick(Sender: TObject);
    procedure BTActualizarClick(Sender: TObject);
    procedure btContinuarClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    procedure CargarArchivoFromXLT(archi: string);
    procedure Procesar_DBGMONSPX(var Message: TMessage); message WM_DBGMONSPX;
    procedure ResolverReferenciasYCargarSimplex( archi: string );
  public
    spx: TMipSimplex;
  end;

var
  formTestSimplex: TformTestSimplex;

implementation
{$R *.lfm}

procedure TformTestSimplex.CargarArchivoFromXLT(archi: string);
begin
  btAbrir.Enabled := False;
  ResolverReferenciasYCargarSimplex( archi );
  spx.Resolver;
end;

procedure TformTestSimplex.Procesar_DBGMONSPX(var Message: TMessage);
var
  ts: string;
  cntLLamadas, cntHasta: integer;
begin
  cntLlamadas := StrToInt(ecntLlamadas.Text);
  Inc(cntLlamadas);
  ecntLlamadas.Text := IntToStr(cntLlamadas);
  cntHasta := StrToInt(ecntHasta.Text);
  ts := ecntLlamadas.Text + '::>' ;
  memo.Lines.Append(ts);
  if cntLlamadas <= cntHasta then
    btContinuarClick(self)
  else
    btContinuar.Enabled := True;
end;

procedure TformTestSimplex.btAbrirClick(Sender: TObject);
begin
  if OpenDialog1.Execute then
  begin
   // abrirExcel(OpenDialog1.FileName);
    CargarArchivoFromXLT( OpenDialog1.FileName );
  end;
end;

procedure TformTestSimplex.BTCerrarClick(Sender: TObject);
begin
  btAbrir.Enabled := True;
end;

procedure TformTestSimplex.ResolverReferenciasYCargarSimplex(archi: string);
var
  f: textfile;
begin
  filemode:= 0;
  assignfile( f, archi );
  reset( f );
  spx:= TMIPSimplex.CreateFromXLT( f );
  closefile( f );
end;

procedure TformTestSimplex.BTActualizarClick(Sender: TObject);
var
  k, j: integer;
  spx: TSimplex;
  cursorAnterior: TCursor;
begin
  spx := umipsimplex.spxActivo;
  if spx = nil then
    exit;
  BTContinuar.Enabled := False;
  cursorAnterior := screen.Cursor;
  Screen.Cursor := crHourGlass;

end;

procedure TformTestSimplex.btContinuarClick(Sender: TObject);
begin
  btContinuar.Enabled := False;
end;

procedure TformTestSimplex.FormCreate(Sender: TObject);
begin
  OpenDialog1.InitialDir := getDir_Dbg;
  if ParamCount >= 1 then
  begin
    if FileExists(ParamStr(1)) then
    begin
      OpenDialog1.FileName := ParamStr(1);
      //    abrirExcel(OpenDialog1.FileName);
      if ParamCount >= 2 then
      begin
        try
          StrToInt(ParamStr(2));
          eCntHasta.Text := ParamStr(2);
        except
          //Ignoro el parámetro
        end;
      end;
    end;
  end;
end;

procedure TformTestSimplex.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  BTCerrarClick(BTCerrar);
end;

end.
