unit uoptdinestoc;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, xmatdefs, uodt_types;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
	vd_continuas: TDAOfVarContinua;
	vd_discretas: TDAOfVarDiscreta;

	constelacion: TConstelacion;
	k, j: integer;

	vkc, vkd: TDAOfNInt;
	x: TDAOfNReal;
	f: NReal;
	x1, x2: NReal;
	kpaso: integer;
	fsal: file;
	
begin
	setlength( vd_continuas, 2 );
	setlength( vd_discretas, 0 );

	vd_continuas[0]:= TVarContinua.Create('haltura bonete', 'm', 10, 200, 3 );
	vd_continuas[1]:= TVarContinua.Create('temperatura salto', 'C', 21.1, 22.2, 4 );


	writeln('Creando constelacin');
	constelacion:= TConstelacion.Create( vd_continuas, vd_discretas, 100 );

	setlength( vkc, 2 );
	setlength( vkd, 0 );

	for k:= 0 to 2 do
		for j:= 0 to 3 do
		begin
			vkc[0]:= k; vkc[1]:= j;
			for kpaso:= 0 to 99 do
				constelacion.set_costo_estrella( kpaso, vkc, vkd  , 117*k+j/117+kpaso );
		end;


	setlength( x, 2 );

	writeln( 'Ahora vamos a testear que est bien cargada la constelacin' );
	for k:= 0 to 2 do
		for j:= 0 to 3 do
		begin
			x1:= 10+ (200-10)/2*k;
			x2:= 21.1+ (22.4-21.1)/3*j;

			x[0]:= x1; x[1]:= x2;
			f:= constelacion.costo(2, x, vkd ); // elijo un paso cualquiera
			writeln( 'x1: ',x1:12:2,' x2: ',x2:12:2, ' f: ', f: 12:2, ' fc: ', (117*k+j/117+2):12:2 );
		end;


	writeln( 'Ahora vamos a testear la interpolacin dentro de la constelacin' );
	for k:= 0 to 20 do
		for j:= 0 to 30 do
		begin
			x1:= 10+ (200-10)/20*k;
			x2:= 21.1+ (22.2-21.1)/30*j;

			x[0]:= x1; x[1]:= x2;
			f:= constelacion.costo( 3, x, vkd );
			writeln( 'x1: ',x1:12:2,' x2: ',x2:12:2, ' f: ', f: 12:2, ' fc: ', (117*k/10+j/117/10+3):12:2 );
		end;

	assignFile( fsal, 'constelacion_test2d.dat' );
	rewrite( fsal,1 );
	constelacion.StoreInFile( fsal );
	closefile( fsal );

	writeln('Destruyendo constelacin');
	constelacion.Free;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
	constelacion: TConstelacion;
	k, j: integer;
	vkc, vkd: TDAOfNInt;
	x: TDAOfNReal;
	f: NReal;
	x1, x2: NReal;
	kpaso: integer;
	fent: file;
	iEstrella: integer;

begin

	writeln('Creando constelacin');

	assignFile( fent, 'constelacion_test2d.dat' );
	reset( fent,1 );
	constelacion:= TConstelacion.Create_LoadFromFile(fent );
	closefile( fent );

	setlength( vkc, 2 );
	setlength( vkd, 0 );

	setlength( x, 2 );

	writeln( 'Ahora vamos a testear que est bien cargada la constelacin' );
	for k:= 0 to 2 do
		for j:= 0 to 3 do
		begin
			x1:= 10+ (200-10)/2*k;
			x2:= 21.1+ (22.2-21.1)/3*j;

			x[0]:= x1; x[1]:= x2;
			f:= constelacion.costo(2, x, vkd ); // elijo un paso cualquiera
			writeln( 'x1: ',x1:12:2,' x2: ',x2:12:2, ' f: ', f: 12:2, ' fc: ', (117*k+j/117+2):12:2 );
		end;

	writeln('... oprima ENTER ...' );
	readln;

	writeln( 'Ahora vamos a testear la interpolacin dentro de la constelacin' );
	for k:= 0 to 20 do
		for j:= 0 to 30 do
		begin
			x1:= 10+ (200-10)/20*k;
			x2:= 21.1+ (22.2-21.1)/30*j;
				x[0]:= x1; x[1]:= x2;
			f:= constelacion.costo( 3, x, vkd );
			writeln( 'x1: ',x1:12:2,' x2: ',x2:12:2, ' f: ', f: 12:2, ' fc: ', (117*k/10+j/117/10+3):12:2 );
		end;


	for iEstrella:= 0 to Constelacion.nEstrellas-1 do
	begin
		write( iEstrella: 6 );
		Constelacion.indicesEstrella_i( vkc, vkd, iEstrella );
		k:= vkc[0];
		j:= vkc[1];
		Constelacion.cordenadasEstrella_icid( x, vkd, vkc,vkd );
		writeln( k:6, j:6, constelacion.fCosto[3][iEstrella]:12:2, ' fc:',(117*k+j/117+3):12:2 );
		x1:=x[0]; x2:= x[1];
		writeln( '--->',	x1:12:2, (10+ (200-10)/2*k): 12: 2, x2: 12:2,  (21.1+ (22.2-21.1)/3*j): 12:2);

	end;

	writeln('Destruyendo constelacin');
	constelacion.Free;

end;

end.
