unit uverdoc;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OleServer,
  Word2000,
  StdCtrls, OleCtrls, SHDocVw, ExtCtrls;

type
  TForm1 = class(TForm)
    WebBrowser1: TWebBrowser;
    OpenDialog1: TOpenDialog;
    Panel1: TPanel;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    procedure WebBrowser1NavigateComplete2(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var
  F: TextFile;
  S: string;
begin
  if OpenDialog1.Execute then            { Display Open dialog box }
  begin
    WebBrowser1.Navigate(OpenDialog1.FileName)
  end;
end;

procedure TForm1.WebBrowser1NavigateComplete2(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin
  with WebBrowser1.Document AS _Document do //(WebBrowser1.Document AS _Document) do
  begin
    ActiveWindow.View.ShowAll := false;
    ActiveWindow.View.TableGridlines := False;
    ActiveWindow.DisplayRulers := False;
    ActiveWindow.View.type_ := wdPageView;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  WebBrowser1.Navigate('nuevo.doc')
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  archi, dirbin: string;
  archi_enblanco: string;
begin
  if ParamCount < 1 then
    raise Exception.Create('Falta nombre de documento. Sintaxis: verdoc nombredoc ');

  dirbin:= GetCurrentDir;
  archi:= dirbin+'\..\docs\'+ParamStr(1)+#0;
  archi_enblanco:= dirbin+'\..\docs\enblanco.doc'#0;
  if not FileExists( archi ) then
  begin
    copyfile( @archi_enblanco[1], @archi[1], true );
  end;
  WebBrowser1.Navigate(archi)
end;

end.
