unit uwind3dform;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ExtCtrls,
  StdCtrls, ugraficador, xmatdefs;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    PaintBox1: TPaintBox;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
    aGrafico: TGrafico;
    serie: TSerieGrafico;
    xvals: TDAOfNreal;
    y1, y2, y3: TDAOfNReal;
  end;

var
  Form1: TForm1;

implementation

{$R *.lfm}

{ TForm1 }

procedure TForm1.Button1Click(Sender: TObject);
var
  k: integer;
begin
  setlength( xvals, 1000 );
  setlength( y1, 1000 );
  setlength( y2, 1000 );
  setlength( y3, 1000 );

  for k:= 0 to high( xvals ) do
  begin
    xvals[k]:= 2*k;
    y1[k]:= sin( xvals[k] /1000 * 2* pi );
    y2[k]:= cos( xvals[k] /1000 * 2* pi );
    y3[k]:= 1-xvals[k] /2000 ;
  end;

  aGrafico:= TGrafico.Create('G1', TG_DispersionXY );
  serie:= TSerieGrafico.Create('x', xvals, nil, aGrafico, '##.##', true );
  aGrafico.AddSerie( serie );
  serie:= TSerieGrafico.Create('seno', y1, nil, aGrafico, '##.##', false );
  aGrafico.AddSerie( serie );
  serie:= TSerieGrafico.Create('coseno', y2, nil, aGrafico, '##.##', false );
  aGrafico.AddSerie( serie );
  serie:= TSerieGrafico.Create('1-x', y3, nil, aGrafico, '##.##', false );
  aGrafico.AddSerie( serie );

  agrafico.Draw( PaintBox1.Canvas, PaintBox1.Width, PaintBox1.Height );

end;

procedure TForm1.Button2Click(Sender: TObject);
begin

end;

end.

