unit uformTestActores;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls,
	Math,
	auxiliares,
	ucosa,
	uactores,
	xMatDefs,
	usalasDeJuego,
	unodos, uarcos, udemandas, udemandadetallada,
	ugter_basico, ufechas, uimpvnreal, ComCtrls,
   ExtCtrls;

type
	TForm1 = class(TForm)
    Button1: TButton;
		Button2: TButton;
    Button3: TButton;
    Button4: TButton;
		Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    eFecha: TEdit;
		eAnio: TEdit;
		Label1: TLabel;
		eSemana: TEdit;
		Label2: TLabel;
		Label3: TLabel;
		eGetSem: TEdit;
		Label4: TLabel;
		Button8: TButton;
		Button9: TButton;
		dlgOpen: TOpenDialog;
		pbCron: TProgressBar;
		pbSim: TProgressBar;
		Button10: TButton;
		Shape1: TShape;
		cb_SortearOpt: TCheckBox;
		eNCronicasOpt: TEdit;
		Label5: TLabel;
		Label6: TLabel;
		eTasaDeActualizacion: TEdit;
    cb_ObligarDisponibilidad_1: TCheckBox;
		procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
		procedure Button6Click(Sender: TObject);
		procedure Button5Click(Sender: TObject);
		procedure Button7Click(Sender: TObject);
		procedure Button8Click(Sender: TObject);
		procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);

private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	Form1: TForm1;
	sdj: TSalaDeJuego;
	fsal: textfile;
	
implementation

{$R *.DFM}



procedure TForm1.Button1Click(Sender: TObject);
var
   dp: TDAOfNReal;
begin
   setlength( dp, 3 );
   dp[0]:= 4;
   dp[1]:= 4;
   dp[2]:= 160;
	sdj:= TSalaDeJuego.Create(
		'sala de juego',
		TFecha.Create_AnioMesDia(2006,1,1),
		TFecha.Create_AnioMesDia(2007,1,1), dp );
end;

procedure TForm1.Button2Click(Sender: TObject);
var
   f: textfile;
begin
   assignfile( f, 'saladejuegos.txt' );
   rewrite(f);
	 try
			WriteCosaToText(f,  sdj );
   finally
      closefile( f );
	 end;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
	 gc: TGTer_Basico;
	 fpa: TFichaGTer_Basico;
begin
	 fpa:= TFichaGTer_Basico.Create(
            TFecha.Create_AnioSemana( 2005, 1 ), // anio, semana
						120, // PMin, PMax
						30, //  cv_min, cv: NReal;
            2, // NMaquinas: integer;
						0.85 //disp: NReal;
						 ); 
   gc:= TGTer_Basico.Create(
      'Gen1', 
			TFecha.Create_AnioMesDia(2001,1,1), TFecha.Create_AnioMesDia(2060,12,31),
			TNodo(sdj.nodos.lst.items[0]),
			fpa );
	 sdj.Generadores.lst.add( gc );
end;

procedure TForm1.Button4Click(Sender: TObject);
var
	 an: TNodo;
begin
	 an:= TNodo.Create('NodoA',
				TFecha.Create_AnioMesDia( 2001, 1,1 ), TFecha.Create_AnioMesDia(2100,12, 31));
	 sdj.Nodos.lst.Add(an);
end;

procedure TForm1.Button6Click(Sender: TObject);
var
   f: textfile;
begin
	 assignfile( f, 'saladejuegos.txt' );
   reset(f);
   try
			sdj:= ReadCosaFromText(f) as TSalaDeJuego;
   finally
			closefile( f );
	 end;
end;


procedure TForm1.Button5Click(Sender: TObject);
begin
	 sdj.Free;
end;

procedure TForm1.Button7Click(Sender: TObject);
var
	fecha: TFecha;
begin
	fecha:= TFecha.Create_AnioSemana(	StrToInt( eAnio.text ), StrToInt( eSemana.text ));
	eFecha.text:= fecha.AsStr;
	eGetSem.text:= IntToStr( fecha.semana );
end;


procedure TForm1.Button8Click(Sender: TObject);
var
	a: TDAOfNReal;
begin
	a:= uimpvnreal.importarDatos;
end;


procedure InicioSimulacion;
begin
	Form1.PBSim.Min := 0;
	Form1.PBSim.Max := sdj.globs.NCronicasSim;
	Form1.PBSim.Position:= 0;
	Form1.PBSim.Step := 1;

	assign( fsal, 'simres.xlt' );
	rewrite( fsal );
end;

procedure InicioCronica;
var
	iposte, iactor: integer;

begin
	Form1.PBCron.Min := 0;
	Form1.PBCron.Max := sdj.globs.NPasos;
	Form1.PBCron.Position:= 0;
	Form1.PBCron.Step := 1;

	system.writeln(fsal, 'CRONICA: ', sdj.globs.kCronica );
	for iposte:= 0 to sdj.globs.NPostes-1 do
		for iactor:= 0 to high( sdj.todos ) do
			sdj.todos[iactor].PrintResultados_Encab( fsal, iposte+1 );

	system.writeln( fsal,#9, 'CostPasoUSD' );

end;


procedure FinPaso;
var
	iposte, iactor: integer;
begin
	for iposte:= 0 to sdj.globs.NPostes-1 do
		for iactor:= 0 to high( sdj.todos ) do
			sdj.todos[iactor].PrintResultados( fsal, iposte );

	system.writeln( fsal,#9, sdj.globs.costodelpaso );

	Form1.PBCron.stepit;
	application.ProcessMessages;
end;

procedure FinCronica;
begin
	Form1.PBSim.stepit;
end;


procedure FinSimulacion;
begin
	closefile( fsal );
end;

procedure TForm1.Button9Click(Sender: TObject);
var
	fent: TextFile;
begin
	if dlgOpen.Execute then
	begin
		assignfile( fent, dlgOpen.filename );
		filemode:= 0;
		reset( fent );
		try
			sdj:= ReadCosaFromText( fent ) as TSalaDeJuego;
			resolver_referencias(sdj.Nodos);
			resolver_referencias(sdj.Generadores);
			resolver_referencias(sdj.Demandas);
			resolver_referencias(sdj.Arcos);
		finally
			closefile( fent );
		end;
		sdj.globs.procNot_InicioSimulacion:= InicioSimulacion;
		sdj.globs.procNot_InicioCronica:= InicioCronica;
		sdj.globs.procNot_FinPaso:= FinPaso;
		sdj.globs.procNot_FinCronica:= FinCronica;
		sdj.globs.procNot_FinSimulacion:= FinSimulacion;
		sdj.globs.NCronicasSim:= 1;
		sdj.globs.ObligarDisponibilidad_1:= cb_ObligarDisponibilidad_1.Checked;
		sdj.Simular;
	end;
end;



procedure TForm1.Button10Click(Sender: TObject);
var
	fent: TextFile;
	fActPaso: NReal;

begin
	if dlgOpen.Execute then
	begin
		assignfile( fent, dlgOpen.filename );
		filemode:= 0;
		reset( fent );
		try
			sdj:= ReadCosaFromText( fent ) as TSalaDeJuego;
			resolver_referencias(sdj.Nodos);
			resolver_referencias(sdj.Generadores);
			resolver_referencias(sdj.Demandas);
			resolver_referencias(sdj.Arcos);
		finally
			closefile( fent );
		end;
		sdj.globs.NCronicasOpt:= StrToInt( eNCronicasOpt.text );

		sdj.globs.TasaDeActualizacion:=StrToFloat(eTasaDeActualizacion.text)/100;
		sdj.globs.SortearOpt:=cb_SortearOpt.checked;
		sdj.OPtimizar;
	end;
end;

end.
