unit uTestSintetizador;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, uFuenteSintetizador, uglobs, ufechas, xmatdefs;

type
  TForm2 = class(TForm)
    Button1: TButton;
    eArchi: TEdit;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.dfm}

procedure TForm2.Button1Click(Sender: TObject);
var
  fsin: TFuenteSintetizadorCEGH;
  globs : TGlobs;
  fechaIni, fechaFin: TFecha;
  durpos: TDAOfNreal;
  k: integer;
  fsal: textfile;
  x: NReal;

begin
  setlength( durpos, 1 );
  durpos[0]:= 168;
  fechaIni:= TFecha.Create_Str('1/1/2006');
  fechaFin:= TFecha.Create_Str('1/1/2008');
  globs:= TGlobs.Create('globs', fechaIni, fechaFin, durpos );
  fsin:= TFuenteSintetizadorCEGH.Create('fsin', eArchi.text);
  fsin.PrepararMemoria(globs, true );
  fsin.Sim_Cronica_Inicio;

  assignfile( fsal, 'Sintetizador_x.xlt' );
  rewrite( fsal );
	globs.Fijar_kPaso( 1 );

  for k := 0 to 1000 do
  begin
    fsin.SorteosDelPaso(true);
    fsin.CalcularSalidasSim(true);
    x:= fsin.EstadoK[0];
    system.writeln( fsal, x, #9, fsin.UltimoRND );
  	globs.Fijar_kPaso( globs.kPaso_+1 );
  end;

  closefile( fsal );
  fsin.Free;
  fechaIni.Free;
  fechaFin.Free;
  setlength( durpos, 0 );
end;

end.
