unit uUtilidadesDirectorios;

interface

uses
  Classes, SysUtils;

function getArchivosEnElDirectorio(const directorio: String): TStringList; overload;
function getArchivosEnElDirectorio(const directorio, extensionConPunto: String): TStringList;
  overload;

implementation

function getArchivosEnElDirectorio(const directorio: String): TStringList;
begin
  result := getArchivosEnElDirectorio(directorio, '.*');
end;

function getArchivosEnElDirectorio(const directorio, extensionConPunto: String): TStringList;
var
  Rec: TSearchRec;
  archis: TStringList;
  i: Integer;
begin
  archis := TStringList.Create;
  if SysUtils.FindFirst(directorio + '*' + extensionConPunto, faAnyFile, Rec) = 0 then
  begin
    repeat
      if (Rec.Name <> '.') and (Rec.Name <> '..') then
      begin
        if ((Rec.Attr and faDirectory) <> faDirectory) then
          archis.Add(Rec.Name);
      end;
    until SysUtils.FindNext(Rec) <> 0;
    SysUtils.FindClose(Rec);
  end;
  result := archis;
end;

end.
