unit uActorNodalCombustible;
  {$MODE Delphi}

interface

uses
  uCosa, uCosaConNombre,
  uGlobs, uActores, uFechas, unodoCombustible,
  uFichasLPD,
  uFuentesAleatorias,
  xMatDefs, uauxiliares;

type

  { TActorNodalCombustible }

  TActorNodalCombustible = class(TActor)
    function ReferenciaAlNodoCombustible(nodocomb: TNodoCombustible): boolean;
      virtual; abstract;
  end;

  //TActorUniNodalCombustible es un nodo NO ELÉCTRICO

  TActorUniNodalCombustible = class(TActorNodalCombustible)

  public
    (**************************************************************************)
    (*               A T R I B U T O S   P E R S I S T E N T E S              *)
    (**************************************************************************)

    NodoComb: TNodoCombustible;
    (**************************************************************************)
    Q: TDAOfNReal;   // caudal inyectado al nodo

    function Rec: TCosa_RecLnk; override;
    procedure BeforeRead(version, id_hilo: integer); override;
    procedure AfterRead(f:TArchiTexto); override;

    constructor Create(capa: integer; nombre: string; nacimiento, muerte: TFecha;
      lpdUnidades: TFichasLPD; nodocomb: TNodoCombustible;
  xFuenteIdxP: TFuenteAleatoria; xBorneIdxP: string);
    function ReferenciaAlNodoCombustible(nodocomb: TNodoCombustible): boolean; override;
    procedure PubliVars; override;
    procedure PrepararMemoria(Catalogo: TCatalogoReferencias; globs: TGlobs); override;
    procedure Free; override;

  end;

  { TActorBiNodalCombustible }

  TActorBiNodalCombustible = class(TActorNodalCombustible)

  public

    (**************************************************************************)
    (*               A T R I B U T O S   P E R S I S T E N T E S              *)
    (**************************************************************************)

    NodoCombA, NodoCombB: TNodoCombustible;
    (**************************************************************************)

    Q_NodoCombA, Q_NodoCombB: TDAOfNReal;

    constructor Create(capa: integer; nombre: string; nacimiento, muerte: TFecha;
      lpdUnidades: TFichasLPD; NodoCombA, NodoCombB: TNodoCombustible;
  xFuenteIdxP: TFuenteAleatoria; xBorneIdxP: string);

    function Rec: TCosa_RecLnk; override;
    procedure BeforeRead(version, id_hilo: integer); override;
    procedure AfterRead(f:TArchiTexto); override;

    function ReferenciaAlNodoCombustible(nodocomb: TNodoCombustible): boolean; override;
    procedure PrepararMemoria(Catalogo: TCatalogoReferencias; globs: TGlobs); override;
    procedure Free; override;

  end;

procedure AlInicio;
procedure ALFinal;

implementation

{ TActorNodalCombustible }

//--------------------------
// Métodos de TActorUniNodalCombustible
//==========================

function TActorUniNodalCombustible.Rec: TCosa_RecLnk;
begin
  Result:=inherited Rec;
  Result.addCampoDef_ref('NodoComb', TCosa(NodoComb), Self);
end;

procedure TActorUniNodalCombustible.BeforeRead(version, id_hilo: integer);
begin
  inherited BeforeRead(version, id_hilo);
end;

procedure TActorUniNodalCombustible.AfterRead(f:TArchiTexto);
begin
  inherited AfterRead(f);
end;

constructor TActorUniNodalCombustible.Create(capa: integer; nombre: string;
  nacimiento, muerte: TFecha; lpdUnidades: TFichasLPD; nodocomb: TNodoCombustible;
  xFuenteIdxP: TFuenteAleatoria; xBorneIdxP: string );
begin
  inherited Create(capa, nombre, nacimiento, muerte, lpdUnidades, xFuenteIdxP, xBorneIdxP );
  self.NodoComb := NodoComb;
end;


function TActorUniNodalCombustible.ReferenciaAlNodoCombustible(
  nodocomb: TNodoCombustible): boolean;
begin
  Result := self.nodocomb = nodocomb;
end;

procedure TActorUniNodalCombustible.PubliVars;
begin
  inherited PubliVars;
  PublicarVariableVR('Q', '[m3/s]', 6, 2, Q, True, True);   //verificar unidades
end;

procedure TActorUniNodalCombustible.PrepararMemoria(Catalogo: TCatalogoReferencias;
  globs: TGlobs);
begin
  inherited PrepararMemoria(Catalogo, globs);
  setlength(Q, globs.NPostes);
end;


procedure TActorUniNodalCombustible.Free;
begin
  setlength(Q, 0);
  inherited Free;
end;


//-------------------------
// Métodos de TActorBiNodalCombustible
//=========================

constructor TActorBiNodalCombustible.Create(capa: integer; nombre: string;
  nacimiento, muerte: TFecha; lpdUnidades: TFichasLPD;
  NodoCombA, NodoCombB: TNodoCombustible;
  xFuenteIdxP: TFuenteAleatoria; xBorneIdxP: string );
begin
  inherited Create(capa, nombre, nacimiento, muerte, lpdUnidades,
  xFuenteIdxP, xBorneIdxP );
  self.NodoCombA := NodoCombA;
  self.NodoCombB := NodoCombB;
end;

function TActorBiNodalCombustible.Rec: TCosa_RecLnk;
begin
  Result:=inherited Rec;
  Result.addCampoDef_ref('nodo combustible A', TCosa(NodoCombA), Self);
  Result.addCampoDef_ref('nodo combustible B', TCosa(NodoCombB), Self);
end;

procedure TActorBiNodalCombustible.BeforeRead(version, id_hilo: integer);
begin
  inherited BeforeRead(version, id_hilo);
end;

procedure TActorBiNodalCombustible.AfterRead(f:TArchiTexto);
begin
  inherited AfterRead(f);
end;


function TActorBiNodalCombustible.ReferenciaAlNodoCombustible(
  nodocomb: TNodoCombustible): boolean;
begin
  Result := (nodoCombA = nodocomb) or (nodoCombB = nodocomb);
end;

procedure TActorBiNodalCombustible.PrepararMemoria(Catalogo: TCatalogoReferencias;
  globs: TGlobs);
begin
  inherited prepararMemoria(Catalogo, globs);
  setlength(Q_NodoCombA, globs.NPostes);
  setlength(Q_NodoCombB, globs.NPostes);
end;

procedure TActorBiNodalCombustible.Free;
begin
  setlength(Q_NodoCombA, 0);
  setlength(Q_NodoCombB, 0);
  inherited Free;
end;


procedure AlInicio;
begin
  registrarClaseDeCosa(TActorUniNodalCombustible.ClassName, TActorUniNodalCombustible);
  registrarClaseDeCosa(TActorBiNodalCombustible.ClassName, TActorBiNodalCombustible);
end;

procedure AlFinal;
begin
end;

end.
