unit uBaseMercadoSpot;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
  uComercioInternacional, uFichasLPD, uFuentesAleatorias, xMatDefs,
  uFechas, uNodos,
  uCosa, uCosaConNombre,
  uGlobs, Classes, contnrs, uSimplex;

type

  { TBaseMercadoSpot }

  TBaseMercadoSpot = class(TComercioInternacional)
  protected
    numeroBorne: integer;

  public
    (**************************************************************************)
    (*               A T R I B U T O S   P E R S I S T E N T E S              *)
    (**************************************************************************)

    fuente: TFuenteAleatoria;  //Se usa para calcular el costo variable
    nombreBorne: string;

    (**************************************************************************)

    costos: TDAofNReal;

    constructor Create(capa: integer; nombre: string; nacimiento, muerte: TFecha;
      lpdUnidades, lpd: TFichasLPD; Nodo: TNodo; fuente: TFuenteAleatoria;
  nombreBorne: string; xFuenteIdxP: TFuenteAleatoria; xBorneIdxP: string);
  virtual;

    function Rec: TCosa_RecLnk; override;
    procedure BeforeRead(version, id_hilo: integer); override;
    procedure AfterRead(f:TArchiTexto); override;

    class function TipoFichaLPD: TClaseDeFichaLPD; virtual; abstract;
    procedure PrepararMemoria(Catalogo: TCatalogoReferencias; globs: TGlobs); override;

    procedure Free; override;
  end;

  TClaseDeMercadoSpot = class of TBaseMercadoSpot;

implementation

constructor TBaseMercadoSpot.Create(capa: integer; nombre: string;
  nacimiento, muerte: TFecha; lpdUnidades, lpd: TFichasLPD; Nodo: TNodo;
  fuente: TFuenteAleatoria; nombreBorne: string;
  xFuenteIdxP: TFuenteAleatoria; xBorneIdxP: string );
begin
  inherited Create(capa, nombre, nacimiento, muerte, lpdUnidades, Nodo,
  xFuenteIdxP, xBorneIdxP );
  self.lpd := lpd;
  self.fuente := fuente;
  self.nombreBorne := nombreBorne;
end;

function TBaseMercadoSpot.Rec: TCosa_RecLnk;
begin
  Result:=inherited Rec;
  Result.addCampoDef_ref('fuente', TCosa(Fuente), Self);
  Result.addCampoDef('nombreBorne', nombreBorne);
  Result.addCampoDef('lpd', TCosa(lpd));
end;

procedure TBaseMercadoSpot.BeforeRead(version, id_hilo: integer);
begin
  inherited BeforeRead(version, id_hilo);
end;

procedure TBaseMercadoSpot.AfterRead(f:TArchiTexto);
begin
  inherited AfterRead(f);
  lpd.Propietario := self;
end;

procedure TBaseMercadoSpot.PrepararMemoria(Catalogo: TCatalogoReferencias;
  globs: TGlobs);
begin
  inherited PrepararMemoria(Catalogo, globs);
  SetLength(costos, globs.NPostes);
  numeroBorne := fuente.idBorne(nombreBorne);
end;

procedure TBaseMercadoSpot.Free;
begin
  if length(costos) <> 0 then
    SetLength(costos, 0);
  if lpd <> nil then
    lpd.Free;
  inherited Free;
end;

end.

