unit uGTer;

{$MODE Delphi}

interface

uses
  Classes, uActores, uFichasLPD, xMatDefs, uFechas, uNodos,
  uGeneradores, uCosa, SysUtils, uFuentesAleatorias;

resourcestring
  rsGeneradorTermico = 'Generador térmico';

const
  GTER_PRECISIONPOTENCIANMAQS = 0.001;

type

  { TGTer }

  TGTer = class(TGenerador)
  public
    constructor Create(capa: integer; nombre: string; nacimiento, muerte: TFecha;
      lpdUnidades, lpd: TFichasLPD; nodo: TNodo;
  flg_CalcularGradienteDeInversion: boolean; TonCO2xMWh: NReal; LowCostMustRun,
  CleanDevelopmentMechanism: boolean; xFuenteIdxP: TFuenteAleatoria;
  xBorneIdxP: string); virtual;

    function Rec: TCosa_RecLnk; override;
    procedure BeforeRead(version, id_hilo: integer); override;
    procedure AfterRead(f:TArchiTexto); override;

    procedure sim_PrintResultados_Encab_PotFirme(var fsal: textfile;
      kencab: integer); virtual;
    procedure sim_PrintResultados_PotFirme(var fsal: textfile); virtual;
    procedure Free; override;
    class function DescClase: string; override;

    class procedure generarLineaEncabezadosResumen(var archi: TextFile);

    procedure generarLineaResumenPrimerFicha(var archi: TextFile);
  end;

  TClaseDeGTer = class of TGTer;

implementation

constructor TGTer.Create(capa: integer; nombre: string; nacimiento, muerte: TFecha;
  lpdUnidades, lpd: TFichasLPD; nodo: TNodo; flg_CalcularGradienteDeInversion: boolean;
  TonCO2xMWh: NReal; LowCostMustRun, CleanDevelopmentMechanism: boolean;
  xFuenteIdxP: TFuenteAleatoria; xBorneIdxP: string );
begin
  inherited Create(capa, nombre, nacimiento, muerte, lpdUnidades,
    nodo, TonCO2xMWh, LowCostMustRun, CleanDevelopmentMechanism,
    flg_CalcularGradienteDeInversion, xFuenteIdxP, xBorneIdxP );
  self.lpd := lpd;
end;

function TGTer.Rec: TCosa_RecLnk;
begin
  Result:=inherited Rec;
  Result.addCampoDef('lpd', TCosa(lpd));
end;

procedure TGTer.BeforeRead(version, id_hilo: integer);
begin
  inherited BeforeRead(version, id_hilo);
end;

procedure TGTer.AfterRead(f:TArchiTexto);
begin
  inherited AfterRead(f);
  lpd.Propietario := self;
end;


procedure TGTer.sim_PrintResultados_Encab_PotFirme(var fsal: textfile; kencab: integer);

begin
  if kencab = 0 then
  begin
    Write(fsal, #9, Nombre); //Potencia firme
  end
  else if kencab = 1 then
  begin
    Write(fsal, #9, '[MW]'); //Potencia firme
  end
  else
  begin
    Write(fsal, #9, 'PFirme'); //Potencia firme
  end;
end;

procedure TGTer.sim_PrintResultados_PotFirme(var fsal: textfile);
begin
  Write(fsal, #9, PotenciaFirme);
end;

procedure TGTer.Free;
begin
  if lpd <> nil then
    self.lpd.Free;
  inherited Free;
end;

class function TGTer.DescClase: string;
begin
  Result := rsGeneradorTermico;
end;

class procedure TGTer.generarLineaEncabezadosResumen(var archi: TextFile);
begin
  writeln(archi, 'Nombre'#9 + 'PMín[MW]'#9 + 'PMáx[MW]'#9 +
    'CV_PMín[USD/MWh]'#9 + 'CV_Medio[USD/MWh]'#9 + 'CV_Incremental[USD/MWh]'#9 +
    'FDisp[p.u.]'#9 + 'Costo Arranque[USD]'#9 + 'Costo Parada[USD]'#9 +
    'NUnidades'#9 + 'mínNPasosOn'#9 + 'mínNPasosOff'#9 +
    'desiciónPasosOnPorCiclo'#9 + 'desiciónPasosOffPorCiclo'#9 +
    'costoPorCicloOn'#9 + 'costoPorCicloOff');
end;

procedure TGTer.generarLineaResumenPrimerFicha(var archi: TextFile);
var
  i: integer;
begin
  Write(archi, nombre, #9);
  if lpd.Count > 0 then
    TFichaLPD(lpd[0]).generarLineaResumen(archi)
  else
    for i := 1 to 8 do
      Write(archi, '', #9);
  if lpdUnidades.Count > 0 then
    TFichaLPD(lpdUnidades[0]).generarLineaResumen(archi)
  else
    Write(archi, '', #9);
  writeln(archi);
end;

end.
