//====Modificado metodos: CreateDataColumnList y CreateDataConversionList===
//====Micho@27/5==mvarela@adme.com.uy=======================================
unit ugsimple_monocombustible;

interface

uses
  Math,
  SysUtils, Classes, xmatdefs, uGTer, uNodos,
  uglobs,
  usimplex,
  ufichasLPD,
  ufechas,
  ucosa, uCosaConNombre,
  uconstantesSimSEE,
  uFuentesAleatorias,
  unodocombustible;

resourcestring
  rsGeneradorSimpleMonoCombustible = 'Generador simple MonoCombustible';

type

  { TFichaGSimple_MonoCombustible }

  TFichaGSimple_MonoCombustible = class(TFichaLPD)

  public
    (**************************************************************************)
    (*               A T R I B U T O S   P E R S I S T E N T E S              *)
    (**************************************************************************)

    PMax: NReal; // [MW] Potencia Máxima Por maquina
    disp: NReal; // disponibilidad (fortuita)
    tRepHoras: NReal;
    PagoPorDisponibilidad_USD_MWh: NReal; // [USD/MWh] Pago por Potencia
    PagoPorEnergia_USD_MWh: NReal; // [USD/MWh] Pago por Energia
    QMax_A: NReal; // Máximos caudales de cada combustible
    ren_A: NReal; // rendimiento en por unidad con el combustible A

    (**************************************************************************)

    constructor Create(capa: integer; fecha: TFecha; periodicidad: TPeriodicidad;
      PMax, QMax_A, ren_A: NReal; disp: NReal; tRepHoras: NReal;
      PagoPorDisponibilidad_USD_MWh: NReal; PagoPorEnergia_USD_MWh: NReal);

    function Rec: TCosa_RecLnk; override;
    procedure BeforeRead(version, id_hilo: integer); override;
    procedure AfterRead(f:TArchiTexto); override;

    function infoAd_: string; override;
    procedure Free; override;
    procedure generarLineaResumen(var archi: TextFile); override;
  end;




  // TGSimple_MonoCombustible es un generador sin minimos tecnicos ni tiempos ni costos
  // de arranque y parada
  TGSimple_MonoCombustible = class(TGTer)

  public
    (**************************************************************************)
    (*               A T R I B U T O S   P E R S I S T E N T E S              *)
    (**************************************************************************)

    nodoCombA: TNodoCombustible;

    (**************************************************************************)

    pa: TFichaGSimple_MonoCombustible;
    NMaquinasDespachadas: TDAOfNInt;
    // cantidad de máquinas despachadas por poste o por paso ( Acople )

    consumos: TDAofNReal;              // consumos por máquina por poste

    maxNMaquinasDespachadas: integer; // máximo del vector anterior

    cve: NReal; // costo por la energía adicional a CV
    ren_ro_PCI_A: NReal;

    P_opmax: NReal;

    qa: TDAOfNReal;

    // resultado de los sorteos de disponibilidad y del mantenimiento programado
    NMaquinasDisponibles: integer;

    PMaxDisponible: NReal;
    QAMaxOperativo_pu: NReal;
    QAMax: NReal;

    //Cuanta potencia despacho en cada hora el generador en promedio
    potMedia_despachada: NReal;

    constructor Create(capa: integer; nombre: string; nacimiento, muerte: TFecha;
      lpdUnidades, lpd: TFichasLPD; nodo: TNodo;
  flg_CalcularGradienteDeInversion: boolean; nodoCombA: TNodoCombustible;
  TonCO2xMWh: NReal; LowCostMustRun, CleanDevelopmentMechanism: boolean;
  xFuenteIdxP: TFuenteAleatoria; xBorneIdxP: string);

    function Rec: TCosa_RecLnk; override;
    procedure BeforeRead(version, id_hilo: integer); override;
    procedure AfterRead(f:TArchiTexto); override;

    procedure PrepararMemoria(Catalogo: TCatalogoReferencias; globs: TGlobs); override;
    procedure RegistrarParametrosDinamicos(Catalogo: TCatalogoReferencias); override;

    function PotenciaFirme: NReal; override;

    function InfoAd_: string; override;
    class function DescClase: string; override;

    procedure SorteosDelPaso(sortear: boolean); override;
    procedure CambioFichaPD; override;
    procedure PrepararPaso_as; override;
    procedure PrepararPaso_ps; override;
    procedure Sim_Paso_Fin; override;

    procedure opt_nvers(var ivar, ivae, ires: integer); override;

    procedure opt_cargue(s: TSimplex); override;
    procedure opt_fijarRestriccionesDeCaja(s: TSimplex); override;
    procedure opt_leerSolucion(s: TSimplex); override;

    function getNombreVar(ivar: integer; var nombre: string): boolean; override;
    function getNombreRes(ires: integer; var nombre: string): boolean; override;

    procedure Free; override;

    procedure PubliVars; override;
    procedure dump_Variables(var f: TextFile; charIndentacion: char); override;

    class function TipoFichaLPD: TClaseDeFichaLPD; override;

    function get_pa_FD(kTipoUnidad: integer): NReal; override;
    function get_pa_TMR(kTipoUnidad: integer): NReal; override;

    {$IFDEF BOSTA}
    procedure AfterInstantiation; override;
    {$ENDIF}

  end;


procedure TGSimple_MonoCombustible_CambioFichaPD(actor: TCosa);

procedure AlInicio;
procedure AlFinal;

implementation


procedure TGSimple_MonoCombustible_CambioFichaPD(actor: TCosa);
begin
  (Actor as TGSimple_MonoCombustible).cambioFichaPD;
end;



//---------------------------------------
// Métodos de TFichaGSimple_MonoCombustible
//=======================================
constructor TFichaGSimple_MonoCombustible.Create(capa: integer;
  fecha: TFecha; periodicidad: TPeriodicidad; PMax, QMax_A, ren_A: NReal;
  disp: NReal; tRepHoras: NReal; PagoPorDisponibilidad_USD_MWh: NReal;
  PagoPorEnergia_USD_MWh: NReal);

begin
  inherited Create(capa, fecha, periodicidad);
  self.PMax := PMax;
  self.QMax_A := QMax_A;
  self.ren_A := ren_A;
  self.disp := disp;
  self.tRepHoras := tRepHoras;
  self.PagoPorDisponibilidad_USD_MWh := PagoPorDisponibilidad_USD_MWh;
  self.PagoPorEnergia_USD_MWh := PagoPorEnergia_USD_MWh;
end;

function TFichaGSimple_MonoCombustible.Rec: TCosa_RecLnk;
begin
  Result:=inherited Rec;
  Result.addCampoDef('PMax', PMax);
  Result.addCampoDef('disp', disp);
  Result.addCampoDef('tRepHoras', tRepHoras);
  Result.addCampoDef('PagoPorDisponibilidad_USD_MWh', PagoPorDisponibilidad_USD_MWh);
  Result.addCampoDef('PagoPorEnergia_USD_MWh', PagoPorEnergia_USD_MWh);
  Result.addCampoDef('QMax_A', QMax_A);
  Result.addCampoDef('ren_A', ren_A);
end;

procedure TFichaGSimple_MonoCombustible.BeforeRead(version, id_hilo: integer);
begin
  inherited BeforeRead(version, id_hilo);
end;

procedure TFichaGSimple_MonoCombustible.AfterRead(f:TArchiTexto);
begin
  inherited AfterRead(f);
end;


function TFichaGSimple_MonoCombustible.infoAd_: string;
begin
  Result := 'PMax= ' + FloatToStrF(PMax, ffGeneral, 10, 1) + ' MW, ' +
    'fdisp= ' + FloatToStrF(disp, ffGeneral, 10, 2) + ' p.u., ' +
    'tRep= ' + FloatToStrF(tRepHoras, ffGeneral, 10, 1) + 'h';
end;

procedure TFichaGSimple_MonoCombustible.Free;
begin
  inherited Free;
end;


procedure TFichaGSimple_MonoCombustible.generarLineaResumen(var archi: TextFile);
begin
  Write(archi, '-', #9,                                     //PMín
    FloatToStrF(PMax, formatoReales, 8, 1), #9,  //PMáx
    '-', #9,                                     //CV_Mín
    '-', #9,    //CV_Medio
    '-', #9,    //CV_Incremental
    FloatToStrF(disp, formatoReales, 8, 2), #9,  //FDisp
    '-', #9,                                     //Costo Arranque
    '-', #9,                                     //Costo Parada
    '-', #9,                                     //mínNPasosOn
    '-', #9,                                     //mínNPasosOff
    '-', #9,                                     //desiciónPasosOnPorCiclo
    '-', #9,                                     //desiciónPasosOffPorCiclo
    '-', #9,                                     //costoPorCicloOn
    '-', #9);                                    //costoPorCicloOff
end;



//------------------------
// Métodos de TGSimple_MonoCombustible
//========================
procedure TGSimple_MonoCombustible.dump_Variables(var f: TextFile;
  charIndentacion: char);
begin
  inherited dump_Variables(f, charIndentacion);

  writeln(f, charIndentacion, 'PMax[MW]= ', FloatToStrF(pa.PMax, ffFixed, 10, 3));
  writeln(f, charIndentacion, 'PMaxDisponible[MW]= ',
    FloatToStrF(PMaxDisponible, ffFixed, 10, 3));

  writeln(f, charIndentacion, 'NMaquinasDisponibles= ', NMaquinasDisponibles);

  writeln(f);
end;

class function TGSimple_MonoCombustible.TipoFichaLPD: TClaseDeFichaLPD;
begin
  Result := TFichaGSimple_MonoCombustible;
end;

constructor TGSimple_MonoCombustible.Create(capa: integer; nombre: string;
  nacimiento, muerte: TFecha; lpdUnidades, lpd: TFichasLPD; nodo: TNodo;
  flg_CalcularGradienteDeInversion: boolean; nodoCombA: TNodoCombustible;
  TonCO2xMWh: NReal; LowCostMustRun, CleanDevelopmentMechanism: boolean;
  xFuenteIdxP: TFuenteAleatoria; xBorneIdxP: string );
begin
  inherited Create(capa, nombre, nacimiento, muerte,
    lpdUnidades, lpd, nodo,
    flg_CalcularGradienteDeInversion,
    TonCO2xMWh, LowCostMustRun, CleanDevelopmentMechanism,
    xFuenteIdxP, xBorneIdxP );
  P := nil;
  qa := nil;
  NMaquinasDespachadas := nil;
  self.nodoCombA := nodoCombA;
end;

function TGSimple_MonoCombustible.Rec: TCosa_RecLnk;
begin
  Result:=inherited Rec;
  Result.addCampoDef_ref('NodoCombA', TCosa(NodoCombA), self);
end;

procedure TGSimple_MonoCombustible.BeforeRead(version, id_hilo: integer);
begin
  inherited BeforeRead(version, id_hilo);
end;

procedure TGSimple_MonoCombustible.AfterRead(f:TArchiTexto);
begin
  inherited AfterRead(f);
  P := nil;
  qa := nil;
  NMaquinasDespachadas := nil;
  pa := nil;
end;


procedure TGSimple_MonoCombustible.PrepararMemoria(Catalogo: TCatalogoReferencias;
  globs: TGlobs);
begin
  inherited prepararMemoria(Catalogo, globs);
  setlength(qa, globs.NPostes);
  SetLength(NMaquinasDespachadas, globs.NPostes);
end;

procedure TGSimple_MonoCombustible.RegistrarParametrosDinamicos(
  Catalogo: TCatalogoReferencias);
begin
  inherited registrarParametrosDinamicos(Catalogo);
  lpd.expandirFichas(Catalogo, globs);
  lpd.RegistrarFichasAActualizar(Self, globs.ActualizadorLPD, @pA,
    nil, TGSimple_MonoCombustible_CambioFichaPD);
end;

function TGSimple_MonoCombustible.PotenciaFirme: NReal;
begin
  Result := (paUnidades.nUnidades_Operativas[0]) * pa.PMax * pa.disp;
end;

function TGSimple_MonoCombustible.InfoAd_: string;
begin
  Result := '';
end;

class function TGSimple_MonoCombustible.DescClase: string;
begin
  Result := rsGeneradorSimpleMonoCombustible;
end;


function TGSimple_MonoCombustible.get_pa_FD(kTipoUnidad: integer): NReal;
begin
  Result := pa.disp;
end;

function TGSimple_MonoCombustible.get_pa_TMR(kTipoUnidad: integer): NReal;
begin
  Result := pa.tRepHoras;
end;


{$IFDEF BOSTA}
procedure TGSimple_MonoCombustible.AfterInstantiation;
begin
  inherited AfterInstantiation;
  P := nil;
  qa := nil;
  NMaquinasDespachadas := nil;
  pa := nil;
end;
{$ENDIF}

procedure TGSimple_MonoCombustible.SorteosDelPaso(sortear: boolean);
begin
  if hayForzamientos or globs.ObligarDisponibilidad_1_ then
  begin
    NMaquinasDisponibles := paUnidades.nUnidades_Operativas[0];
    //supongo que nUnidades[0] tiene el total de maquinas de la central
    PMaxDisponible := pa.PMax * NMaquinasDisponibles;
    QAmax := QAMaxOperativo_pu * NMaquinasDisponibles;
  end
  else if sortear then
  begin
    ActualizarProbabilidadesReparacionYRotura_(pa.disp, pa.tRepHoras);
    NMaquinasDisponibles := Sorteos_RepRotUnidades;
    PMaxDisponible := pa.PMax * NMaquinasDisponibles;
    QAmax := QAMaxOperativo_pu * NMaquinasDisponibles;
    //si hay que sortear hace el sorteo y la potencia total
  end
  //queda afectada por la cantidad de maquinas disponibles
  else
  begin
    NMaquinasDisponibles := paUnidades.nUnidades_Operativas[0];
    //si no hay que sortear deja todas las maquinas disponibles
    //pero afecta a la potencia disponible por la disponibilidad
    PMaxDisponible := pa.PMax * pa.disp * NMaquinasDisponibles;
    QAmax := QAMaxOperativo_pu * pa.disp * NMaquinasDisponibles;
  end;
end;


procedure TGSimple_MonoCombustible.PrepararPaso_as;
begin
  ren_ro_PCI_A := pa.ren_A * nodoCombA.combustible.MWh_por_Q1h_;
end;

procedure TGSimple_MonoCombustible.PrepararPaso_ps;
{$IFDEF CALC_MMEE}
var
  k: integer;
{$ENDIF}
begin

  {$IFDEF CALC_MMEE}
  for k := 0 to globs.NPOstes - 1 do
    mmee_cv_paraPrecioSpot[k] := cv;
  {$ENDIF}

end;

procedure TGSimple_MonoCombustible.Sim_Paso_Fin;
var
  iposte: integer;
  ePoste: NReal;
begin
  potMedia_despachada := 0;


  if NMaquinasDisponibles = 0 then
  begin
  {$IFDEF CALC_MMEE}
    vclear(mmee_IngresosSpot_USD);
    vclear(mmee_CargosAlSeguimientoDeLaDemanda_USD);
  {$ENDIF}
  end
  else
  begin
    for iposte := 0 to high(P) do
    begin
      ePoste := P[iposte] * globs.durpos[iposte];
      potMedia_despachada := potMedia_despachada + ePoste;

      {$IFDEF CALC_MMEE}
      if (mmee_cv_paraPrecioSpot[iposte] > globs.mmee_topePrecioSpot) then
      begin
        mmee_CargosAlSeguimientoDeLaDemanda_USD[iposte] :=
          ePoste * (mmee_cv_paraPrecioSpot[iposte] - globs.mmee_topePrecioSpot);
        mmee_IngresosSpot_USD[iposte] := ePoste * globs.mmee_topPrecioSpot;
      end
      else
      begin
        mmee_CargosAlSeguimientoDeLaDemanda_USD[iposte] := 0;
        mmee_IngresosSpot_USD[iposte] := ePoste * globs.mmee_PrecioSpot[iposte];
      end;
      {$ENDIF}
    end;
    potMedia_despachada := potMedia_despachada * globs.invHorasDelPaso;
  end;
end;

procedure TGSimple_MonoCombustible.opt_nvers(var ivar, ivae, ires: integer);
begin
  if NMaquinasDisponibles = 0 then
    exit; // si no hay máquinas no juego
  Self.ivar := ivar;
  ivar := ivar + globs.NPostes;
end;


procedure TGSimple_MonoCombustible.CambioFichaPD;
//donde uso las potencias de operacion? en el simplex impongo restriccion
//de caudales pero podria ser que la Pop este limitada por la Pmax y en ese caso el caudal que obtengo me dara una P mayor
//que la que puedo dar Pop=Pmax.
begin
  // P = ren * Q * ro * PCI
  QAMaxOperativo_pu := Math.Min(pa.PMax * 1.0E6 /
    (pa.ren_a * nodoCombA.combustible.ro_PCI), pa.QMax_A);
end;

procedure TGSimple_MonoCombustible.opt_cargue(s: TSimplex);
var
  inodores, inodoCombres: integer;
  iposte: integer;
begin
  if NMaquinasDisponibles = 0 then
    exit; // si no hay máquinas no juego

  inodores := nodo.ires; //indice de la restricion de nodo electrico
  inodoCombres := nodocombA.ires; //indice de la restricion de nodo electrico

  for iposte := 0 to globs.NPostes - 1 do
  begin
    // cargamos la potencia en la restricción de balance de potencia del nodo
    s.pon_e(inodores + iposte, ivar + 0 + iposte, ren_ro_PCI_A);
    // cargamos los caudales en la restricción de balance de caudal de los nodos
    s.pon_e(inodoCombres + iposte, ivar + 0 + iposte, -1);
  end;
end;

procedure TGSimple_MonoCombustible.opt_fijarRestriccionesDeCaja(s: TSimplex);
var
  iposte: integer;
begin
  if NMaquinasDisponibles = 0 then
    exit;
  // obligamos a que alfa se encuentre entre 0 y 1 en todos lso postes
  // y que los caudales sean menores que qamax y qbmax
  for iposte := 0 to globs.NPostes - 1 do
  begin
    s.cota_sup_set(ivar + 0 + iposte, QAMax);
  end;
end;

procedure TGSimple_MonoCombustible.opt_leerSolucion(s: TSimplex);
var
  iposte: integer;
  me, meAcum: NReal;

begin
  costoDirectoDelPaso := 0;
  maxNMaquinasDespachadas := 0;
  if NMaquinasDisponibles = 0 then
  begin
    vclear(P);
    vclear(qa);
    vclear(NMaquinasDespachadas);
    Ingreso_PorDisponibilidad_ := 0;
    Ingreso_PorEnergia_ := 0;
    exit;
  end;
  Ingreso_PorDisponibilidad_ :=
    self.PMaxDisponible * globs.HorasDelPaso *    //ingreso por potencia
    pa.PagoPorDisponibilidad_USD_MWh;
  // recuperamos los valores de qa y qb despachadas
  meAcum := 0;
  for iposte := 0 to globs.NPostes - 1 do
  begin
    QA[iposte] := s.xval(ivar + 0 + iposte);
    P[iposte] := // ren * ro * PCI * Q
      qa[iposte] * ren_ro_PCI_A;
    if P[iposte] > GTER_PRECISIONPOTENCIANMAQS then
    begin
      NMaquinasDespachadas[iposte] :=
        Math.Ceil((P[iposte] - GTER_PRECISIONPOTENCIANMAQS) / pa.PMax);
      me := P[iposte] * globs.DurPos[iposte];
      meAcum := meAcum + me;
      if NMaquinasDespachadas[iposte] > maxNMaquinasDespachadas then
        maxNMaquinasDespachadas := NMaquinasDespachadas[iposte];
    end
    else
    begin
      NMaquinasDespachadas[iposte] := 0;
    end;
  end;
  Ingreso_PorEnergia_ := meAcum * pa.PagoPorEnergia_USD_MWh;
end;


function TGSimple_MonoCombustible.getNombreVar(ivar: integer;
  var nombre: string): boolean;
var
  kPoste: integer;
  jvar: integer;
begin
  if NMaquinasDisponibles = 0 then
    Result := False
  else
  begin
    jvar := ivar - self.ivar;
    if (jvar >= 0) and (jvar < (globs.NPostes)) then
    begin
      kPoste := jvar;
      nombre := self.Nombre + '_QA[m3/s]_' + IntToStr(kPoste + 1);
      Result := True;
    end
    else
      Result := False;
  end;
end;

function TGSimple_MonoCombustible.getNombreRes(ires: integer;
  var nombre: string): boolean;
begin
  Result := False;
end;

procedure TGSimple_MonoCombustible.PubliVars;
begin
  inherited PubliVars;
  PublicarVariableVI('NMaqsDespachadas', '-', NMaquinasDespachadas, True, True);
  PublicarVariableVR('QA', '[m3/s]', 6, 2, QA, True, True);

  {$IFDEF DECLARAR_VARIABLES_SIMRES_DEF}
  declararVarsPSimResPorDefectoIntercalandoPostes(['P', 'Costo', 'NMaqsDespachadas'],
    globs.NPostes);
  {$ENDIF}

  PublicarVariableNI('MaxNMaqsDespachadasEnElPaso', '-', maxNMaquinasDespachadas, False);
  PublicarVariableNI('NMaqsDisponibles', '-', NMaquinasDisponibles, False);
  PublicarVariableNR('PMáxDisponible', '[MW]', 6, 2, PMaxDisponible, False);
  PublicarVariableNR('PMediaDespachada', '[MW]', 6, 2, potMedia_despachada, False);
end;

procedure TGSimple_MonoCombustible.Free;
begin
  setlength(NMaquinasDespachadas, 0);
  inherited Free;
end;

procedure AlInicio;
begin
  registrarClaseDeCosa(TGSimple_MonoCombustible.ClassName, TGSimple_MonoCombustible);
  registrarClaseDeCosa(TFichaGSimple_MonoCombustible.ClassName,
    TFichaGSimple_MonoCombustible);
end;

procedure AlFinal;
begin
end;

end.
