//====Modificado metodos: CreateDataColumnList y CreateDataConversionList===
//====Micho@27/5==mvarela@adme.com.uy=======================================
unit ugter_arranqueparada;

{$DEFINE PROBANDO_OPTROT}
{$DEFINE HISTERESIS_AP}

interface

uses
  SysUtils, Classes, xmatdefs, uGTer, unodos, Math,
  uglobs,
  uEstados,
  usimplex,
  ufichasLPD,
  ufechas,
  ucosa, uCosaConNombre,
  uconstantesSimSEE,
  uFuentesAleatorias;

resourcestring
  rsGeneradorTermicoConCostoArranqueParada = 'GTer con costos arranque/parada';

type

  { TFichaGTer_ArranqueParada }

  TFichaGTer_ArranqueParada = class(TFichaLPD)

  public
    (**************************************************************************)
    (*               A T R I B U T O S   P E R S I S T E N T E S              *)
    (**************************************************************************)

    PagoPorDisponibilidad_USD_MWh: NReal;
    PagoPorEnergia_USD_MWh: NReal;
    PMin, PMax: NReal; // [MW] Potencias Mínima y Máxima Por maquina
    cv_min, cv, cv_NoCombustible: NReal; // Costo:= cv_min* Pmin+ cv* (P-Pmin)
    indicePreciosPorCombustible: TFuenteAleatoria;
    bornePreciosPorCombustible: string;
    disp: NReal; // disponibilidad (fortuita)
    tRepHoras: NReal;
    costo_arranque, costo_parada: NReal;
    HayRestriccionEmaxPasoDeTiempo: boolean; // indica si se aplica la restricción
    EmaxPasoDeTiempo: NReal; // Energía maxima generable en un paso de tiempo
    MinHorasON, MinHorasOFF: integer; // valor mínimo entre arranques y paradas.
    PenalidadONOFF: NReal;

    (**************************************************************************)

    nroBornePreciosPorCombustible: integer;

    constructor Create(capa: integer; fecha: TFecha; periodicidad: TPeriodicidad;
      PMin, PMax: NReal; cv_min, cv, cv_NoCombustible: NReal;
      indicePreciosPorCombustible: TFuenteAleatoria; bornePreciosPorCombustible: string;
      disp: NReal; tRepHoras: NReal; costo_arranque, costo_parada: Nreal;
      HayRestriccionEmaxPasoDeTiempo: boolean; EmaxPasoDeTiempo: NReal;
      xMinHorasON, xMinHorasOFF: integer; xPenalidadONOFF: NReal;
      PagoPorDisponibilidad_USD_MWh, PagoPorEnergia_USD_MWh: NReal);

    function Rec: TCosa_RecLnk; override;
    procedure BeforeRead(version, id_hilo: integer); override;
    procedure AfterRead(f:TArchiTexto); override;

    procedure generarLineaResumen(var archi: TextFile); override;
    function infoAd_: string; override;
    procedure Free; override;
  end;

  // TGTer_OnOffPorPaso es una potencia minima y maxima constante en todos los postes
  // y un costo variable cv [USD/MWh] tambien igual en todos los postes
  // y un costo variable cv_min "hasta el minimo" igual al costo de produccion en USD/MWh cuando
  // la central esta generado en el minimo.

  { TGTer_ArranqueParada }

  TGTer_ArranqueParada = class(TGTer)

  public

    (**************************************************************************)
    (*               A T R I B U T O S   P E R S I S T E N T E S              *)
    (**************************************************************************)

    FechaCambioEstado_ini: TFecha;
    encendidoAlInicio: boolean;

    (**************************************************************************)



    pa: TFichaGTer_ArranqueParada;

    // NMaquinasDespachadas_AlInicioDelPaso: Integer;
    X_NMaquinasDespachadas, Xs_NMaquinasDespachadas: integer;
    // cantidad de máquinas despachadas ( variable de Acople )

    // introduzco para la simulación la posibilidad de especificar
    // horas de histérisis entre arranques y paradas.
    // esto intenta evitar la conmutación de las turbo vapor entre pasos consecutivos
    // sobre todo en simulaciones horarias.
    X_HorasHisteresisAP, Xs_HorasHisterisisAP: double;

{$IFDEF PROBANDO_OPTROT}
    // se actualiza en sortesodelpaso. Esta variable se utiliza
    // durante la Optimización para determinar la disponibilidad de la máquina
    // dado que se encuentre encendida.
    Romperse: boolean;
{$ENDIF}

    c0: NReal; //Costo en USD/h por máquina por estar operando en el mínimo técnico
    cv: NReal; // USD/MWh usado para la optimización del paso.
    cve: NReal; // PagoAdicional por energía USD/MWh (se indexa igual que el cv )

    PMin: NReal; //MW, mínimo
    PxMax: NReal; // MW, cota sup de P-Pmin
    BMax: NReal; // MW, cota sup de P-Pmin


    // resultado de los sorteos de disponibilidad y del mantenimiento programado
    NMaquinasDisponibles_: integer;
    PMaxDisponible: NReal;

    //Cuanta potencia despacho en cada hora el generador en promedio
    potMedia_despachada: NReal;

    //Variación de costo futuro por transición de estado en USD
    dCF: NReal;

    constructor Create(capa: integer; nombre: string; nacimiento, muerte: TFecha;
      lpdUnidades, lpd: TFichasLPD; nodo: TNodo;
  flg_CalcularGradienteDeInversion: boolean; encendidoAlInicio: boolean;
  xFechaCambioEstado_ini: TFecha; TonCO2xMWh: NReal; LowCostMustRun,
  CleanDevelopmentMechanism: boolean; xFuenteIdxP: TFuenteAleatoria;
  xBorneIdxP: string); reintroduce;

    function Rec: TCosa_RecLnk; override;
    procedure BeforeRead(version, id_hilo: integer); override;
    procedure AfterRead(f:TArchiTexto); override;

    procedure PrepararMemoria(Catalogo: TCatalogoReferencias; globs: TGlobs); override;
    procedure RegistrarParametrosDinamicos(CatalogoReferencias: TCatalogoReferencias); override;

    function PotenciaFirme: NReal; override;

    function InfoAd_: string; override;
    class function DescClase: string; override;

    procedure PosicionarseEnEstrellita; override;
    procedure ActualizarEstadoGlobal(flg_Xs: boolean); override;

    //      procedure Sim_Inicio; override;
    procedure Sim_Cronica_Inicio; override;

    function get_pa_FD(kTipoUnidad: integer): NReal; override;
    function get_pa_TMR(kTipoUnidad: integer): NReal; override;

    procedure SorteosDelPaso(sortear: boolean); override;
    procedure PrepararPaso_ps; override;
    procedure Sim_Paso_Fin; override;
    //      procedure Sim_Cronica_Fin; override;
    //      procedure Sim_Fin; override;

    procedure opt_nvers(var ivar, ivae, ires: integer); override;
    procedure optx_nvxs(var ixr, ixd, iauxNReal, iauxInt: integer); override;
    procedure optx_RegistrarVariablesDeEstado(adminEstados: TAdminEstados); override;

    procedure opt_cargue(s: TSimplex); override;
    procedure opt_fijarRestriccionesDeCaja(s: TSimplex); override;
    procedure opt_leerSolucion(s: TSimplex); override;
    procedure EvolucionarEstado; override;

    function getNombreVar(ivar: integer; var nombre: string): boolean; override;
    function getNombreRes(ires: integer; var nombre: string): boolean; override;

    procedure Free; override;

    procedure PubliVars; override;
    // imprime tabla de delta costo futuro de la transición USD/MWh
    procedure opt_PrintResultados_Encab(var fsal: textfile); override;
    procedure opt_PrintResultados(var fsal: textfile); override;

    procedure dump_Variables(var f: TextFile; charIndentacion: char); override;
    procedure sim_FinCronicaPrintEstadoFinal(var fsal: textfile); override;


    class function TipoFichaLPD: TClaseDeFichaLPD; override;


    function NMaquinasDisponibles_x: integer;

    {$IFDEF BOSTA}
    procedure AfterInstantiation; override;
    {$ENDIF}
  end;


procedure AlInicio;
procedure AlFinal;

implementation


//-------------------------------------
// Métodos de TFichaGTer_ArranqueParada
//=====================================

constructor TFichaGTer_ArranqueParada.Create(capa: integer; fecha: TFecha;
  periodicidad: TPeriodicidad; PMin, PMax: NReal; cv_min, cv, cv_NoCombustible: NReal;
  indicePreciosPorCombustible: TFuenteAleatoria; bornePreciosPorCombustible: string;
  disp: NReal; tRepHoras: NReal; costo_arranque, costo_parada: Nreal;
  HayRestriccionEmaxPasoDeTiempo: boolean; EmaxPasoDeTiempo: NReal;
  xMinHorasON, xMinHorasOFF: integer;
  // valor mínimo entre arranques y paradas.
  xPenalidadONOFF: NReal; PagoPorDisponibilidad_USD_MWh, PagoPorEnergia_USD_MWh: NReal);
begin
  inherited Create(capa, fecha, periodicidad);
  self.PMin := PMin;
  self.PMax := PMax;
  self.cv_min := cv_min;
  self.cv := cv;
  self.cv_NoCombustible := cv_NoCombustible;
  self.disp := disp;
  self.tRepHoras := tRepHoras;
  self.costo_arranque := costo_arranque;
  self.costo_parada := costo_parada;
  self.HayRestriccionEmaxPasoDeTiempo := HayRestriccionEmaxPasoDeTiempo;
  self.EmaxPasoDeTiempo := EmaxPasoDeTiempo;
  self.indicePreciosPorCombustible := indicePreciosPorCombustible;
  self.bornePreciosPorCombustible := bornePreciosPorCombustible;
  MinHorasON := xMinHorasON;
  MinHorasOFF := xMinHorasOFF;
  PenalidadONOFF := xPenalidadONOFF;
  Self.PagoPorDisponibilidad_USD_MWh := PagoPorDisponibilidad_USD_MWh;
  Self.PagoPorEnergia_USD_MWh := PagoPorEnergia_USD_MWh;
end;

function TFichaGTer_ArranqueParada.Rec: TCosa_RecLnk;
begin
  Result:=inherited Rec;
  Result.addCampoDef('PMin', PMin, 0, 6 );
  Result.addCampoDef('PMax', PMax, 0, 6 );
  Result.addCampoDef('cv_min', cv_min, 0, 6 );
  Result.addCampoDef('cv', cv, 0, 6 );
  Result.addCampoDef_ref('indicePreciosPorCombustible',  TCosa(indicePreciosPorCombustible), Self, 0, 6 );
  Result.addCampoDef('disp', disp, 0, 6 );
  Result.addCampoDef('costo_arranque', costo_arranque, 0, 6 );
  Result.addCampoDef('costo_parada', costo_parada, 0, 6 );
  Result.addCampoDef('HayRestriccionEmaxPasoDeTiempo', HayRestriccionEmaxPasoDeTiempo, 0, 6 );
  Result.addCampoDef('EmaxPasoDeTiempo', EmaxPasoDeTiempo, 0, 6 );
  Result.addCampoDef('PMin', PMin, 6, 14 );
  Result.addCampoDef('PMax', PMax, 6, 14 );
  Result.addCampoDef('cv_min', cv_min, 6, 14 );
  Result.addCampoDef('cv', cv, 6, 14 );
  Result.addCampoDef_ref('indicePreciosPorCombustible', TCosa(indicePreciosPorCombustible), Self, 6, 14 );
  Result.addCampoDef('bornePreciosPorCombustible', bornePreciosPorCombustible, 6, 14 );
  Result.addCampoDef('disp', disp, 6, 14 );
  Result.addCampoDef('costo_arranque', costo_arranque, 6, 14 );
  Result.addCampoDef('costo_parada', costo_parada, 6, 14 );
  Result.addCampoDef('HayRestriccionEmaxPasoDeTiempo', HayRestriccionEmaxPasoDeTiempo, 6, 14 );
  Result.addCampoDef('EmaxPasoDeTiempo', EmaxPasoDeTiempo, 6, 14 );
  Result.addCampoDef('PMin', PMin, 14 );
  Result.addCampoDef('PMax', PMax, 14 );
  Result.addCampoDef('cv_min', cv_min, 14 );
  Result.addCampoDef('cv', cv, 14 );
  Result.addCampoDef('cv_NoCombustible', cv_NoCombustible, 111 );
  Result.addCampoDef_ref('indicePreciosPorCombustible', TCosa(indicePreciosPorCombustible), Self, 14 );
  Result.addCampoDef('bornePreciosPorCombustible', bornePreciosPorCombustible, 14 );
  Result.addCampoDef('disp', disp, 14 );
  Result.addCampoDef('tRepHoras', tRepHoras, 14 );
  Result.addCampoDef('costo_arranque', costo_arranque, 14 );
  Result.addCampoDef('costo_parada', costo_parada, 14 );
  Result.addCampoDef('HayRestriccionEmaxPasoDeTiempo', HayRestriccionEmaxPasoDeTiempo, 14 );
  Result.addCampoDef('EmaxPasoDeTiempo', EmaxPasoDeTiempo, 14 );
  Result.addCampoDef('MinHorasON', MinHorasOn, 52 );
  Result.addCampoDef('MinHorasOFF', MinHorasOFF, 52 );
  Result.addCampoDef('PenalidadONOFF', PenalidadONOFF, 53 );
  Result.addCampoDef('PagoPorDisponibilidad_USD_MWh', PagoPorDisponibilidad_USD_MWh, 98 );
  Result.addCampoDef('PagoPorEnergia_USD_MWh', PagoPorEnergia_USD_MWh, 98 );
end;

procedure TFichaGTer_ArranqueParada.BeforeRead(version, id_hilo: integer);
begin
  inherited BeforeRead(version, id_hilo);
  cv_NoCombustible := 0.0;
end;

procedure TFichaGTer_ArranqueParada.AfterRead(f:TArchiTexto);
begin
  inherited AfterRead(f);
  if f.Version < 6 then
  begin
    self.indicePreciosPorCombustible := nil;
    self.bornePreciosPorCombustible := '';
    self.tRepHoras := 15 * 24;
  end
  else if f.Version < 14 then
  begin
    self.tRepHoras := 15 * 24;
  end
  else
  begin
    if f.Version < 52 then
    begin
      MinHorasOn := 0;
      MinHorasOff := 0;
    end;

    if f.Version < 53 then
    else
      PenalidadONOFF := 30E6; // 30 MUSD

    if f.Version < 98 then
    begin
      PagoPorDisponibilidad_USD_MWh := 0;
      PagoPorEnergia_USD_MWh := 0;
    end
  end;
end;


procedure TFichaGTer_ArranqueParada.generarLineaResumen(var archi: TextFile);
begin
  Write(archi, FloatToStrF(PMin, formatoReales, 8, 1), #9,
    //PMín
    FloatToStrF(PMax, formatoReales, 8, 1), #9,
    //PMáx
    FloatToStrF(cv_min, formatoReales, 8, 2), #9,
    //CV_Mín
    FloatToStrF(((cv_min * PMin + cv * (PMax - PMin)) / PMax), formatoReales, 8, 2),
    #9,   //CV_Medio
    FloatToStrF(cv, formatoReales, 8, 2), #9,
    //CV_Incremental
    FloatToStrF(disp, formatoReales, 8, 2), #9,
    //FDisp
    FloatToStrF(costo_arranque, formatoReales, 8, 2), #9,
    //Costo Arranque
    FloatToStrF(costo_parada, formatoReales, 8, 2), #9,
    //Costo Parada
    '-', #9,
    //mínNPasosOn
    '-', #9,
    //mínNPasosOff
    '-', #9,
    //desiciónPasosOnPorCiclo
    '-', #9,
    //desiciónPasosOffPorCiclo
    '-', #9,
    //costoPorCicloOn
    '-', #9);
  //costoPorCicloOff
end;

function TFichaGTer_ArranqueParada.infoAd_: string;
begin
  Result := 'PMín= ' + FloatToStrF(PMin, ffGeneral, 10, 1) + ' MW, ' +
    'PMáx= ' + FloatToStrF(PMax, ffGeneral, 10, 1) + ' MW, ' +
    'cv_min= ' + FloatToStrF(cv_min, ffGeneral, 10, 1) + ' USD/MWh, ' +
    'cv= ' + FloatToStrF(cv, ffGeneral, 10, 1) + ' USD/MWh, ' + 'fDisp= ' +
    FloatToStrF(disp, ffGeneral, 10, 2) + ' p.u., ' + 'tRep= ' +
    FloatToStrF(tRepHoras, ffGeneral, 10, 1) + 'h, ' + 'CostoArranque= ' +
    FloatToStrF(costo_arranque, ffGeneral, 10, 1) + ' USD, ' +
    'CostoParada= ' + FloatToStrF(costo_parada, ffGeneral, 10, 1) + ' USD';
end;

procedure TFichaGTer_ArranqueParada.Free;
begin
  inherited Free;
end;


//--------------------------------
// Métodos de TGTer_ArranqueParada
//================================
procedure TGTer_ArranqueParada.opt_PrintResultados_Encab(var fsal: textfile);
begin
  Write(fsal, #9, IntToStr(X_NMaquinasDespachadas));
end;

procedure TGTer_ArranqueParada.opt_PrintResultados(var fsal: textfile);
begin
  Write(fsal, #9, FloatToStrF(dCF, ffgeneral, 6, 3));
end;

procedure TGTer_ArranqueParada.dump_Variables(var f: TextFile; charIndentacion: char);
begin
  inherited dump_Variables(f, charIndentacion);
  writeln(f, charIndentacion, 'c0[USD/MWh]= ', FloatToStrF(c0, ffFixed, 10, 3));
  writeln(f, charIndentacion, 'cv[USD/MWh]= ', FloatToStrF(cv, ffFixed, 10, 3));
  writeln(f, charIndentacion, 'costo_arranque[USD]= ',
    FloatToStrF(pa.costo_arranque, ffFixed, 10, 3));
  writeln(f, charIndentacion, 'costo_parada[USD]= ',
    FloatToStrF(pa.costo_parada, ffFixed, 10, 3));

  writeln(f, charIndentacion, 'PMin[MW]= ', FloatToStrF(PMin, ffFixed, 10, 3));
  writeln(f, charIndentacion, 'PMAx[MW]= ', FloatToStrF(pa.PMax, ffFixed, 10, 3));
  writeln(f, charIndentacion, 'PxMax[MW]= ', FloatToStrF(PxMax, ffFixed, 10, 3));
  writeln(f, charIndentacion, 'PMaxDisponible[MW]= ',
    FloatToStrF(PMaxDisponible, ffFixed, 10, 3));

  writeln(f, charIndentacion, 'NMaquinasDisponibles= ', NMaquinasDisponibles_);
  writeln(f, charIndentacion, 'X_NMaquinasDespachadas= ', X_NMaquinasDespachadas);
  writeln(f, charIndentacion, 'Xs_NMaquinasDespachadas= ', Xs_NMaquinasDespachadas);

  writeln(f, charIndentacion, 'HayRestrEMaxPasoDeTiempo= ',
    pa.hayRestriccionEmaxPasoDeTiempo);
  writeln(f, charIndentacion, 'EMaxPasoDeTiempo[MW/h]= ',
    FloatToStrF(pa.EmaxPasoDeTiempo, ffFixed, 10, 3));

  writeln(f);
end;


procedure TGTer_ArranqueParada.sim_FinCronicaPrintEstadoFinal(var fsal: textfile);
begin
  writeln(fsal, Nombre + '.X_NMaquinasDespachadas = ' + IntToStr(
    X_NMaquinasDespachadas));
  writeln(fsal, Nombre + '.X_HorasHisteresisAP = ' + FloatToStr(X_HorasHisteresisAP));
  writeln(fsal, Nombre + '.FechaCambioEstado_ini = ' + FechaCambioEstado_ini.AsISOStr());
end;


class function TGTer_ArranqueParada.TipoFichaLPD: TClaseDeFichaLPD;
begin
  Result := TFichaGTer_ArranqueParada;
end;

constructor TGTer_ArranqueParada.Create(capa: integer; nombre: string;
  nacimiento, muerte: TFecha; lpdUnidades, lpd: TFichasLPD; nodo: TNodo;
  flg_CalcularGradienteDeInversion: boolean; encendidoAlInicio: boolean;
  xFechaCambioEstado_ini: TFecha; TonCO2xMWh: NReal;
  LowCostMustRun, CleanDevelopmentMechanism: boolean;
  xFuenteIdxP: TFuenteAleatoria; xBorneIdxP: string );
begin
  inherited Create(capa, nombre, nacimiento, muerte, lpdUnidades, lpd, nodo,
    flg_CalcularGradienteDeInversion,
    TonCO2xMWh, LowCostMustRun, CleanDevelopmentMechanism,
    xFuenteIdxP, xBorneIdxP );
  self.encendidoAlInicio := encendidoAlInicio;
  FechaCambioEstado_ini := xFechaCambioEstado_ini;
end;

function TGTer_ArranqueParada.Rec: TCosa_RecLnk;
begin
  Result:=inherited Rec;
  Result.addCampoDef('encendidoAlInicio', encendidoAlInicio);
  Result.addCampoDef('FechaCambioEstado_ini', self.FechaCambioEstado_ini, 51 )

end;

procedure TGTer_ArranqueParada.BeforeRead(version, id_hilo: integer);
begin
  inherited BeforeRead(version, id_hilo);
end;

procedure TGTer_ArranqueParada.AfterRead(f:TArchiTexto);
begin
  inherited AfterRead(f);
  if f.version < 51 then
    FechaCambioEstado_ini := TFecha.Create_Dt(0);
  pa := nil;
  nodo := nil;
end;


procedure TGTer_ArranqueParada.PrepararMemoria(Catalogo: TCatalogoReferencias;
  globs: TGlobs);
begin
  inherited prepararMemoria(Catalogo, globs);
end;

procedure TGTer_ArranqueParada.RegistrarParametrosDinamicos(
  CatalogoReferencias: TCatalogoReferencias);
var
  i: integer;
  ficha: TFichaGTer_ArranqueParada;
begin
  inherited registrarParametrosDinamicos(CatalogoReferencias);
  lpd.expandirFichas(CatalogoReferencias, globs);
  lpd.RegistrarFichasAActualizar(Self, globs.ActualizadorLPD, @pA, nil);
  for i := 0 to lpd.Count - 1 do
  begin
    ficha := TFichaGTer_ArranqueParada(lpd[i]);
    if ficha.indicePreciosPorCombustible <> nil then
      ficha.nroBornePreciosPorCombustible :=
        ficha.indicePreciosPorCombustible.IdBorne(ficha.bornePreciosPorCombustible);
  end;
end;

function TGTer_ArranqueParada.PotenciaFirme: NReal;
begin
  Result := (paUnidades.nUnidades_Operativas[0]) * pa.PMax * pa.disp;
end;

function TGTer_ArranqueParada.InfoAd_: string;
begin
  Result := '';
end;

class function TGTer_ArranqueParada.DescClase: string;
begin
  Result := rsGeneradorTermicoConCostoArranqueParada;
end;

procedure TGTer_ArranqueParada.PosicionarseEnEstrellita;
begin
  Self.X_NMaquinasDespachadas := globs.CF.xd[ixd];
end;

procedure TGTer_ArranqueParada.ActualizarEstadoGlobal(flg_Xs: boolean);
begin
  globs.CF.xd[ixd] := Self.X_NMaquinasDespachadas;
end;

procedure TGTer_ArranqueParada.Sim_Cronica_Inicio;
var
  horasUltimoCambioEstado: integer;

begin
  inherited Sim_Cronica_Inicio;
  if encendidoAlInicio then
    X_NMaquinasDespachadas := 1
  else
    X_NMaquinasDespachadas := 0;

  horasUltimoCambioEstado := self.FechaCambioEstado_ini.HorasHasta(globs.fechaIniSim);
  if X_NMaquinasDespachadas > 0 then
    X_HorasHisteresisAP := max(0, pa.MinHorasON - horasUltimoCambioEstado)
  else
    X_HorasHisteresisAP := max(0, pa.MinHorasOFF - horasUltimoCambioEstado);
  // aquí habria  que cargar del Actor el valor
end;


function TGTer_ArranqueParada.get_pa_FD(kTipoUnidad: integer): NReal;
begin
  Result := pa.disp;
end;

function TGTer_ArranqueParada.get_pa_TMR(kTipoUnidad: integer): NReal;
begin
  Result := pa.tRepHoras;
end;


procedure TGTer_ArranqueParada.SorteosDelPaso(sortear: boolean);
begin
{$IFDEF PROBANDO_OPTROT}
  Romperse := False;
{$ENDIF}
  if hayForzamientos or globs.ObligarDisponibilidad_1_ then
  begin
    NMaquinasDisponibles_ := paUnidades.nUnidades_Operativas[0];
    PMaxDisponible := pa.PMax * NMaquinasDisponibles_;
  end
  else if sortear then
  begin
    ActualizarProbabilidadesReparacionYRotura_(pa.disp, pa.tRepHoras);
    NMaquinasDisponibles_ := Sorteos_RepRotUnidades;
    PMaxDisponible := pa.PMax * NMaquinasDisponibles_;
{$IFDEF PROBANDO_OPTROT}
    if globs.EstadoDeLaSala = CES_OPTIMIZANDO then
      Romperse := SorteadorUniforme.rnd < self.unidades_RotRep[0].pRot;
{$ENDIF}
  end
  else
  begin
    NMaquinasDisponibles_ := paUnidades.nUnidades_Operativas[0];
    PMaxDisponible := pa.PMax * pa.disp * NMaquinasDisponibles_;
  end;
end;


function TGTer_ArranqueParada.NMaquinasDisponibles_x: integer;
begin
{$IFDEF PROBANDO_OPTROT}
  if (globs.EstadoDeLaSala = CES_OPTIMIZANDO) and
    (self.X_NMaquinasDespachadas > 0) then
    if Romperse then
      Result := 0
    else
      Result := 1
  else
{$ENDIF}
    Result := self.NMaquinasDisponibles_;
end;

{$IFDEF BOSTA}
procedure TGTer_ArranqueParada.AfterInstantiation;
begin
  inherited AfterInstantiation;
  pa := nil;
  nodo := nil;
end;
{$ENDIF}

procedure TGTer_ArranqueParada.PrepararPaso_ps;
var
  indice: NReal;
begin
  PMin := pa.PMIn;

  PxMax := pa.PMax - pa.PMin;
  if pa.indicePreciosPorCombustible <> nil then
  begin
    indice := pa.indicePreciosPorCombustible.bornera[pa.nroBornePreciosPorCombustible];
    c0 := pa.PMin * (pa.cv_min * indice + pa.cv_NoCombustible);
    cv := pa.cv * indice + pa.cv_NoCombustible;
    cve := pa.PagoPorEnergia_USD_MWh * indice;
  end
  else
  begin
    c0 := pa.PMin * (pa.cv_min + pa.cv_NoCombustible);
    cv := pa.cv + pa.cv_NoCombustible;
    cve := pa.PagoPorEnergia_USD_MWh;
  end;

  if X_NMaquinasDespachadas = 0 then // estaba apagada
  begin
    dCF := globs.CF.deltaCosto_vxd_continuo(ixd, globs.kPaso_Opt + 1, 1) * globs.fActPaso;
  end
  else // estaba prendida
  begin
    dCF := globs.CF.deltaCosto_vxd_continuo(ixd, globs.kPaso_Opt + 1, -1) *
      globs.fActPaso;
  end;

  // si está habilitado el control de histéresis sumo a dCF la penalidad para
  // que le cueste tomar la desición.
  if (globs.EstadoDeLaSala = CES_SIMULANDO) and (x_HorasHisteresisAP > 0) then
    dCF := dCF + pa.PenalidadONOFF;

end;

procedure TGTer_ArranqueParada.Sim_Paso_Fin;
var
  iposte: integer;
begin
  potMedia_despachada := 0;
  for iposte := 0 to high(P) do
    potMedia_despachada := potMedia_despachada + P[iposte] * globs.durpos[iposte];
  potMedia_despachada := potMedia_despachada * globs.invHorasDelPaso;
end;

procedure TGTer_ArranqueParada.opt_nvers(var ivar, ivae, ires: integer);
begin
  if NMaquinasDisponibles_x = 0 then
    exit;
  Self.ivar := ivar;
  ivar := ivar + globs.NPostes + 1; //Potencias y A
  Self.ivae := ivae;
  ivae := ivae + 1;                 //A
  Self.ires := ires;
  ires := ires + globs.NPostes;     //Restricciones de minimos técnicos
  if pA.HayRestriccionEmaxPasoDeTiempo then
    Inc(ires);
end;

procedure TGTer_ArranqueParada.optx_nvxs(var ixr, ixd, iauxNReal, iauxInt: integer);
begin
  Self.ixd := ixd;
  ixd := ixd + 1;
end;

procedure TGTer_ArranqueParada.optx_RegistrarVariablesDeEstado(
  adminEstados: TAdminEstados);
begin
  adminEstados.Registrar_Discreta(ixd, 2, Self.Nombre + '_A', 'bool');
end;

procedure TGTer_ArranqueParada.opt_cargue(s: TSimplex);
var
  inodores: integer;
  iposte: integer;
  jres: integer;
begin

  if NMaquinasDisponibles_x = 0 then
    exit; // si no hay máquinas no juego

  inodores := nodo.ires;
  // CON MINIMOS TECNICOS
  // aporte a las restricciones de nodo

  for iposte := 0 to globs.NPostes - 1 do
  begin
    s.pon_e(inodores + iposte, ivar + iposte, 1); // coeficiente de la B[iposte]
    s.pon_e(inodores + iposte, ivar + globs.NPostes, Pmin); // coef A
  end;

  jres := ires;
  // restricciones adicionales impuestas por la variable de Acople
  for iposte := 0 to globs.NPostes - 1 do
  begin
    s.pon_e(jres, ivar + iposte, -1); // coef B[iposte]
    s.pon_e(jres, ivar + globs.NPostes, PxMax);
    Inc(jres);
  end;

  //Restriccion a la energía máxima generable en un paso
  if pA.HayRestriccionEmaxPasoDeTiempo then
  begin
    for iposte := 0 to globs.NPostes - 1 do
      s.pon_e(jres, ivar + iposte, -globs.durpos[iposte]);
    s.pon_e(jres, ivar + globs.NPostes, -pa.PMin * globs.HorasDelPaso);
    s.pon_e(jres, s.nc, pa.EmaxPasoDeTiempo);
  end;

  // aportes a la función de utilidad
  for iposte := 0 to globs.NPostes - 1 do
    s.pon_e(s.nf, ivar + iposte, -cv * globs.DurPos[iposte]);
  s.pon_e(s.nf, ivar + globs.NPostes, -c0 * globs.HorasDelPaso);

  // controlamos el uso correcto del modelo.
  if NMaquinasDisponibles_ > 1 then
    raise Exception.Create(
      'Por ahora TGer_ArranqueParada soporta solamente centrales de una sóla máquina');

  // agregar costos de Arranque o Parda según corresponda
  if X_NMaquinasDespachadas = 0 then // estaba apagada
  begin
    s.acum_e(s.nf, ivar + globs.NPostes, -(pa.costo_Arranque + dCF));
  end
  else // estaba prendida
  begin
    s.acum_e(s.nf, ivar + globs.NPostes, (pa.costo_Parada + dCF));
    s.acum_e(s.nf, s.nc, -(pa.costo_Parada + dCF));
  end;
end;

procedure TGTer_ArranqueParada.opt_fijarRestriccionesDeCaja(s: TSimplex);
var
  acoples: TListaAcoplesVEntera;
  iposte: integer;
  nmaquinas: integer;
begin
  nmaquinas := NMaquinasDisponibles_x;
  if nmaquinas = 0 then
    exit;
  // Restricciones de caja de las A y las declaramos enteras
  setLength(acoples, globs.NPostes);
  for iposte := 0 to globs.NPostes - 1 do
  begin
    acoples[iposte].ivar := ivar + iposte;
    acoples[iposte].ires := ires + iposte;
  end;
  s.set_EnteraConAcoples(ivae, ivar + globs.NPostes, nmaquinas, acoples);


  if (not hayForzamientos) then
  begin
  (*
    // Restricciones de caja de las B (Esto no es necesario pues las restricciones adicionales
    // obligan que estas se cumplan. Por eso le pongo el 1.1 para dejarle la caja un poco floja
    for iposte:= 0 to globs.NPostes-1 do
      s.cota_sup_set( ivar+iposte, PxMax*NMaquinasDisponibles*1.1 );
  *)
  end
  else
  begin
    for iposte := 0 to globs.NPostes - 1 do
      s.FijarVariable(ivar + iposte, paForzamiento.P[0] - pa.Pmin);

    s.FijarVariable(ivar + globs.NPostes, nmaquinas);
  end;

end;

procedure TGTer_ArranqueParada.opt_leerSolucion(s: TSimplex);
var
  iposte: integer;
  EnergiaPorEncimaDelMinimo: NReal;
  m: NReal;
  EnergiaDespachada: NReal;

begin
  Ingreso_PorDisponibilidad_ :=
    PMaxDisponible * pa.PagoPorDisponibilidad_USD_MWh * globs.HorasDelPaso;
  CostoDirectoDelPaso := 0;
  Ingreso_PorEnergia_ := 0;
  EnergiaPorEncimaDelMinimo := 0;

  if NMaquinasDisponibles_x = 0 then
  begin
    vclear(P);
    //vclear( cv_Spot );
    for iposte := 0 to globs.NPostes - 1 do
    begin
      Lambda_P[iPoste]:= 0;
      cv_Spot[iPoste]:=get_cv_falla; // para que en el ordenamiento quede último, con costo variable igual a la falla;
    end;
    Xs_NMaquinasDespachadas := 0;
  end
  else
  begin
    Xs_NMaquinasDespachadas := trunc(s.xval(ivar + globs.NPostes) + 0.2);
    for iposte := 0 to globs.NPostes - 1 do
    begin
      m := s.xval(ivar + iposte);
      P[iposte] := m + Xs_NMaquinasDespachadas * Pmin;
      Lambda_P[iPoste]:= s.xmult( ires + iposte ) / globs.DurPos[iPoste];
      cv_Spot[iPoste]:= Nodo.cmarg[iposte] - Lambda_P[iPoste];
      EnergiaPorEncimaDelMinimo := EnergiaPorEncimaDelMinimo + m * globs.DurPos[iposte];
    end;
    if Xs_NMaquinasDespachadas > 0 then
    begin
      CostoDirectoDelPaso := CostoDirectoDelPaso + EnergiaPorEncimaDelMinimo *
        cv + Xs_NMaquinasDespachadas * c0 * globs.HorasDelPaso;
      EnergiaDespachada := EnergiaPorEncimaDelMinimo + Xs_NMaquinasDespachadas * pa.PMin;
      Ingreso_PorEnergia_ := EnergiaDespachada * cve * globs.HorasDelPaso;
    end;
  end;

  if Xs_NMaquinasDespachadas > X_NMaquinasDespachadas then
  begin // prendió máquinas
    CostoDirectoDelPaso := CostoDirectoDelPaso +
      (Xs_NMaquinasDespachadas - X_NMaquinasDespachadas) * pa.costo_arranque;
    Xs_HorasHisterisisAP := pa.MinHorasON;
  end
  else if Xs_NMaquinasDespachadas < X_NMaquinasDespachadas then
  begin // apagó máquinas
    CostoDirectoDelPaso := CostoDirectoDelPaso +
      (X_NMaquinasDespachadas - Xs_NMaquinasDespachadas) * pa.costo_parada;
    Xs_HorasHisterisisAP := pa.MinHorasOFF;
  end
  else
  begin
    Xs_HorasHisterisisAP := max(X_HorasHisteresisAP - globs.HorasDelPaso, 0);
  end;

end;



procedure TGTer_ArranqueParada.EvolucionarEstado;
begin
  X_NMaquinasDespachadas := Xs_NMaquinasDespachadas;
  X_HorasHisteresisAP := Xs_HorasHisterisisAP;
end;


function TGTer_ArranqueParada.getNombreVar(ivar: integer; var nombre: string): boolean;
begin
  if NMaquinasDisponibles_x = 0 then
    Result := False
  else
  if (ivar >= self.ivar) and (ivar < self.ivar + globs.NPostes) then
  begin
    nombre := self.Nombre + '_P[MW]' + IntToStr(ivar - self.ivar + 1);
    Result := True;
  end
  else if (ivar = self.ivar + globs.NPostes) then
  begin
    nombre := self.Nombre + '_A[MW]';
    Result := True;
  end
  else
    Result := False;
end;

function TGTer_ArranqueParada.getNombreRes(ires: integer; var nombre: string): boolean;
begin
  if NMaquinasDisponibles_x = 0 then
    Result := False
  else
  if (ires >= self.ires) and (ires < self.ires + globs.NPostes) then
  begin
    nombre := self.nombre + '_res-A' + IntToStr(ires - self.ires + 1);
    Result := True;
  end
  else if pa.HayRestriccionEmaxPasoDeTiempo and (ires = self.ires + globs.NPostes) then
  begin
    nombre := self.nombre + '_res-EMax';
    Result := True;
  end
  else
    Result := False;
end;

procedure TGTer_ArranqueParada.PubliVars;
begin
  inherited PubliVars;
  PublicarVariableNR('Costo', '[USD]', 6, 1, costoDirectoDelPaso, True);
  PublicarVariableNI('NMaqsDespachadas', '-', X_NMaquinasDespachadas, True);
  PublicarVariableNR('dCF', '[USD]', 6, 1, dCF, True);
  PublicarVariableNR('c0', '[USD/h]', 6, 1, c0, False);
  PublicarVariableNI('NMaqsDisponibles', '-', NMaquinasDisponibles_, False);
  PublicarVariableNR('PMaxDisponible', '[MW]', 6, 1, PMaxDisponible, False);
  PublicarVariableNR('PMediaDespachada', '[MW]', 6, 1, potMedia_despachada, False);
end;

procedure TGTer_ArranqueParada.Free;
begin
  inherited Free;
end;

procedure AlInicio;
begin
  registrarClaseDeCosa(TGTer_ArranqueParada.ClassName, TGTer_ArranqueParada);
  registrarClaseDeCosa(TFichaGTer_ArranqueParada.ClassName, TFichaGTer_ArranqueParada);
end;

procedure AlFinal;
begin

end;

end.
