//====Modificado metodos: CreateDataColumnList y CreateDataConversionList===
//====Micho@28/5==mvarela@adme.com.uy=======================================
unit ugter_basicodostramos;

(*
   ugter_basicodostramos es un generador que trabaja en el tramo 1 desde cero a
   Ptr con costo variable cv1 y en el tramo 2 desde Ptr hasta Pmax con un costo
   variable cv2.
*)
// v1 Marcelo Forets, 26/07/2011
// se impone nmax = 1

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
  Math,
  SysUtils, Classes, xmatdefs, uGTer, uNodos,
  uglobs,
  usimplex,
  umipsimplex,
  ufichasLPD,
  ufechas,
  ucosa, uranddispos,
  uconstantesSimSEE,
  uFuentesAleatorias;

resourcestring
  rsGeneradorTermicoBasicoDosTramos = 'Generador térmico básico de dos tramos';

type

  { TFichaGTer_BasicoDosTramos }

  TFichaGTer_BasicoDosTramos = class(TFichaLPD)

  public

    (**************************************************************************)
    (*               A T R I B U T O S   P E R S I S T E N T E S              *)
    (**************************************************************************)

    PMax: NReal; // [MW] Potencia Máxima Por maquina (tramo2)
    PTr: Nreal;  // [MW] Potencia de transición, tramo1-> tramo2
    cv1, cv2: NReal;
    // Costo:= cv1*P si estoy en tramo1 y Costo:= cv1*Ptr+cv2*(P-Ptr) si estoy en tramo 2
    indicePreciosPorCombustible: TFuenteAleatoria;
    bornePreciosPorCombustible: string;
    disp: NReal; // disponibilidad (fortuita)
    tRepHoras: NReal;
    HayRestriccionEmaxPasoDeTiempo: boolean; // indica si se aplica la restricción
    EmaxPasoDeTiempo: NReal; // Energía maxima generable en un paso de tiempo

    (**************************************************************************)

    nroBornePreciosPorCombustible: integer;

    constructor Create(fecha: TFecha; periodicidad: TPeriodicidad;
      Ptr, PMax: NReal; cv1, cv2: NReal;
      indicePreciosPorCombustible: TFuenteAleatoria;
      bornePreciosPorCombustible: string;
      disp: NReal; tRepHoras: NReal;
      HayRestriccionEmaxPasoDeTiempo: boolean;
      EmaxPasoDeTiempo: NReal);
     
    constructor Create_ReadFromText(f: TArchiTexto); override;
    procedure WriteToText(f: TArchiTexto); override;
    
    procedure generarLineaResumen(var archi: TextFile); override;
    function infoAd: string; override;
    procedure Free; override;

    class function CreateDataColumnList(xVersion: Integer=-2): TDataColumnListOfCosa; override;

published
    












  end;
  //------------------------------------------------------------------------

  { TGTer_BasicoDosTramos }

  TGTer_BasicoDosTramos = class(TGTer)
  public
    pa: TFichaGTer_BasicoDosTramos;

    NMaquinasDespachadas: longint;
    // cantidad de máquinas despachadas por poste o por paso ( Acople )
    costosPorPoste: TDAofNReal;
    maxNMaquinasDespachadas: integer; // máximo del vector anterior
    cv1: NReal; // USD/MWh usado para la optimización del paso.
    cv2: NReal; // USD/MWh usado para la optimización del paso.
    cve: NReal; // costo por la energía adicional a CV
    PMax: NReal;
    Ptr: NReal; //MW

    // resultado de los sorteos de disponibilidad y del mantenimiento programado
    NMaquinasDisponibles: integer;
    PMaxDisponible: NReal;

    //Cuanta potencia despacho en cada hora el generador en promedio
    potMedia_despachada: NReal;

    constructor Create(nombre: string;
      nacimiento, muerte: TFecha; lpdUnidades, lpd: TFichasLPD;
      nodo: TNodo); override;

     
    constructor Create_ReadFromText(f: TArchiTexto); override;
    procedure WriteToText(f: TArchiTexto); override;
    
    procedure PrepararMemoria(globs: TGlobs); override;
    procedure RegistrarParametrosDinamicos; override;

    function PotenciaFirme: NReal; override;

    function InfoAd: string; override;
    class function DescClase: string; override;

    procedure SorteosDelPaso(sortear: boolean); override;
    procedure prepararPaso_ps; override;
    procedure Sim_Paso_Fin; override;

    procedure opt_nvers(var ivar, ivae, ires: integer); override;

    procedure opt_cargue(s: TSimplex); override;
    procedure opt_fijarRestriccionesDeCaja(s: TSimplex); override;
    procedure opt_leerSolucion(s: TSimplex); override;


  {$IFDEF SPXCONLOG}
    procedure spx_NombrarVariables(s: TSimplex); override;
  {$ENDIF}
    function getNombreVar(ivar: integer; var nombre: string): boolean; override;
    function getNombreRes(ires: integer; var nombre: string): boolean; override;

    procedure Free; override;

    procedure PubliVars; override;
    procedure dump_Variables(var f: TextFile; charIndentacion: char); override;

    class function TipoFichaLPD: TClaseDeFichaLPD; override;

    procedure AfterInstantiation; override;

  end;


procedure AlInicio;
procedure AlFinal;

implementation

uses uActores;

//------------------------------
// Métodos de TFichaGTer_BasicoDosTramos
//==============================
constructor TFichaGTer_BasicoDosTramos.Create(fecha: TFecha;
  periodicidad: TPeriodicidad; Ptr, PMax: NReal;
  cv1, cv2: NReal;
  indicePreciosPorCombustible: TFuenteAleatoria;
  bornePreciosPorCombustible: string;
  disp: NReal; tRepHoras: NReal;
  HayRestriccionEmaxPasoDeTiempo: boolean;
  EmaxPasoDeTiempo: NReal);
begin
  inherited Create(fecha, periodicidad);
  self.PMax := PMax;
  self.PTr := PTr;
  self.cv1 := cv1;
  self.cv2 := cv2;
  self.indicePreciosPorCombustible := indicePreciosPorCombustible;
  self.disp := disp;
  self.tRepHoras := tRepHoras;
  self.HayRestriccionEmaxPasoDeTiempo := HayRestriccionEmaxPasoDeTiempo;
  self.EmaxPasoDeTiempo := EmaxPasoDeTiempo;
  self.bornePreciosPorCombustible := bornePreciosPorCombustible;

end;

 
constructor TFichaGTer_BasicoDosTramos.Create_ReadFromText(f: TArchiTexto);
begin

  inherited Create_ReadFromText(f);
  f.IniciarLecturaRetrasada;
  f.rd('PTr', PTr);
  f.rd('PMax', PMax);
  f.rd('cv1', cv1);
  f.rd('cv2', cv2);
  f.rdReferencia('indicePreciosPorCombustible',
    TCosa(indicePreciosPorCombustible), self);
  f.rd('bornePreciosPorCombustible', bornePreciosPorCombustible);
  f.rd('disp', disp);
  f.rd('tRepHoras', tRepHoras);
  f.rd('HayRestriccionEmaxPasoDeTiempo', HayRestriccionEmaxPasoDeTiempo);
  f.rd('EmaxPasoDeTiempo', EmaxPasoDeTiempo);
  //f.rd('PagoPorPotencia', PagoPorPotencia);
  //f.rd('PagoPorEnergia', PagoPorEnergia);
  f.EjecutarLectura;
end;


procedure TFichaGTer_BasicoDosTramos.WriteToText(f: TArchiTexto);
begin
  inherited WriteToText(f);
  f.wr('PMax', PMax, uconstantesSimSEE.CF_PRECISION, uconstantesSimSEE.CF_DECIMALES);
  f.wr('PTr', PTr, uconstantesSimSEE.CF_PRECISION, uconstantesSimSEE.CF_DECIMALES);
  f.wr('cv1', cv1, uconstantesSimSEE.CF_PRECISION, uconstantesSimSEE.CF_DECIMALES);
  f.wr('cv2', cv2, uconstantesSimSEE.CF_PRECISION, uconstantesSimSEE.CF_DECIMALES);
  f.wrReferencia('indicePreciosPorCombustible', indicePreciosPorCombustible);
  f.wr('bornePreciosPorCombustible', bornePreciosPorCombustible);
  f.wr('disp', disp, uconstantesSimSEE.CF_PRECISION, uconstantesSimSEE.CF_DECIMALESPU);
  f.wr('tRepHoras', tRepHoras, uconstantesSimSEE.CF_PRECISION,
    uconstantesSimSEE.CF_DECIMALESPU);
  f.wr('HayRestriccionEmaxPasoDeTiempo', HayRestriccionEmaxPasoDeTiempo);
  f.wr('EmaxPasoDeTiempo', EmaxPasoDeTiempo);
  //f.wr('PagoPorPotencia', PagoPorPotencia);
  //f.wr('PagoPorEnergia', PagoPorEnergia);
end;


procedure TFichaGTer_BasicoDosTramos.generarLineaResumen(var archi: TextFile);
begin
  Write(archi, FloatToStrF(Ptr, formatoReales, 8, 1), #9,
    //PMín
    FloatToStrF(PMax, formatoReales, 8, 1), #9,
    //PMáx
    FloatToStrF(cv1, formatoReales, 8, 2), #9,
    //CV_Mín
    //FloatToStrF(((cv_min * PMin + cv * (PMax - PMin)) / PMax), formatoReales, 8, 2), #9,    //CV_Medio
    FloatToStrF(cv2, formatoReales, 8, 2), #9,
    //CV_Incremental
    FloatToStrF(disp, formatoReales, 8, 2), #9,
    //FDisp
    '-', #9,
    //Costo Arranque
    '-', #9,
    //Costo Parada
    '-', #9,
    //mínNPasosOn
    '-', #9,
    //mínNPasosOff
    '-', #9,
    //desiciónPasosOnPorCiclo
    '-', #9,
    //desiciónPasosOffPorCiclo
    '-', #9,
    //costoPorCicloOn
    '-', #9);
  //costoPorCicloOff
end;

function TFichaGTer_BasicoDosTramos.infoAd: string;
begin
  Result := 'PMax= ' + FloatToStrF(PMax, ffGeneral, 10, 1) + ' MW, ' +
    'PTr= ' + FloatToStrF(PTr, ffGeneral, 10, 1) + ' MW, ' + 'cv1= ' +
    FloatToStrF(cv1, ffGeneral, 10, 1) + ' USD/MWh, ' + 'cv2= ' +
    FloatToStrF(cv2, ffGeneral, 10, 1) + ' USD/MWh, ' + 'fdisp= ' +
    FloatToStrF(disp, ffGeneral, 10, 2) + ' p.u., ' + 'tRep= ' +
    FloatToStrF(tRepHoras, ffGeneral, 10, 1) + 'h';
end;

procedure TFichaGTer_BasicoDosTramos.Free;
begin
  inherited Free;
end;

class function TFichaGTer_BasicoDosTramos.CreateDataColumnList(xVersion: Integer
  ): TDataColumnListOfCosa;
begin
  












end;



//------------------------
// Métodos de TGTer_BasicoDosTramos
//========================
procedure TGTer_BasicoDosTramos.dump_Variables(var f: TextFile; charIndentacion: char);
begin
  inherited dump_Variables(f, charIndentacion);
  writeln(f, charIndentacion, 'cv1[USD/MWh]= ', FloatToStrF(cv1, ffFixed, 10, 3));
  writeln(f, charIndentacion, 'cv2[USD/MWh]= ', FloatToStrF(cv2, ffFixed, 10, 3));

  writeln(f, charIndentacion, 'PMax[MW]= ', FloatToStrF(pa.PMax, ffFixed, 10, 3));
  writeln(f, charIndentacion, 'Ptr[MW]= ', FloatToStrF(Ptr, ffFixed, 10, 3));
  writeln(f, charIndentacion, 'PMaxDisponible[MW]= ',
    FloatToStrF(PMaxDisponible, ffFixed, 10, 3));

  writeln(f, charIndentacion, 'NMaquinasDisponibles= ', NMaquinasDisponibles);

  writeln(f, charIndentacion, 'HayRestrEMaxPasoDeTiempo= ',
    pa.hayRestriccionEmaxPasoDeTiempo);
  writeln(f, charIndentacion, 'EMaxPasoDeTiempo[MW/h]= ',
    FloatToStrF(pa.EmaxPasoDeTiempo, ffFixed, 10, 3));

  writeln(f);
end;

class function TGTer_BasicoDosTramos.TipoFichaLPD: TClaseDeFichaLPD;
begin
  Result := TFichaGTer_BasicoDosTramos;
end;

procedure TGTer_BasicoDosTramos.AfterInstantiation;
begin
  inherited AfterInstantiation;
  pa := nil;
  nodo := nil;
end;

constructor TGTer_BasicoDosTramos.Create(nombre: string;
  nacimiento, muerte: TFecha; lpdUnidades, lpd: TFichasLPD; nodo: TNodo);
begin
  inherited Create(nombre, nacimiento, muerte, lpdUnidades, lpd, nodo);
end;

 
constructor TGTer_BasicoDosTramos.Create_ReadFromText(f: TArchiTexto);
begin
  inherited Create_ReadFromText(f);
  pa := nil;
  nodo := nil;
end;

procedure TGTer_BasicoDosTramos.WriteToText(f: TArchiTexto);
begin
  inherited WriteToText(f);
end;


procedure TGTer_BasicoDosTramos.PrepararMemoria(globs: TGlobs);
begin
  inherited prepararMemoria(globs);
  setlength(costosPorPoste, globs.NPostes);
  NMaquinasDespachadas := 0;
end;

procedure TGTer_BasicoDosTramos.RegistrarParametrosDinamicos;
var
  i: integer;
  ficha: TFichaGTer_BasicoDosTramos;
begin
  inherited registrarParametrosDinamicos;
  lpd.expandirFichas(globs);
  lpd.RegistrarFichasAActualizar(Self, globs.ActualizadorLPD, @pA, nil);
  for i := 0 to lpd.Count - 1 do
  begin
    ficha := TFichaGTer_BasicoDosTramos(lpd[i]);
    if ficha.indicePreciosPorCombustible <> nil then
      ficha.nroBornePreciosPorCombustible :=
        ficha.indicePreciosPorCombustible.IdBorne(ficha.bornePreciosPorCombustible);
  end;
end;

function TGTer_BasicoDosTramos.PotenciaFirme: NReal;
begin
  Result := (paUnidades.nUnidades) * pa.PMax * pa.disp;
end;

function TGTer_BasicoDosTramos.InfoAd: string;
begin
  Result := '';
end;

class function TGTer_BasicoDosTramos.DescClase: string;
begin
  Result := rsGeneradorTermicoBasicoDosTramos;
end;


procedure TGTer_BasicoDosTramos.SorteosDelPaso(sortear: boolean);
begin
  if globs.ObligarDisponibilidad_1_ then
  begin
    NMaquinasDisponibles := paUnidades.nUnidades;
    PMaxDisponible := pa.PMax * NMaquinasDisponibles;
  end
  else if sortear then
  begin
    ActualizarProbabilidadesReparacionYRotura(pa.disp, pa.tRepHoras);
    NMaquinasDisponibles := Sorteos_RepRotUnidades;
    PMaxDisponible := pa.PMax * NMaquinasDisponibles;
  end
  else
  begin
    NMaquinasDisponibles := paUnidades.nUnidades;
    PMaxDisponible := pa.PMax * pa.disp * NMaquinasDisponibles;
  end;
end;

procedure TGTer_BasicoDosTramos.prepararPaso_ps;
var
  indice: NReal;
begin
  PTr := pa.Ptr;
  Pmax := pa.Pmax;

  if pa.indicePreciosPorCombustible <> nil then
  begin
    indice := pa.indicePreciosPorCombustible.bornera[pa.nroBornePreciosPorCombustible];
    cv1 := pa.cv1 * indice;
    cv2 := pa.cv2 * indice;
    //cve:= pa.PagoPorEnergia * pa.indicePreciosPorCombustible.bornera[pa.nroBornePreciosPorCombustible];
  end
  else
  begin
    cv1 := pa.cv1;
    cv2 := pa.cv2;
    //cve:= pa.PagoPorEnergia;
  end;
end;

procedure TGTer_BasicoDosTramos.Sim_Paso_Fin;
var
  iposte: integer;
begin
  if NMaquinasDisponibles > 0 then
  begin
    for iposte := 0 to high(P) do
      potMedia_despachada := potMedia_despachada + P[iposte] * globs.durpos[iposte];
    potMedia_despachada := potMedia_despachada * globs.invHorasDelPaso;
  end
  else
  begin
    potMedia_despachada := 0;
  end;
end;

//dimensionar el simplex
procedure TGTer_BasicoDosTramos.opt_nvers(var ivar, ivae, ires: integer);
begin
  if NMaquinasDisponibles = 0 then
    exit;
  Self.ivar := ivar;
  ivar := ivar + globs.NPostes * 3;
  //variables de optimización B1, B2 (reales) y A = (0,1) que selecciona tramo
  Self.ivae := ivae;
  ivae := ivae + globs.NPostes;  //A=0 (tramo1) y A=1 (tramo2)
  Self.ires := ires;
  ires := ires + 2 * globs.NPostes;
  //2 restricciones adicionales por poste por cada variable, B1 y B2
  if pA.HayRestriccionEmaxPasoDeTiempo then
    Inc(ires);
end;

//cargar el simplex
procedure TGTer_BasicoDosTramos.opt_cargue(s: TSimplex);
var
  inodores: integer;
  iposte: integer;
  jres: integer;
begin
  if NMaquinasDisponibles = 0 then
    exit; // si no hay máquinas no juego
{$IFDEF SPXCONLOG}
  spx_NombrarVariables(s);
{$ENDIF}
  inodores := nodo.ires;
  // aporte a las restricciones del nodo. P = (B1) + (Ptr*A+B2)
  for iposte := 0 to globs.NPostes - 1 do
  begin
    s.pon_e(inodores + iposte, ivar + iposte, 1);       // coeficiente de B1
    s.pon_e(inodores + iposte, ivar + iposte + globs.NPostes, 1);  // coeficiente de B2
    s.pon_e(inodores + iposte, ivar + iposte + 2 * globs.NPostes, Ptr);   // coef A
  end;

  // restricciones adicionales impuestas por la variable de Acople
  jres := ires;
  for iposte := 0 to globs.NPostes - 1 do
  begin
    s.pon_e(jres, ivar + iposte, -1); // coef B1: -B1+Ptr(1-A) >= 0
    s.pon_e(jres, ivar + 2 * globs.NPostes + iposte, -Ptr);
    s.pon_e(jres, s.nc, Ptr);

    s.pon_e(jres + globs.NPostes, ivar + iposte + globs.NPostes, -1);
    // coef B2: -B2+(Pmax-Ptr)A >= 0
    s.pon_e(jres + globs.NPostes, ivar + 2 * globs.NPostes + iposte, Pmax - Ptr);

    Inc(jres);
  end;

  //Restriccion a la energía máxima generable en el paso
   (*if pA.HayRestriccionEmaxPasoDeTiempo then
  begin
    for iposte:= 0 to globs.NPostes -1 do
    begin
      s.pon_e(jres, ivar + iposte, -globs.durpos[iposte]);
      s.pon_e(jres, ivar + globs.NPostes + iposte, -globs.durpos[iposte]*pa.Ptr);
    end;
    s.pon_e(jres, s.nc, pa.EmaxPasoDeTiempo);
  end;
*)

  // aportes a la función de utilidad
  for iposte := 0 to globs.NPostes - 1 do
  begin
    s.pon_e(s.nf, ivar + iposte, -cv1 * globs.DurPos[iposte]);
    s.pon_e(s.nf, ivar + globs.NPostes + iposte, -cv2 * globs.DurPos[iposte]);
    s.pon_e(s.nf, ivar + 2 * globs.NPostes + iposte, -cv1 * Ptr * globs.DurPos[iposte]);
  end;
end;

procedure TGTer_BasicoDosTramos.opt_fijarRestriccionesDeCaja(s: TSimplex);
var
  iposte: integer;
begin
  if NMaquinasDisponibles = 0 then
    exit;

  // Restricciones de caja de las B
  for iposte := 0 to globs.NPostes - 1 do
  begin
    s.cota_sup_set(ivar + iposte, Ptr * NMaquinasDisponibles);    //B1<= Ptr
    s.cota_inf_set(ivar + iposte, 0);                    //0 <= B1

    s.cota_sup_set(ivar + iposte + globs.NPostes, (Pmax - Ptr) * NMaquinasDisponibles);
    //B2 <= Pmax-Ptr
    s.cota_inf_set(ivar + iposte + globs.NPostes, 0);
    // 0 <= B2
  end;


  for iposte := 0 to globs.NPostes - 1 do
  begin
    // Restricciones de caja de las A, las declaramos enteras
    TMIPSimplex(s).set_entera(ivae + iposte, ivar + 2 * globs.NPostes + iposte, 1);
    //el "1" es el máximo que puede tomar A
  end;

end;

//lee la solución del simplex y la carga en las variables
procedure TGTer_BasicoDosTramos.opt_leerSolucion(s: TSimplex);
var
  iposte: integer;
  nmaqs: integer;
  B2: NReal;
  A: integer;
  Cptr: NReal;
begin

  CostoDirectoDelPaso := 0;
  maxNMaquinasDespachadas := 0;
  if NMaquinasDisponibles = 0 then
  begin
    vclear(P);
    vclear(costosPorPoste);
    //vclear( NMaquinasDespachadas );
    exit;
  end;


  Cptr := Ptr * cv1;

  for iposte := 0 to globs.NPostes - 1 do
  begin

    A := trunc(0.1 + s.xval(ivar + iposte + 2 * globs.NPostes));

    if (A = 0) then  // A = 0 , estoy en tramo 1
    begin
      //potencia = B1
      P[iposte] := s.xval(ivar + iposte);
      if P[iposte] > GTER_PRECISIONPOTENCIANMAQS then
      begin
        //nmaqs:=Math.Ceil((P[iposte] - GTER_PRECISIONPOTENCIANMAQS) / pa.PMax);
        nmaqs := 1;
        //asumo por ahora que el numero de maquinas es 1
        //NMaquinasDespachadas[iposte]:= nmaqs;
        NMaquinasDespachadas := nmaqs;
        costosPorPoste[iposte] := globs.DurPos[iposte] * P[iposte] * cv1;
        CostoDirectoDelPaso :=
          CostoDirectoDelPaso + costosPorPoste[iposte];

        if nmaqs > maxNMaquinasDespachadas then
          maxNMaquinasDespachadas := nmaqs;
        if NMaquinasDespachadas > 0 then;
          //if NMaquinasDespachadas[iposte] > 0 then
          //else
          //  costosPorPoste[iposte] := 0;

      end
      else
      begin
        NMaquinasDespachadas := 0;
        //NMaquinasDespachadas[iposte]:= 0;
        costosPorPoste[iposte] := 0;
      end;
    end
    else if (A = 1) then // A = 1 estoy en el tramo 2
    begin
      //potencia = Ptr+B2
      B2 := s.xval(ivar + iposte + globs.NPostes);
      //nmaqs:=Math.Ceil((P[iposte] - GTER_PRECISIONPOTENCIANMAQS) / pa.PMax);  //no entiendo
      nmaqs := 1;
      //asumo por ahora que el numero de maquinas es 1
      //NMaquinasDespachadas[iposte]:= nmaqs;
      NMaquinasDespachadas := nmaqs;
      P[iposte] := PTr + B2;
      costosPorPoste[iposte] :=
        (B2 * cv2 + Cptr) * globs.durpos[iposte];
      CostoDirectoDelPaso :=
        CostoDirectoDelPaso + costosPorPoste[iposte];
                        (*
      if nmaqs > maxNMaquinasDespachadas then
        maxNMaquinasDespachadas:= nmaqs;
                        if NMaquinasDespachadas > 0 then
                         if NMaquinasDespachadas[iposte] > 0 then
       else
        costosPorPoste[iposte] := 0;
                                *)
    end;
  end;

end;

{$IFDEF SPXCONLOG}
procedure TGTer_BasicoDosTramos.spx_NombrarVariables(s: TSimplex);
var
  iposte: integer;
begin
  if NMaquinasDisponibles = 0 then
    exit;
  for iposte := 0 to globs.NPostes - 1 do
  begin
    s.set_NombreVar(ivar + iposte, Nombre + '_PB1[MW]' + IntToStr(iposte + 1));
    s.set_NombreVar(ivar + iposte + globs.NPostes, Nombre + '_PB2[MW]' + IntToStr(iposte + 1));
    s.set_NombreVar(ivar + iposte + 2 * globs.NPostes, Nombre + '_A' + IntToStr(iposte + 1));
    s.set_NombreRest(ires + iposte, Nombre + '_res-A' + IntToStr(iposte + 1));    //??
  end;
  //  if pA.HayRestriccionEmaxPasoDeTiempo then
  //   s.set_NombreRest( ires + globs.NPostes, Nombre + '_res-EMax');
end;

{$ENDIF}

function TGTer_BasicoDosTramos.getNombreVar(ivar: integer;
  var nombre: string): boolean;
begin
  if NMaquinasDisponibles = 0 then
    Result := False
  else
  if (ivar >= self.ivar) and (ivar < self.ivar + globs.NPostes) then
  begin
    nombre := self.Nombre + '_PB1[MW]' + IntToStr(ivar - self.ivar + 1);
    Result := True;
  end
  else if (ivar >= self.ivar + globs.NPostes) and
    (ivar < self.ivar + 2 * globs.NPostes) then
  begin
    nombre := self.Nombre + '_PB2[MW]' + IntToStr(ivar - (self.ivar + globs.NPostes) + 1);
    Result := True;
  end
  else if (ivar >= self.ivar + 2 * globs.NPostes) and
    (ivar < self.ivar + 3 * globs.NPostes) then
  begin
    nombre := self.Nombre + '_A' + IntToStr(ivar - (self.ivar + 2 * globs.NPostes) + 1);
    Result := True;
  end
  else
    Result := False;
end;

function TGTer_BasicoDosTramos.getNombreRes(ires: integer;
  var nombre: string): boolean;
begin
  if NMaquinasDisponibles = 0 then
    Result := False
  else
  if (ires >= self.ires) and (ires < self.ires + globs.NPostes) then
  begin
    nombre := self.nombre + '_res-A' + IntToStr(ires - self.ires + 1);
    Result := True;
  end
  else if pa.HayRestriccionEmaxPasoDeTiempo and (ires = self.ires + globs.NPostes) then
  begin
    nombre := self.nombre + '_res-EMax';
    Result := True;
  end
  else
    Result := False;
end;

procedure TGTer_BasicoDosTramos.PubliVars;
begin
  inherited PubliVars;
  PublicarVariableVR('Costo', '[USD]', 6, 1, costosPorPoste, True, False);
  declararVarsPSimResPorDefectoIntercalandoPostes(['P', 'Costo'], globs.NPostes);
  PublicarVariableNI('NMaqsDespachadas', '-', NMaquinasDespachadas, True);
  PublicarVariableNR('cv1', '[USD/h]', 6, 1, cv1, False);
  PublicarVariableNR('cv2', '[USD/h]', 6, 1, cv2, False);

  PublicarVariableNI('NMaqsDisponibles', '-', NMaquinasDisponibles, False);

  PublicarVariableNR('PMaxDisponible', '[MW]', 6, 1, PMaxDisponible, False);
  PublicarVariableNR('PMediaDespachada', '[MW]', 6, 1, potMedia_despachada, False);
end;

procedure TGTer_BasicoDosTramos.Free;
begin

  //Setlength( NMaquinasDespachadas, 0 );
  SetLength(costosPorPoste, 0);
  inherited Free;
end;

procedure AlInicio;
begin
  registrarClaseDeCosa(TGTer_BasicoDosTramos.ClassName, TGTer_BasicoDosTramos);
  registrarClaseDeCosa(TFichaGTer_BasicoDosTramos.ClassName,
    TFichaGTer_BasicoDosTramos);
end;

procedure AlFinal;
begin
end;

end.
