unit uAdministradorDeEstadosMultiPlano;

{$mode delphi}

interface

uses
  Classes, SysUtils, uEstados, uauxiliares, matreal, xmatdefs;

type

  THiperplano = record
    variablesDeEstado,gradiente:TDAofNReal;
    costo:NReal;
  end;

  TDAOfHiperplanos = array of THiperplano;


  TConjuntoDeHiperplanos = record
    dt: TDateTime;
    NHiperplanos:integer;
    hiperPlanos:TDAOfHiperplanos;

  end;

  TDAOfConjuntosDeHiperplanos = array of TConjuntoDeHiperplanos;


  { TAdminEstadosMultiPlano }

  TAdminEstadosMultiPlano = class(TAdminEstados)

    NVariablesDeEstado, NFechas:integer;
    NombesVariables:array of string;
    conjuntosDeHiperPlanos:TDAOfConjuntosDeHiperplanos;

    constructor CreateLoadFromArchi(nombreArchi: string);

  end;




implementation

{ TAdminEstadosMultiPlano }

constructor TAdminEstadosMultiPlano.CreateLoadFromArchi(nombreArchi: string);
var
  archi: TextFile;
  str: string;
  kVariableDeEstado, kFecha,kHiperplano: integer;
  pHiperplano:^THiperplano;
  pConjuntoDeHiperplanos:^TConjuntoDeHiperplanos;
begin

  {

  Ejemplo de archivo:

  NVariables:	3
  NFechas:	2
  NombresVariables:	X1	X2	X3
  CF    X1      X2      X3      dCF/dX1 dCF/X2 dCF/X3
  dt:	43250	NHiperplanos:	1
  250	100	200	300	1000	2000	3000
  dt:	43251	NHiperplanos:	2
  251	101	201	301	1001	2001	3001
  252	102	202	302	1002	2002	3002

  }

  AssignFile(archi, nombreArchi);
  Reset(archi);
  // al principio tengo que leer toda la informacion del encabezado

  ReadLn(archi, str);
  NextPal(str);// 'NVariables:'
  NVariablesDeEstado := NextInt(str);

  ReadLn(archi, str);
  NextPal(str);// 'NFechas:'
  NFechas := NextInt(str);

  ReadLn(archi, str);
  NextPal(str);// 'NombresVariables:'
  SetLength(NombesVariables,NVariablesDeEstado);
  ReadLn(archi, str);// CF X1 X2 X3 dCF/dX1 dCF/X2 dCF/X3

  for kVariableDeEstado:=0 to NVariablesDeEstado - 1 do
    NombesVariables[kVariableDeEstado]:=NextPal(str);

  SetLength(conjuntosDeHiperPlanos,NFechas);

  for kFecha:=0 to NFechas - 1 do
  begin
    pConjuntoDeHiperplanos:=@conjuntosDeHiperPlanos[kFecha];

    ReadLn(archi, str); // encabezado del conjunto (dt: XXXX NPlanos: XXXX)
    NextPal(str);// 'dt:'
    pConjuntoDeHiperplanos.dt:=NextFloat(str);

    NextPal(str);// 'NHiperplanos:'
    pConjuntoDeHiperplanos.NHiperplanos:=NextInt(str);

    SetLength(pConjuntoDeHiperplanos.hiperPlanos,pConjuntoDeHiperplanos.NHiperplanos);

    for kHiperplano := 0 to pConjuntoDeHiperplanos.NHiperplanos - 1 do
    begin
      pHiperplano:=@pConjuntoDeHiperplanos.hiperPlanos[kHiperplano];

      ReadLn(archi, str); // los valores de la variable y el gradiente

      SetLength(pHiperplano.variablesDeEstado,NVariablesDeEstado);
      SetLength(pHiperplano.gradiente,NVariablesDeEstado);

      pHiperplano.costo:=NextFloat(str);

      for kVariableDeEstado:=0 to NVariablesDeEstado - 1 do
        pHiperplano.variablesDeEstado[kVariableDeEstado]:=NextFloat(str);

      for kVariableDeEstado:=0 to NVariablesDeEstado - 1 do
        pHiperplano.gradiente[kVariableDeEstado]:=NextFloat(str);

    end;
  end;

  CloseFile(archi);

end;

end.

