unit ubuscaarchivos;

{$mode delphi}

interface

uses
  Classes, SysUtils;

type
// TBuscaArchivos permite agregar una lista de carpetas en las que buscar
// un archivo.
// La función Locate( archivo ) retorna el camino completo al archivo
// Si no lo encuentra, el resultado es '';
  TBuscaArchivos = class( TStringList )
  public
    dirPrincipal: string;
    constructor Create;
    function Locate( archi: string ): string;
  end;


implementation

constructor TBuscaArchivos.Create;
begin
  dirPrincipal:= '';
end;

function TBuscaArchivos.Locate(archi: string ): string;
var
  buscando: boolean;
  ts, nombre: string;
  k: integer;
begin
  // primero probamos si el archivo tal cual existe;
  if fileexists( archi ) then
  begin
    result:= archi;
    exit;
  end;

  nombre:= ExtractFileName( archi );

  //buscamos en el directorio principal
  ts:= dirPrincipal+ DirectorySeparator + nombre;
  if fileexists(ts) then
  begin
    result:= ts;
    exit;
  end;


  buscando:= true;
  for k:= 0 to count-1 do
  begin
     ts:= Self[k]+ DirectorySeparator + nombre;
     if fileexists( ts ) then
     begin
       buscando:= false;
       break;
     end;
  end;

  if buscando then
  begin
    ts:= GetCurrentDir + DirectorySeparator + nombre;
    if fileexists( ts ) then
      result:= ts
    else
      result:= '';
  end
  else
    result:= ts;

end;

end.

