unit ucasos;

{$mode delphi}
(** Permite definir testo evaluables por un evaluador de expresiones
para luego poder evaluar en la Sala antes de ejcutar. ***)

interface

uses
  Classes, SysUtils, ucosa, uCosaConNombre;

type

  { TCaso }

  TCaso = class(TCosaConNombre)
    Data: string;
    constructor Create(capa: integer; nombre: string; Data: string);
    function Rec: TCosa_RecLnk; override;
  end;

  { TCasos }

  { TCasosLst }

  TCasosLst = class(TListaDeCosasConNombre)
    constructor {%H-}Create;
    // chequea si el caso ya no está en la lista y lo agrega.
    // retorna el puntero al Caso agregado o NIL si ya estaba y no fue agregado.
    function AppendCaso(nombreCaso: string): TCaso;
  end;

procedure AlInicio;
procedure AlFinal;

implementation

{ TCasos }

constructor TCasosLst.Create;
begin
  inherited Create(0, 'Casos');
  AppendCaso('Base');
end;

function TCasosLst.AppendCaso(nombreCaso: string): TCaso;
var
  rec: TCaso;
begin
  if Find(nombreCaso) = nil then
  begin
    rec := TCaso.Create(0, nombreCaso, '');
    add(rec);
    Result := rec;
  end
  else
    Result := nil;
end;


{ TCaso }

constructor TCaso.Create(capa: integer; nombre: string; Data: string);
begin
  inherited Create(capa, nombre);
  self.Data := Data;
end;

function TCaso.Rec: TCosa_RecLnk;
var
  res: TCosa_RecLnk;
begin
  res := inherited Rec;
  res.addCampoDef('data', Data);
  Result := res;
end;

(*********************************)
procedure AlInicio;
begin
  registrarClaseDeCosa(TCaso.ClassName, TCaso);
  registrarClaseDeCosa(TCasosLst.ClassName, TCasosLst);
end;

procedure AlFinal;
begin
end;

end.

