unit usimprint;

{$mode delphi}

interface

uses
  Classes, SysUtils, xmatdefs, ucosa;

type

  { TSimPrint }
  TSimPrint = class
    sala: TCosa;
    id_hilo: integer;
    kCronicaIni, kCronicaFin: integer;
    constructor Create(sala: TCosa; id_hilo, kCronicaIni, kCronicaFin: integer);
    procedure Inicio; virtual;
    procedure EncabezadoDeCronica; virtual;
    procedure ResultadosDelPaso; virtual;
    destructor Destroy; override;

    // auxiliary callback methods
    procedure WriteEncab(s: string); virtual; abstract;
    procedure WriteResultados(s: string); virtual; abstract;
    procedure printEncabezadoResumenSim(nombre, tipo, infoad: string);
      virtual; abstract;
    procedure printResumenSim(nombre, tipo, infoad: string); virtual; abstract;
  end;




  { TSimPrint_text }
  TSimPrint_text = class(TSimPrint)
    constructor Create(sala: TCosa; id_hilo, kCronicaIni, kCronicaFin: integer);
    procedure Inicio; override;
    procedure EncabezadoDeCronica; override;
    procedure ResultadosDelPaso; override;
    destructor Destroy; override;

    // auxiliary callback methods
    procedure WriteEncab(s: string); override;
    procedure WriteResultados(s: string); override;
    procedure printEncabezadoResumenSim(nombre, tipo, infoad: string); override;
    procedure printResumenSim(nombre, tipo, infoad: string); override;

  private
    archi_fsal: string;
    fsal: Textfile;
  end;


  { TSimPrint_bin }
  TSimPrint_bin = class(TSimPrint)
    constructor Create(sala: TCosa; id_hilo, kCronicaIni, kCronicaFin: integer);
    procedure Inicio; override;
    procedure EncabezadoDeCronica; override;
    procedure ResultadosDelPaso; override;
    destructor Destroy; override;

    // auxiliary callback methods
    procedure WriteEncab(s: string); override;
    procedure WriteResultados(s: string); override;
    procedure printEncabezadoResumenSim(nombre, tipo, infoad: string); override;
    procedure printResumenSim(nombre, tipo, infoad: string); override;

  private

  end;


implementation

uses
  usalasdejuego, uActores, uFuentesAleatorias,
  uConstantesSimSEE, uauxiliares, ufechas, uversiones;

type

  { TSimPrint_REC }

  TSimPrint_REC = class
    SimPrint: TSimPrint;

    vSimSEE: integer;
    dtIniCalculo: TDateTime;
    dtIniSim, dtFinSim: TDateTime;
    NCronicas: integer;
    NPasos: integer;
    NPostes: integer;
    DurPos: TDAOfNInt;
    NActores: integer;
    actores: array of TActor;

    constructor Create_Inicio(xSimPrint: TSimPrint);
    procedure WriteToText(var fsal: TextFile);

  end;

{ TSimPrint_REC }

constructor TSimPrint_REC.Create_Inicio(xSimPrint: TSimPrint);
begin
  (*
  with SimPrint.sala as TSalaDeJuego do
  begin
    system.Writeln(fsal, 'Versión del simulador:'#9, vSimSEESimulador_ );
    system.writeln(fsal, 'Inicio simulación: '#9, DateTimeToIsoStr(now()));
    system.Writeln(fsal, 'FechaIniSim:'#9, globs.fechaIniSim.AsISOStr,
      #9'FechaFinSim:'#9, globs.fechaFinSim.AsISOStr);
    system.writeln(fsal, 'NCronicas:'#9, globs.NCronicasSim);
    system.writeln(fsal, 'NPasos:'#9, globs.nPasos);
    system.writeln(fsal, 'NPostes:'#9, length(globs.Durpos));
    system.Write(fsal, 'DurPos[h]:');
    for iposteres := 0 to high(globs.DurPos) do
      Write(fsal, #9, globs.DurPos[iposteres]);
    system.writeln(fsal);
    system.writeln(fsal, 'NActores:'#9, length(actores));
    TActor.printEncabezadoResumenSim(self);
    for kactorres := 0 to high(actores) do
      actores[kactorres].printResumenSim(self);
  end;
  *)
end;

procedure TSimPrint_REC.WriteToText(var fsal: TextFile);
begin
  (*
  with SimPrint.sala as TSalaDeJuego do
  begin
    system.Writeln(fsal, 'Versión del simulador:'#9, vSimSEESimulador_ );
    system.writeln(fsal, 'Inicio simulación: '#9, DateTimeToIsoStr(now()));
    system.Writeln(fsal, 'FechaIniSim:'#9, globs.fechaIniSim.AsISOStr,
      #9'FechaFinSim:'#9, globs.fechaFinSim.AsISOStr);
    system.writeln(fsal, 'NCronicas:'#9, globs.NCronicasSim);
    system.writeln(fsal, 'NPasos:'#9, globs.nPasos);
    system.writeln(fsal, 'NPostes:'#9, length(globs.Durpos));
    system.Write(fsal, 'DurPos[h]:');
    for iposteres := 0 to high(globs.DurPos) do
      Write(fsal, #9, globs.DurPos[iposteres]);
    system.writeln(fsal);
    system.writeln(fsal, 'NActores:'#9, length(actores));
    TActor.printEncabezadoResumenSim(self);
    for kactorres := 0 to high(actores) do
      actores[kactorres].printResumenSim(self);
  end;
  *)
end;




{ TSimPrint_bin }

constructor TSimPrint_bin.Create(sala: TCosa;
  id_hilo, kCronicaIni, kCronicaFin: integer);
begin

end;

procedure TSimPrint_bin.Inicio;
begin

end;

procedure TSimPrint_bin.EncabezadoDeCronica;
begin

end;

procedure TSimPrint_bin.ResultadosDelPaso;
begin

end;


destructor TSimPrint_bin.Destroy;
begin
  inherited Destroy;
end;

procedure TSimPrint_bin.WriteEncab(s: string);
begin

end;

procedure TSimPrint_bin.WriteResultados(s: string);
begin

end;

procedure TSimPrint_bin.printEncabezadoResumenSim(nombre, tipo, infoad: string);
begin

end;

procedure TSimPrint_bin.printResumenSim(nombre, tipo, infoad: string);
begin

end;

{ TSimPrint_text }

constructor TSimPrint_text.Create(sala: TCosa;
  id_hilo, kCronicaIni, kCronicaFin: integer);

begin
  inherited Create(sala, id_hilo, kCronicaIni, kCronicaFin);

  with sala as TSalaDeJuego do
  begin
    //Creo el archivo de simres
    if not DirectoryExists(dirResultadosCorrida) then
      MkDir(dirResultadosCorrida);

    archi_fsal := dirResultadosCorrida + 'simres' + '_' +
      IntToStr(globs.semilla_inicial_sim)
      //+ 'x' + IntToStr(Globs.NCronicasSim)
      + '_' + EscenarioActivo.nombre;

    archi_fsal := archi_fsal + '_d' + padNd(IntToStr(kCronicaIni), 5) +
      'a' + padNd(IntToStr(kCronicaFin), 5) + 'h' + IntToStr(id_hilo);

    archi_fsal := archi_fsal + '.xlt';

    assignfile(fsal, archi_fsal);
    rewrite(fsal);
  end;
end;

procedure TSimPrint_text.printEncabezadoResumenSim(nombre, tipo, infoad: string);
begin
  writeln(fsal, nombre, #9, tipo, #9, infoad);
end;

procedure TSimPrint_text.printResumenSim(nombre, tipo, infoad: string);
begin
  writeln(fsal, nombre, #9, tipo, #9, Infoad);
end;

procedure TSimPrint_text.Inicio;
var
  iposteres, kactorres: integer;
begin
  with sala as TSalaDeJuego do
  begin
    system.Writeln(fsal, 'Versión del simulador:'#9, vSimSEESimulador_);
    system.writeln(fsal, 'Inicio simulación: '#9, DateTimeToIsoStr(now()));
    system.Writeln(fsal, 'FechaIniSim:'#9, globs.fechaIniSim.AsISOStr,
      #9'FechaFinSim:'#9, globs.fechaFinSim.AsISOStr);
    system.writeln(fsal, 'NCronicas:'#9, globs.NCronicasSim);
    system.writeln(fsal, 'NPasos:'#9, globs.nPasos);
    system.writeln(fsal, 'NPostes:'#9, length(globs.Durpos));
    system.Write(fsal, 'DurPos[h]:');
    for iposteres := 0 to high(globs.DurPos) do
      Write(fsal, #9, globs.DurPos[iposteres]);
    system.writeln(fsal);
    system.writeln(fsal, 'NActores:'#9, length(actores));
    TActor.printEncabezadoResumenSim(self);
    for kactorres := 0 to high(actores) do
      actores[kactorres].printResumenSim(self);
  end;
end;

procedure TSimPrint_text.EncabezadoDeCronica;
var
  kfuenterres, kactorres: integer;
begin
  with sala as TSalaDeJuego do
  begin
    writeln(fsal);
    Write(fsal, 'CRONICA:', #9, globs.kCronica, #9, 'SemillaAleatoria:', #9,
      globs.MadresUniformes.get_UltimaSemilla);
    for kfuenterres := 0 to lst_Sim_cronicaIdInicio.Count - 1 do
    begin
      idCronicaInicioFuenteK :=
        TFuenteAleatoria(lst_Sim_cronicaIdInicio[kfuenterres]).cronicaIdInicio;
      if idCronicaInicioFuenteK <> '' then
        Write(fsal, #9, idCronicaInicioFuenteK);
    end;
    writeln(fsal);

    // PRINT kencab= 0
    Write(fsal, '-', #9, '-');
    // estos dos guiones estan abajo de donde dice CRONICA y kCronica, lo mismo el resto
    for kactorres := 0 to high(actores) do
      actores[kactorres].sim_PrintResultados_Encab(self, 0);
    for kfuenterres := 0 to high(fuentes) do
      fuentes[kfuenterres].sim_PrintResultados_Encab(self, 0);

    // esto sí es de la sala y hay que reescribirlo
    sim_PrintResultados_Encab(self, 0);
      {$IFDEF INTERMEDIARIO_DE_COSTO_FUTURO}
    if intermediario <> nil then
      intermediario.sim_PrintResultados_Encab(self, 0);
      {$ENDIF}
    writeln(fsal);

    // PRINT kencab= 1
    Write(fsal, '-', #9, '-');
    for kactorres := 0 to high(actores) do
      actores[kactorres].sim_PrintResultados_Encab(self, 1);
    for kfuenterres := 0 to high(fuentes) do
      fuentes[kfuenterres].sim_PrintResultados_Encab(self, 1);

    // estas son las unidades de la sala
    sim_PrintResultados_Encab(self, 1);
      {$IFDEF INTERMEDIARIO_DE_COSTO_FUTURO}
    if intermediario <> nil then
      intermediario.sim_PrintResultados_Encab(self, 1);
      {$ENDIF}
    writeln(fsal);

    // PRINT kencab= 2
    Write(fsal, '-', #9, '-');
    for kactorres := 0 to high(actores) do
      actores[kactorres].sim_PrintResultados_Encab(self, 2);

    for kfuenterres := 0 to high(fuentes) do
      fuentes[kfuenterres].sim_PrintResultados_Encab(self, 2);

    // estas son las variables de la sala

    sim_PrintResultados_Encab(self, 2);
    {$IFDEF INTERMEDIARIO_DE_COSTO_FUTURO}
    if intermediario <> nil then
      intermediario.sim_PrintResultados_Encab(self, 2);
    {$ENDIF}
    writeln(fsal);

    // PRINT kencab= 3
    Write(fsal, 'Paso', #9, 'FechaInicioDelPaso');
    for kactorres := 0 to high(actores) do
      actores[kactorres].sim_PrintResultados_Encab(self, 3);
    for kfuenterres := 0 to high(fuentes) do
      fuentes[kfuenterres].sim_PrintResultados_Encab(self, 3);

    // poste
    sim_PrintResultados_Encab(self, 3);
    {$IFDEF INTERMEDIARIO_DE_COSTO_FUTURO}
    if intermediario <> nil then
      intermediario.sim_PrintResultados_Encab(self, 3);
    {$ENDIF}
    writeln(fsal);
  end;
end;

procedure TSimPrint_text.ResultadosDelPaso;
var
  kactorres, kfuenterres: integer;
begin
  with sala as TSalaDeJuego do
  begin
    Write(fsal, IntToStr(globs.kPaso_Sim), #9, globs.FechaInicioDelPaso.AsISOStr);
    for kactorres := 0 to high(actores) do
      actores[kactorres].sim_PrintResultados(self);
    for kfuenterres := 0 to high(fuentes) do
      fuentes[kfuenterres].sim_PrintResultados(self);

    sim_PrintResultados(self);

    {$IFDEF INTERMEDIARIO_DE_COSTO_FUTURO}
    if intermediario <> nil then
      intermediario.sim_PrintResultados(self);
    {$ENDIF}
    writeln(fsal);
  end;
end;




destructor TSimPrint_text.Destroy;
begin
  system.writeln(fsal, 'Fin simulación:'#9, DateTimeToIsoStr(now()));
  closefile(fsal);
  inherited Destroy;
end;

procedure TSimPrint_text.WriteEncab(s: string);
begin
  system.Write(fsal, #9, s);
end;

procedure TSimPrint_text.WriteResultados(s: string);
begin
  system.Write(fsal, #9, s);
end;

{ TSimPrint }

constructor TSimPrint.Create(sala: TCosa; id_hilo, kCronicaIni, kCronicaFin: integer);
begin
  self.sala := sala;
  self.id_hilo := id_hilo;
  self.kCronicaIni := kCronicaIni;
  self.kCronicaFin := kCronicaFin;

end;

procedure TSimPrint.Inicio;
begin

end;

procedure TSimPrint.EncabezadoDeCronica;
begin

end;

procedure TSimPrint.ResultadosDelPaso;
begin

end;


destructor TSimPrint.Destroy;
begin
  inherited Destroy;
end;

end.




