unit uverdoc;


interface

uses
  LCLIntf,
  SysUtils,
  uConstantesSimSEE;

const
  marcadorNulo = '';

procedure abrir_url(url: string);

procedure verdoc( aClass: TClass); overload;
procedure verdoc( aClass: TClass; titulo: String); overload;
procedure verdoc( aClass: TClass; titulo, marcador: string); overload;

procedure verdoc( topico: string); overload;
procedure verdoc( topico, titulo: string); overload;
procedure verdoc( topico, titulo, marcador: string); overload;

procedure verGoogleMap( Latitud, Longitud: double; z: integer );

procedure SistemaDeSoporteAUsuarios;

implementation


procedure verdoc( aClass: TClass );
begin
  verdoc( 'class-'+aClass.ClassName, '');
end;

procedure verdoc( aClass: TClass ;titulo: String);
begin
  verdoc( 'class-'+aClass.ClassName, titulo);
end;

procedure verdoc( aClass: TClass; titulo, marcador: string);
begin
  verdoc( 'class-'+aClass.ClassName, titulo, marcador);
end;

procedure verdoc( topico: string );
begin
  verdoc( topico, topico, marcadorNulo);
end;

procedure verdoc( topico, titulo: string);
begin
  verdoc( topico, titulo, '');
end;

function URLEncode(Str: string): string;
var
  i: integer;
  res: string;
  c: char;
begin
  res:= '';

  for i:= 1 to Length(Str) do
  begin
    c:= Str[i];
    if ( c= ' ') then 
      res:= res + '+'
    else
      if c in ['A'..'Z','a'..'z','0'..'9','-','_','.','+'] then
        res:= res + c
      else
        res:= res + '%' + IntToHex(Ord(c),2);
  end;
  result:= res;
end;



procedure verdoc(topico, titulo, marcador: string);
var
  parametros: String;
begin
//  parametros:= 'http://energiaenuruguay.com/simsee/ayuda.php?hid='+ urlencode(topico)
  parametros:= 'http://simsee.org/simsee/ayuda/ayuda.php?hid='+ urlencode(topico)
      +'&titulo=' +urlencode( titulo )
      +'#'+urlencode(marcador);
  OpenURL(pchar(parametros));
end;


procedure abrir_url(url: string);
begin
  OpenURL(pchar( url ));
end;

procedure verGoogleMap( Latitud, Longitud: double; z: integer );
var
  url: string;
begin
(*
  url:= 'http://maps.google.com/maps/ms?ie=UTF8&hl=es&msa=0&t=h&ll=';
  url:= url+ FloatToStrF( -Latitud, ffFixed, 9, 5 );
  url:= url+','+FloatToStrF( -Longitud, ffFixed, 9, 5 );
  url:= url+'&z='+IntToStr( z );
  *)

  url:= 'http://energiaenuruguay.com/mapa.php?Latitud=';
  url:= url+ urlencode( FloatToStrF( -Latitud, ffFixed, 9, 5 ));
  url:= url+'&Longitud='+ urlencode( FloatToStrF( -Longitud, ffFixed, 9, 5 ) );
  url:= url+'&z='+ urlencode( IntToStr( z ) );

  OpenURL(pchar(url));

end;


procedure SistemaDeSoporteAUsuarios;
var
  url: string;
begin
  url:= 'http://simsee.org/soporte';
  OpenURL(pchar(url));
end;


initialization
end.


