unit uEventosOptSim;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
  ucosa, SysUtils, Classes;

type
  TEventoOptSim = (
    // Eventos durante una optimización
    E_Opt_Inicio,
    E_Opt_InicioCalculosEtapa,
    E_Opt_InicioCronicaSorteos,
    E_Opt_PrepararPaso_ps,
    E_Opt_FinCronicaSorteos,
    E_Opt_FinCalculosEtapa,
    E_Opt_Fin,

    // Eventos durante una simulación
    E_Sim_Inicio,
    E_Sim_InicioCronica,
    E_Sim_InicioPaso,
    E_Sim_FinPaso,
    E_Sim_FinCronica,
    E_Sim_Fin
    );


const
  CNombreDeEventos: array[TEventoOptSim] of string = (
    'Opt_Inicio',
    'Opt_InicioCalculosEtapa',
    'Opt_InicioCronicaSorteos',
    'Opt_PrepararPaso_ps',
    'Opt_FinCronicaSorteos',
    'Opt_FinCalculosEtapa',
    'Opt_Fin',

    // Eventos durante una simulación
    'Sim_Inicio',
    'Sim_InicioCronica',
    'Sim_InicioPaso',
    'Sim_FinPaso',
    'Sim_FinCronica',
    'Sim_Fin'
    );



function nombresEventos: TStrings;
function eventoToStr(evento: TEventoOptSim): string;
function strToEvento(cadena: string): TEventoOptSim;

(* tipoDeEvento, retorna 1 si es un evento de Simulación,
    retorna 2 si es un evento de Optimización y
    retorna -1 si no es ninguno de los anteriores.  *)
function tipoDeEvento(evento: TEventoOptSim): integer;

procedure alInicio;
procedure alFinal;

implementation

var
  //Una lista de strings con los nombres de los eventos
  eventos: TStrings;



function nombresEventos: TStrings;
begin
  Result := eventos;
end;

function eventoToStr(evento: TEventoOptSim): string;
begin
  Result := CNombreDeEventos[evento];
end;

function strToEvento(cadena: string): TEventoOptSim;
var
  k: TEventoOptSim;
  buscando: boolean;

begin
  buscando := True;
  for k := low(TEventoOptSim) to high(TEventoOptSim) do
    if CNombreDeEventos[k] = cadena then
    begin
      buscando := False;
      break;
    end;

  if buscando then
    raise Exception.Create('Evento no registrado: ' + cadena);
  Result := k;
end;

function TipoDeEvento(evento: TEventoOptSim): integer;
begin
  if evento <= E_Opt_Fin then
    Result := 2
  else if evento <= E_Sim_Fin then
    Result := 1
  else
    Result := -1; //ERROR
end;



procedure AlInicio;
var
  i: TEventoOptSim;
begin
  eventos := TStringList.Create;
  for i := low(TEventoOptSim) to high(TEventoOptSim) do
    eventos.Add(EventoToStr(i));
end;

procedure AlFinal;
begin
  eventos.Free;
end;


end.
