unit uMonitorConsola;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
	uMonitores, uVarDefs, SysUtils, uSalasDeJuego;

type

	TMonConsola = class (TMonitores)
		private
			defVar : TVarDef;
		public
			Constructor Create(defVar : TVarDef);
			function resolverRefProc(refProc : Integer) : TProcWrapper; override;
			procedure Escribir;
	end;

implementation

//-----------------------
// Métodos de TMonConsola
//=======================

Constructor TMonConsola.Create(defVar : TVarDef);
begin
	inherited Create;
	self.defVar := defVar;
end;

function TMonConsola.resolverRefProc(refProc : Integer) : TProcWrapper;
var
	aux : TProcWrapper;
begin
	case refProc of
		1 : aux := TProcWrapper.Create(self, self.Escribir);
	else
		raise Exception.Create('Metodo no registrado para ' + self.ClassName + IntToStr(refProc));
  end;
	result := aux;
end;

procedure TMonConsola.Escribir;
begin
  system.Writeln(defVar.nombreVar + ' = ' + defVar.asS);
end;

end.
