unit uMonitorHistograma;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
	uMonitores, uVarDefs, SysUtils, xMatDefs;

type
	TMonHistograma = class(TMonitores)
		private
			defVar : TVarDef;
			intervalos : TDAOfNReal;
			//n = Length(histograma) := Length(intervalos) + 1
			//histograma[i] = {#valores menores que intervalos[0] si i = 0
			//								{#valores en [intervalos[i], intervalos[i + 1]) si i en 1..n-1
			//								{#valores mayores o iguales que intervalos[n-1]
		public
			histograma : TDAofNInt;

			Constructor Create(defVar : TVarDef; intervalos : TDAofNReal);
				//intervalos contiene los limites de los intervalos en los cuales se parte
				//el histograma. Define Length(intervalos) -1 intervalos de la forma
				//[intervalos[i], intervalos[i-1])

			function resolverRefProc(refProc : Integer) : TProcWrapper; override;
			procedure AgregarValor;
			procedure Free; override;
	end;


implementation

//--------------------------
// Métodos de TMonHistograma
//==========================

Constructor TMonHistograma.Create(defVar : TVarDef; intervalos : TDAofNReal);
var
	i : Integer;
begin
	inherited Create;
	self.defVar := defVar;
	SetLength(self.intervalos, Length(intervalos) +1);
	for i := 0 to high(intervalos) do
		self.intervalos[i] := intervalos[i];
	self.intervalos[high(self.intervalos)] := xMatDefs.MaxNReal;

	SetLength(histograma, Length(intervalos) + 1);
	for i := 0 to high(histograma) do
		histograma[i] := 0;
end;

function TMonHistograma.resolverRefProc(refProc : Integer) : TProcWrapper;
var
	aux : TProcWrapper;
begin
		case refProc of
			1 : aux := TProcWrapper.Create(self, self.AgregarValor);
		else
			raise Exception.Create('Metodo no registrado para ' + self.ClassName + IntToStr(refProc));
		end;
	result := aux;
end;

procedure TMonHistograma.AgregarValor;
var
	x : NReal;
	i : Integer;
begin
	x := defVar.asNR;
	for i := 0 to high(intervalos) do
		if x < intervalos[i] then
		begin
		  histograma[i] := histograma[i] + 1;
			break;
		end;
end;

procedure TMonHistograma.Free;
begin
	SetLength(intervalos, 0);
	SetLength(histograma, 0);
	inherited Free;
end;


end.
