unit uReferenciaMonArchivo;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
  uReferenciaMonitor, uEventosOptSim,
  uVarDefs, uMonitorArchivo, uCosa, uCosaConNombre,
  Classes, SysUtils, uMonitores,
  uSalasDeJuego;

resourcestring
  rsMonitorDeArchivo = 'Monitor de Archivo';
  mesEnElMonitor = 'En el monitor ';

type

  { TReferenciaMonArchivo }
  TReferenciaMonArchivo_auxRec = class
    msg: array[ TEventoOptSim ] of string;
    cadena: array[ TEventoOptSim ] of string;
  end;

  TReferenciaMonArchivo = class(TReferenciaMonMultiVar)
  public
    filename: string;

    mensajes: TDAofMsgs;
    constructor Create(capa: integer; nombreMon: string; filename: string;
      defVars: TListaDeCosas; xEventosProcs: TDAOfEventoProc; msgs: TDAofMsgs);

    function Rec: TCosa_RecLnk; override;
    procedure BeforeRead(version, id_hilo: integer); override;
    procedure AfterRead(f:TArchiTexto); override;


    class function DescClase: string; override;
    procedure crearMonitorDeVariables(cosasMonitoreables: TListaDeCosasConNombre);
      override;
    class function tiposMonitoreables: AOfVarDef; override;

  private
    px: TReferenciaMonArchivo_auxRec;
  end;

procedure AlInicio;
procedure AlFinal;

implementation

var
  VarDefsValidas_TMonArchivo: AOfVarDef;

//--------------------------------
//Metodos de TReferenciaMonArchivo
//================================

 
constructor TReferenciaMonArchivo.Create( capa: integer; nombreMon: string; filename: string;
  defVars: TListaDeCosas {of TReferenciaDefVar}; xEventosProcs: TDAOfEventoProc;
  msgs: TDAofMsgs);






var
  j: TEventoOptSim;
begin
  inherited Create(capa, nombreMon, xEventosProcs, defVars);
   
    for j := low(TEventoOptSim) to high(TEventoOptSim) do
      mensajes[j] := msgs[j];
  
  


  Self.filename := filename;
end;

function TReferenciaMonArchivo.Rec: TCosa_RecLnk;
var
  i: TEventoOptSim;
begin
  Result:=inherited Rec;
  Result.addCampoDef( 'filename', filename );
  for i := low(mensajes) to high(mensajes) do
  begin
    Result.addCampoDef('evento', px.cadena[i]);
    Result.addCampoDef('mensaje', px.msg[i]);
  end;
end;

procedure TReferenciaMonArchivo.BeforeRead(version, id_hilo: integer);
begin
  inherited BeforeRead(version, id_hilo);
  px:= TReferenciaMonArchivo_auxRec.Create;
end;

procedure TReferenciaMonArchivo.AfterRead(f:TArchiTexto);
  var
    cadena, msg: string;
    evento: TEventoOptSim;
    i: TEventoOptSim;
  begin
    inherited AfterRead(f);
    for i := low(mensajes) to high(mensajes) do
    begin
      evento := StrToEvento(px.cadena[i]);
      mensajes[evento] := px.msg[i];
    end;
  px.Free;
end;


class function TReferenciaMonArchivo.DescClase: string;
begin
  Result := rsMonitorDeArchivo;
end;

procedure TReferenciaMonArchivo.crearMonitorDeVariables(cosasMonitoreables:
  TListaDeCosasConNombre);
var
  ListaDefVars: TList; {of TVarDef}
  i: integer;
  varDef: TVarDef;
  errores: string;
begin
  eventos := sortTDAOfEventoProcByProc(eventos);
  errores := '';
  ListaDefVars := TList.Create;
  ListaDefVars.Capacity := defVars.Count;
  for i := 0 to defVars.Count - 1 do
  begin
    try
      begin
        varDef := TReferenciaDefVar(defVars[i]).resolver(cosasMonitoreables);
        varDef.Prepararse;
        ListaDefVars.Add(varDef);
      end
    except
      on E: EReferenciaDefVarException do
      begin
        errores := errores + E.Message;
      end
    end;
  end;
  i := ListaDefVars.Count;
  if ListaDefVars.Count <> 0 then
    monitor := TMonArchivo.Create(ListaDefVars, filename, mensajes);
  ListaDefVars.Free;
  if errores <> '' then
    raise EMonitorException.Create(errores + mesEnElMonitor + nombre + '.', i);
end;

class function TReferenciaMonArchivo.tiposMonitoreables: AOfVarDef;
begin
  Result := VarDefsValidas_TMonArchivo;
end;


















procedure AlInicio;
begin
  registrarClaseDeCosa(TReferenciaMonArchivo.ClassName, TReferenciaMonArchivo);

  SetLength(VarDefsValidas_TMonArchivo, 1);
  VarDefsValidas_TMonArchivo[0] := TVarDef;
end;

procedure AlFinal;
begin
  SetLength(VarDefsValidas_TMonArchivo, 0);
end;

end.
 
