unit uReferenciaMonHistograma;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
  uReferenciaMonitor, uVarDefs, uMonitorHistograma, uCosa, uCosaConNombre,
  Classes, SysUtils, xMatDefs, uMonitores;

resourcestring
  rsMonitorDeHistograma = 'Monitor de Histograma';
  mesNoSeEncuentraLaVariable = 'No se encuentra la variable';
  mesEnElActor = ' en el actor ';
  mesEnElMonitor = 'En el monitor ';
  mesNoSeEncuentraActor = 'No se encuentra el actor';

type

  { TReferenciaMonHistograma }

  TReferenciaMonHistograma = class(TReferenciaMonUniVar)

  public
    (**************************************************************************)
    (*               A T R I B U T O S   P E R S I S T E N T E S              *)
    (**************************************************************************)

    intervalos: TDAofNReal;

    (**************************************************************************)

    constructor Create(capa: integer; xnombreMon, xnombreCosa, xclaseCosa,
      xnombreVar: string; xEventosProcs: TDAOfEventoProc; intervalos: TDAofNReal);

    function Rec: TCosa_RecLnk; override;
    procedure BeforeRead(version, id_hilo: integer); override;
    procedure AfterRead(f:TArchiTexto); override;

    class function DescClase: string; override;
    procedure crearMonitorDeVariables(cosasMonitoreables: TListaDeCosasConNombre);
      override;
    class function tiposMonitoreables: AOfVarDef; override;
    procedure PubliVars; override;
    procedure Free; override;
  end;

procedure AlInicio;
procedure AlFinal;

implementation

var
  VarDefsValidas_TMonHistograma: AOfVarDef;

//-----------------------------------
//Metodos de TReferenciaMonHistograma
//===================================

constructor TReferenciaMonHistograma.Create(capa: integer; xnombreMon, xnombreCosa,
  xclaseCosa, xnombreVar: string;{ indice : Integer;} xEventosProcs: TDAOfEventoProc;
  intervalos: TDAofNReal);
begin
  inherited Create(capa, xnombreMon, xnombreCosa, xclaseCosa, xnombreVar, xEventosProcs);
  self.intervalos := copy(intervalos, 0, MAXINT);
end;

function TReferenciaMonHistograma.Rec: TCosa_RecLnk;
begin
  Result:=inherited Rec;
  Result.addCampoDef( 'intervalos', intervalos );
end;

procedure TReferenciaMonHistograma.BeforeRead(version, id_hilo: integer);
begin
  inherited BeforeRead(version, id_hilo);
end;

procedure TReferenciaMonHistograma.AfterRead(f:TArchiTexto);
begin
  inherited AfterRead(f);
end;


class function TReferenciaMonHistograma.DescClase: string;
begin
  Result := rsMonitorDeHistograma;
end;

procedure TReferenciaMonHistograma.crearMonitorDeVariables(
  cosasMonitoreables: TListaDeCosasConNombre);
var
  ipos: integer;
  cosa: TCosaConNombre;
  varDef: TVarDef;
begin
  if cosasMonitoreables.find(defvar.claseCosa, defvar.nombreCosa, ipos) then
  begin
    cosa := TCosaConNombre(cosasMonitoreables[ipos]);
    if cosa.pubvarlst.find(defvar.nombreVar, ipos) then
    begin
      varDef := cosa.pubvarlst[ipos];
      varDef.Prepararse;
      monitor := TMonHistograma.Create(varDef, intervalos);
    end
    else
      raise EMonitorException.Create(mesNoSeEncuentraLaVariable + ' ' +
        defvar.nombreVar + mesEnElActor + defvar.claseCosa + ', ' +
        defvar.nombreCosa + '.' + #13 + mesEnElMonitor + nombre + '.', 0);
  end
  else
    raise EMonitorException.Create(mesNoSeEncuentraActor + ' ' + defvar.claseCosa +
      ', ' + defvar.nombreCosa + '.' + #13 + mesEnElMonitor + nombre + '.', 0);
end;

class function TReferenciaMonHistograma.tiposMonitoreables: AOfVarDef;
begin
  Result := VarDefsValidas_TMonHistograma;
end;

procedure TReferenciaMonHistograma.PubliVars;
var
  defVarAux: TVarDef;
  xintervalos: TDAofNReal;
begin
  //No se llama al inherited porque solo se quiere publicar el histograma.
  //Ademas por eso debe crearse la lista de vardefs
  if self.pubvarlst <> nil then
    self.pubvarlst.Free;
  self.pubvarlst := TListaVarDefs.Create;
  SetLength(xintervalos, Length(self.intervalos));
  xintervalos[0] := 0;
  defVarAux := TVarDef.Create(self, 'auxiliar', strSinUnidad, self);
  self.monitor := TMonHistograma.Create(defVarAux, xintervalos);
  self.PublicarVariablePVNI('Histograma', strSinUnidad, monitor,
    TMonHistograma(self.monitor).histograma, False);
  self.monitor.Free;
  defVarAux.Free;
  SetLength(xintervalos, 0);
  self.monitor := nil;
end;

procedure TReferenciaMonHistograma.Free;
begin
  SetLength(intervalos, 0);
  inherited Free;
end;










procedure AlInicio;
begin
  registrarClaseDeCosa(TReferenciaMonHistograma.ClassName, TReferenciaMonHistograma);
  SetLength(VarDefsValidas_TMonHistograma, 3);
  VarDefsValidas_TMonHistograma[0] := TVarDef_NR;
  VarDefsValidas_TMonHistograma[1] := TVarDef_NI;
  VarDefsValidas_TMonHistograma[2] := TVarDef_B;
end;

procedure AlFinal;
begin
  SetLength(VarDefsValidas_TMonHistograma, 0);
end;

end.
 
