unit uReferenciaMonSimRes;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
  uReferenciaMonitor, uEventosOptSim, uVarDefs, uMonitorSimRes, uCosa,
  uCosaConNombre, uMonitores, uSalasDeJuego, Classes;

resourcestring
  rsMonitorDeArchivoSimRes = 'Monitor de Archivo Para SimRes';
  mesEnElMonitor = 'En el monitor ';

type

  { TReferenciaMonSimRes }

  TReferenciaMonSimRes = class(TReferenciaMonMultiVar)
  public
    sala: TSalaDeJuego;
    filename: string;

    constructor Create(capa: integer; nombreMon: string; filename: string;
      defVars: TListaDeCosas; sala: TSalaDeJuego);
      reintroduce;

    function Rec: TCosa_RecLnk; override;
    procedure BeforeRead(version, id_hilo: integer); override;
    procedure AfterRead(f:TArchiTexto); override;

    class function DescClase: string; override;
    procedure crearMonitorDeVariables(cosasMonitoreables: TListaDeCosasConNombre);
      override;
    class function tiposMonitoreables: AOfVarDef; override;

  end;

procedure AlInicio;
procedure AlFinal;

var
  VarDefsValidas_TMonSimRes: AOfVarDef;

implementation

constructor TReferenciaMonSimRes.Create(capa: integer; nombreMon: string;
  filename: string; defVars: TListaDeCosas {of TReferenciaDefVar}; sala: TSalaDeJuego);
var
  xEventosProcs: TDAOfEventoProc;
begin
  SetLength(xEventosProcs, 4);
  xEventosProcs[0].evento := E_Sim_Inicio;
  xEventosProcs[0].refProc := TMonSimRes.darRefProc('AbrirArchivo', E_Sim_Inicio);
  xEventosProcs[1].evento := E_Sim_InicioCronica;
  xEventosProcs[1].refProc := TMonSimRes.darRefProc('EscribirEncabezadoCronica',
    E_Sim_InicioCronica);
  xEventosProcs[2].evento := E_Sim_FinPaso;
  xEventosProcs[2].refProc := TMonSimRes.darRefProc('EscribirPaso', E_Sim_FinPaso);
  xEventosProcs[3].evento := E_Sim_Fin;
  xEventosProcs[3].refProc := TMonSimRes.darRefProc('CerrarArchivo', E_Sim_Fin);

  inherited Create(capa, nombreMon, xEventosProcs, defVars);
  Self.filename := filename;
  self.sala := sala;
end;

function TReferenciaMonSimRes.Rec: TCosa_RecLnk;
begin
  Result:=inherited Rec;
  Result.addCampoDef('filename', filename);
  Result.addCampoDef_ref('sala', TCosa(sala), self);
end;

procedure TReferenciaMonSimRes.BeforeRead(version, id_hilo: integer);
begin
  inherited BeforeRead(version, id_hilo);
end;

procedure TReferenciaMonSimRes.AfterRead(f:TArchiTexto);
begin
  inherited AfterRead(f);
end;



class function TReferenciaMonSimRes.DescClase: string;
begin
  Result := rsMonitorDeArchivoSimRes;
end;

procedure TReferenciaMonSimRes.crearMonitorDeVariables(cosasMonitoreables:
  TListaDeCosasConNombre);
var
  ListaDefVars: TList; {of TVarDef}
  i: integer;
  varDef: TVarDef;
  errores: string;
begin
  eventos := sortTDAOfEventoProcByProc(eventos);
  errores := '';
  ListaDefVars := TList.Create;
  ListaDefVars.Capacity := defVars.Count;
  for i := 0 to defVars.Count - 1 do
  begin
    try
      begin
        varDef := TReferenciaDefVar(defVars[i]).resolver(cosasMonitoreables);
        varDef.Prepararse;
        ListaDefVars.Add(varDef);
      end
    except
      on E: EReferenciaDefVarException do
      begin
        errores := errores + E.Message;
      end
    end;
  end;
  i := ListaDefVars.Count;
  if ListaDefVars.Count <> 0 then
    monitor := TMonSimRes.Create(ListaDefVars, filename, sala);
  if errores <> '' then
    raise EMonitorException.Create(errores + mesEnElMonitor + nombre + '.', i);
end;

class function TReferenciaMonSimRes.tiposMonitoreables: AOfVarDef;
begin
  Result := VarDefsValidas_TMonSimRes;
end;











procedure AlInicio;
begin
  registrarClaseDeCosa(TReferenciaMonSimRes.ClassName, TReferenciaMonSimRes);

  SetLength(VarDefsValidas_TMonSimRes, 5);
  VarDefsValidas_TMonSimRes[0] := TVarDef_NR;
  VarDefsValidas_TMonSimRes[1] := TVarDef_NI;
  VarDefsValidas_TMonSimRes[2] := TVarDef_Fecha;
  VarDefsValidas_TMonSimRes[3] := TVarDef_VNR;
  VarDefsValidas_TMonSimRes[4] := TVarDef_VNI;
end;

procedure AlFinal;
begin
  SetLength(VarDefsValidas_TMonSimRes, 0);
end;

end.
