unit uReferenciaMonitorConsola;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
  uReferenciaMonitor, uVarDefs, uMonitorConsola, uCosa, uCosaConNombre,
  Classes, SysUtils, uMonitores;

resourcestring
  rsMonitorDeConsola = 'Monitor de Consola';
  mesNoSeEncuentraLaVariable = 'No se encuentra la variable';
  mesEnElActor = ' en el actor ';
  mesNoSeEncuentraActor = 'No se encuentra el actor';
  mesEnElMonitor = 'en el monitor ';

type

  { TReferenciaMonConsola }

  TReferenciaMonConsola = class(TReferenciaMonUniVar)
  private
  public
    constructor Create(capa: integer; xnombreMon, xnombreCosa, xclaseCosa,
      xnombreVar: string; xEventosProcs: TDAOfEventoProc);

    function Rec: TCosa_RecLnk; override;
    procedure BeforeRead(version, id_hilo: integer); override;
    procedure AfterRead(f: TArchiTexto); override;

    class function DescClase: string; override;

    //Busca las variables que monitorea en la sala y crea el monitor para ellas
    procedure crearMonitorDeVariables(cosasMonitoreables: TListaDeCosasConNombre);
      override;

    class function tiposMonitoreables: AOfVarDef; override;
  end;

procedure AlInicio;
procedure AlFinal;

implementation

var
  VarDefsValidas_TMonConsola: AOfVarDef;

//--------------------------------
//Metodos de TReferenciaMonConsola
//================================

constructor TReferenciaMonConsola.Create(capa: integer; xnombreMon, xnombreCosa,
  xclaseCosa, xnombreVar: string;{ indice : Integer; }xEventosProcs: TDAOfEventoProc);
begin
  inherited Create(capa, xnombreMon, xnombreCosa, xclaseCosa, xnombreVar,
    {indice,} xEventosProcs);
end;

function TReferenciaMonConsola.Rec: TCosa_RecLnk;
begin
  Result:=inherited Rec;
end;

procedure TReferenciaMonConsola.BeforeRead(version, id_hilo: integer);
begin
  inherited BeforeRead(version, id_hilo);
end;

procedure TReferenciaMonConsola.AfterRead(f: TArchiTexto);
begin
  inherited AfterRead(f);
end;

 

class function TReferenciaMonConsola.DescClase: string;
begin
  Result := rsMonitorDeConsola;
end;

procedure TReferenciaMonConsola.crearMonitorDeVariables(
  cosasMonitoreables: TListaDeCosasConNombre);
var
  ipos: integer;
  cosa: TCosaConNombre;
  varDef: TVarDef;
begin
  if cosasMonitoreables.find(defvar.claseCosa, defvar.nombreCosa, ipos) then
  begin
    cosa := TCosaConNombre(cosasMonitoreables[ipos]);
    if cosa.pubvarlst.find(defvar.nombreVar, ipos) then
    begin
      varDef := cosa.pubvarlst[ipos];
      varDef.Prepararse;
      monitor := TMonConsola.Create(varDef);
    end
    else
      raise EMonitorException.Create(mesNoSeEncuentraLaVariable + ' ' +
        defvar.nombreVar + mesEnElActor + defvar.claseCosa + ', ' +
        defvar.nombreCosa + '.' + #13 + 'En el monitor ' + nombre + '.', 0);
  end
  else
    raise EMonitorException.Create(mesNoSeEncuentraActor + ' ' +
      defvar.claseCosa + ', ' + defvar.nombreCosa + '.' + #13 + mesEnElMonitor +
      nombre + '.', 0);
end;

class function TReferenciaMonConsola.tiposMonitoreables: AOfVarDef;
begin
  Result := VarDefsValidas_TMonConsola;
end;

procedure AlInicio;
begin
  registrarClaseDeCosa(TReferenciaMonConsola.ClassName, TReferenciaMonConsola);
  SetLength(VarDefsValidas_TMonConsola, 1);
  VarDefsValidas_TMonConsola[0] := TVarDef;
end;

procedure AlFinal;
begin
  SetLength(VarDefsValidas_TMonConsola, 0);
end;

end.
