unit uReferenciaMonitorGraficoSimple;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
  uReferenciaMonitor, uMonitorGraficoSimple, uCosa, uVarDefs,
  Classes, SysUtils, uMonitores, Graphics, Forms, uCosaConNombre,
  xMatDefs;

resourcestring
  rsMonitorGraficoSimple = 'Monitor Gráfico Simple';
  mesEnElMonitor = 'En el monitor ';

type

  { TReferenciaSerie }

  TReferenciaSerie = class(TReferenciaDefVar)
  public
    nombreSerie: string;
    color: TColor;

    constructor Create(capa: integer; xnombreSerie: string;
      xnombreCosa, xclaseCosa, xnombreVar: string; xcolor: TColor);
     
    function Rec: TCosa_RecLnk; override;
    procedure BeforeRead(version, id_hilo: integer); override;
    procedure AfterRead(f:TArchiTexto); override;

  private
    rgbx: longint;
  end;

  { TReferenciaMonGrafico }

  TReferenciaMonGrafico = class(TReferenciaMonMultiVar)
  public

    nombreGrafico: string;
    MaxNPuntos: integer;
    nombre_sx: string;
    etiquetax, etiquetay: string;
    x1, x2, y1, y2: NReal;
    NDivisionesX, NDivisionesY: integer;
    XIni: integer;
    diffX: integer;
    grilla: boolean;

    constructor Create(capa: integer; xnombreMon: string;
      xEventosProcs: TDAOfEventoProc; xnombreGrafico: string;
  xMaxNPuntos: integer; xnombre_sx: string; xetiquetax, xetiquetay: string;
  x1_, x2_, y1_, y2_: double; xNDivisionesX, xNDivisionesY: integer;
  xXIni: integer; xdiffX: integer; seriesy: TListaDeCosas; xgrilla: boolean);

    function Rec: TCosa_RecLnk; override;
      procedure BeforeRead(version, id_hilo: integer); override;
      procedure AfterRead(f:TArchiTexto); override;

    class function DescClase: string; override;

    procedure crearMonitorDeVariables(cosasMonitoreables: TListaDeCosasConNombre);
      override;
    class function tiposMonitoreables: AOfVarDef; override;

end;

procedure AlInicio;
procedure AlFinal;

implementation

var
  VarDefsValidas_TMonGraficoSimple: AOfVarDef;

//---------------------------
//Metodos de TReferenciaSerie
//===========================

constructor TReferenciaSerie.Create(capa: integer; xnombreSerie: string;
  xnombreCosa, xclaseCosa, xnombreVar: string; {indice : Integer;}
  xcolor: TColor);
begin
  inherited Create(capa, xnombreCosa, xclaseCosa, xnombreVar{, indice});
  nombreSerie := xnombreSerie;
  color := xcolor;
end;

function TReferenciaSerie.Rec: TCosa_RecLnk;
begin
  Result:=inherited Rec;
  result.addCampoDef('nombreSerie', nombreSerie);
  result.addCampoDef('color', rgbx);
end;

procedure TReferenciaSerie.BeforeRead(version, id_hilo: integer);
begin
  inherited BeforeRead(version, id_hilo);
end;

procedure TReferenciaSerie.AfterRead(f:TArchiTexto);
begin
  inherited AfterRead(f);
  color := TColor(rgbx);
end;










//--------------------------------
//Metodos de TReferenciaMonGrafico
//================================

constructor TReferenciaMonGrafico.Create(capa: integer; xnombreMon: string;
  xEventosProcs: TDAOfEventoProc; xnombreGrafico: string;
  xMaxNPuntos: integer; xnombre_sx: string;
  xetiquetax, xetiquetay: string; x1_, x2_, y1_, y2_: double;
  xNDivisionesX, xNDivisionesY: integer; xXIni: integer;
  xdiffX: integer; seriesy: TListaDeCosas{of TReferenciaSerie};
  xgrilla: boolean);
begin
  inherited Create(capa, xnombreMon, xEventosProcs, seriesy);
  nombreGrafico := xnombreGrafico;
  MaxNPuntos := xMaxNPuntos;
  nombre_sx := xnombre_sx;
  etiquetax := xetiquetax;
  etiquetay := xetiquetay;
  x1 := x1_;
  x2 := x2_;
  y1 := y1_;
  y2 := y2_;
  NDivisionesX := xNDivisionesX;
  NDivisionesY := xNDivisionesY;
  XIni := xXIni;
  diffX := xdiffX;
  grilla := xgrilla;
end;

function TReferenciaMonGrafico.Rec: TCosa_RecLnk;
begin
  Result:=inherited Rec;
  Result.addCampoDef('nombreGrafico', nombreGrafico);
  Result.addCampoDef('MaxNPuntos', MaxNPuntos);
  Result.addCampoDef('nombre_sx', nombre_sx);
  Result.addCampoDef('etiquetax', etiquetax);
  Result.addCampoDef('etiquetay', etiquetay);
  Result.addCampoDef('x1', x1);
  Result.addCampoDef('x2', x2);
  Result.addCampoDef('y1', y1);
  Result.addCampoDef('y2', y2);
  Result.addCampoDef('NDivisionesX', NDivisionesX);
  Result.addCampoDef('NDivisionesY', NDivisionesY);
  Result.addCampoDef('XIni', XIni);
  Result.addCampoDef('diffX', diffX);
  Result.addCampoDef('grilla', grilla);
end;

procedure TReferenciaMonGrafico.BeforeRead(version, id_hilo: integer);
begin
  inherited BeforeRead(version, id_hilo);
end;

procedure TReferenciaMonGrafico.AfterRead(f:TArchiTexto);
begin
  inherited AfterRead(f);
end;



class function TReferenciaMonGrafico.DescClase: string;
begin
  Result := rsMonitorGraficoSimple;
end;

procedure TReferenciaMonGrafico.crearMonitorDeVariables(
  cosasMonitoreables: TListaDeCosasConNombre);
var
  listaDescSeries: TList;
  i: integer;
  varDef: TVarDef;
  serie: TDescSerie;
  refSerie: TReferenciaSerie;
  errores: string;
begin
  errores := '';
  listaDescSeries := TList.Create;
  for i := 0 to defVars.Count - 1 do
  begin
    try
      begin
        refSerie := TReferenciaSerie(defVars[i]);
        varDef := refSerie.resolver(cosasMonitoreables);
        varDef.Prepararse;
        serie := TDescSerie.Create(refSerie.nombreSerie, refSerie.color, varDef);
        listaDescSeries.Add(serie);
      end
    except
      on E: EReferenciaDefVarException do
        errores := errores + E.Message;
    end;
  end;
  i := listaDescSeries.Count;
  if listaDescSeries.Count <> 0 then
    monitor := TMonGraficoSimple.Create(Application.MainForm, nombreGrafico,
      MaxNPuntos, nombre_sx, etiquetax, etiquetay, x1, x2,
      y1, y2, NDivisionesX, NDivisionesY, XIni, diffX,
      listaDescSeries, grilla, posEnSala);
  if errores <> '' then
    raise EMonitorException.Create(errores + mesEnElMonitor + nombre + '.', i);
end;

class function TReferenciaMonGrafico.tiposMonitoreables: AOfVarDef;
begin
  Result := VarDefsValidas_TMonGraficoSimple;
end;


























procedure AlInicio;
begin
  registrarClaseDeCosa(TReferenciaMonGrafico.ClassName, TReferenciaMonGrafico);
  registrarClaseDeCosa(TReferenciaSerie.ClassName, TReferenciaSerie);

  SetLength(VarDefsValidas_TMonGraficoSimple, 3);
  VarDefsValidas_TMonGraficoSimple[0] := TVarDef_NR;
  VarDefsValidas_TMonGraficoSimple[1] := TVarDef_NI;
  VarDefsValidas_TMonGraficoSimple[2] := TVarDef_B;
end;

procedure AlFinal;
begin
  SetLength(VarDefsValidas_TMonGraficoSimple, 0);
end;

end.
