unit uAuxiliaresEscrituraSimRes;
{$MODE Delphi}
{$IFDEF APLICACION_CONSOLA}
{xDEFINE SIMRES3SOLOTEXTO}
{$ENDIF}

interface

uses
{$IFNDEF SIMRES3SOLOTEXTO}
{$IFDEF SVG_CANVAS}
usvgcanvas,
{$ELSE}
{$IFDEF FP_CANVAS}
ucoloresbasicos,
{$ELSE}
Graphics,
{$ENDIF}
{$ENDIF}
{$ENDIF}

uHistoVarsOps,
//uPrintCronVars,
uAuxiliares, xMatDefs, SysUtils,
uPrint,
Classes, uListaComentarioObjeto;


function toComentarioSimRes(s: String): String;

procedure borrarLineasVaciasConsecutivas(lineas: TStringList; maxNLineasVaciasConsecutivas: Integer);
procedure borrarLineasVaciasAntesDeCierreSeccion(lineas: TStringList; strComienzoCierreDeSeccion: String);

//si cronVar <> NIL Retorna cronVar.nombre
//sino retorna 'nil'
function nombreCronVar(cronVar: TCronVar): String;

function TDAOfTVarIdxsToString(arreglo: TDAOfTVarIdxs): String;
function TDAOfTVarIdxsToStringConTamanio(arreglo: TDAOfTVarIdxs): String;
function TDAOfCronVarToString(arreglo: TDAOfCronVar): String;
function TDAOfCronVarToStringConTamanio(arreglo: TDAOfCronVar): String;
function TDAOfStringToString(arreglo: TDAofString): String;
function TDAOfStringToStringConTamanio(arreglo: TDAofString): String;

{$IFNDEF SIMRES3SOLOTEXTO}
function TDAOfCronVarTipoGraficoEjeColorToStringConTamanio(cronVars: TDAOfCronVar; tiposGraficos: TDAOfTTipoGrafico;
                                             ejes: TDAOfTTipoEje; colores: TDAOfTColor): String;
{$ENDIF}
implementation


function toComentarioSimRes(s: String): String;
begin
  if pos(strComment, s) = 1 then
    result:= s
  else
    result:= strComment + s;
end;

procedure borrarLineasVaciasConsecutivas(lineas: TStringList; maxNLineasVaciasConsecutivas: Integer);
var
  i: Integer;
  nLineasVaciasConsecutivas: Integer;
begin
  i:= 0;
  nLineasVaciasConsecutivas:= 0;
  while i < lineas.Count do
  begin
    if lineas[i] = '' then
    begin
      nLineasVaciasConsecutivas:= nLineasVaciasConsecutivas + 1;    
      if nLineasVaciasConsecutivas >= maxNLineasVaciasConsecutivas + 1 then
        lineas.Delete(i)
      else
        i:= i + 1;
    end
    else
    begin
      nLineasVaciasConsecutivas:= 0;
      i:= i + 1;
    end;
  end;
end;

procedure borrarLineasVaciasAntesDeCierreSeccion(lineas: TStringList; strComienzoCierreDeSeccion: String);
var
  i: Integer;
begin
  i:= 0;
  while i < lineas.Count do
  begin
    if Pos(strComienzoCierreDeSeccion, lineas[i]) = 1 then
    begin
      while lineas[i - 1] = '' do
        lineas.Delete(i - 1);
    end;
    i:= i + 1;
  end;
end;

function nombreCronVar(cronVar: TCronVar): String;
begin
  if cronVar <> NIL then
    result:= cronVar.nombre
  else
    result:= 'nil';
end;

function TDAOfTVarIdxsToString(arreglo: TDAOfTVarIdxs): String;
var
  i: Integer;
  res: String;
begin
  if Length(arreglo) > 0 then
  begin
    res:= encomille(arreglo[0].nombreIndice);
    for i:= 1 to high(arreglo) do
      res:= res + #9 + encomille(arreglo[i].nombreIndice);
    result:= res;
  end
  else
    result:= '';
end;

function TDAOfTVarIdxsToStringConTamanio(arreglo: TDAOfTVarIdxs): String;
var
  i: Integer;
  res: String;
begin
  res:= IntToStr(Length(arreglo));
  for i:= 0 to high(arreglo) do
    res:= res + #9 + encomille(arreglo[i].nombreIndice);
  result:= res;
end;

function TDAOfCronVarToString(arreglo: TDAOfCronVar): String;
var
  i: Integer;
  res: String;
begin
  if Length(arreglo) > 0 then
  begin
    res:= encomille(arreglo[0].nombre);
    for i:= 1 to high(arreglo) do
      res:= res + #9 + encomille(arreglo[i].nombre);
    result:= res;
  end
  else
    result:= '';
end;

function TDAOfCronVarToStringConTamanio(arreglo: TDAOfCronVar): String;
var
  i: Integer;
  res: String;
begin
  res:= IntToStr(Length(arreglo));
  for i:= 0 to high(arreglo) do
    res:= res + #9 + encomille(arreglo[i].nombre);
  result:= res;
end;

function TDAOfStringToString(arreglo: TDAofString): String;
var
  i: Integer;
  res: String;
begin
  if Length(arreglo) > 0 then
  begin
    res:= encomille(arreglo[0]);
    for i:= 1 to high(arreglo) do
      res:= res + #9 + encomille(arreglo[i]);
    result:= res;      
  end
  else
    result:= '';
end;

function TDAOfStringToStringConTamanio(arreglo: TDAofString): String;
var
  i: Integer;
  res: String;
begin
  res:= IntToStr(Length(arreglo));
  for i:= 0 to high(arreglo) do
    res:= res + #9 + encomille(arreglo[i]);
  result:= res;
end;

{$IFNDEF SIMRES3SOLOTEXTO}
function TDAOfCronVarTipoGraficoEjeColorToStringConTamanio(cronVars: TDAOfCronVar; tiposGraficos: TDAOfTTipoGrafico;
                                                           ejes: TDAOfTTipoEje; colores: TDAOfTColor): String;
var
  i: Integer;
  res: String;
begin
  res:= IntToStr(Length(cronVars));
  for i:= 0 to high(cronVars) do
  begin
    res:= res + #9 + encomille(cronVars[i].nombre) + #9 + encomille(TTipoGraficoToString(tiposGraficos[i])) + #9 +
          encomille(TTipoEjeToString(ejes[i])) + #9 + ColorToString(colores[i]);
  end;
  result:= res;
end;
{$ENDIF}

end.
