unit uListaComentariosEnContexto;

interface

uses
  Classes;

type
  //Un comentario en contexto es una string asociada a un objeto
  //El comentario se posicionara antes de escribir el objeto.
  //Si objeto es NIL el comentario va al final de la seccion que se este
  //escribiendo
  TComentarioEnContexto = class
    public
      comentario: String;
      objeto: TObject;

      Constructor Create(comentario: String; objeto: TObject);
  end;

  TListaComentariosEnContexto = class(TList)
    private
      lastIObjeto: Integer;

    public
      Constructor Create;

      function addComentarioDelObjeto(objeto: TObject; comentario: String): Integer; overload;
      function addComentarioDelObjeto(objeto: TObject; comentario: TStringList): Integer; overload;

      function cambiarObjetoComentario(viejoObjeto, nuevoObjeto: TObject): boolean;
      function cambiarComentarioDelObjeto(objeto: TObject; nuevoComentario: String): boolean;

      function eliminarComentarioDelObjeto(objeto: TObject): Integer;

      function comentarioDelObjeto(objeto: TObject): String;
      procedure Free;
  end;

implementation

Constructor TComentarioEnContexto.Create(comentario: String; objeto: TObject);
begin
  inherited Create;
  self.comentario:= comentario;
  self.objeto:= objeto;
end;

Constructor TListaComentariosEnContexto.Create;
begin
  inherited Create;
  lastIObjeto:= -1;
end;

function TListaComentariosEnContexto.addComentarioDelObjeto(objeto: TObject; comentario: String): Integer;
begin
  result:= Add(TComentarioEnContexto.Create(comentario, objeto));
end;

function TListaComentariosEnContexto.addComentarioDelObjeto(objeto: TObject; comentario: TStringList): Integer;
begin
  result:= Add(TComentarioEnContexto.Create(comentario.Text, objeto));
end;

function TListaComentariosEnContexto.cambiarObjetoComentario(viejoObjeto, nuevoObjeto: TObject): boolean;
var
  i: Integer;
  res: boolean;
begin
  res:= False;
  for i:= 0 to Count - 1 do
  begin
    if TComentarioEnContexto(Items[i]).objeto = viejoObjeto then
    begin
      res:= true;
      TComentarioEnContexto(Items[i]).objeto:= nuevoObjeto;
      break;
    end;
  end;
  result:= res;
end;

function TListaComentariosEnContexto.cambiarComentarioDelObjeto(objeto: TObject; nuevoComentario: String): boolean;
var
  i: Integer;
  res: boolean;
begin
  res:= False;
  for i:= 0 to Count - 1 do
  begin
    if TComentarioEnContexto(Items[i]).objeto = objeto then
    begin
      res:= true;
      TComentarioEnContexto(Items[i]).comentario:= nuevoComentario;
      break;
    end;
  end;
  result:= res;
end;

function TListaComentariosEnContexto.eliminarComentarioDelObjeto(objeto: TObject): Integer;
var
  i,res: Integer;
begin
  res:= -1;
  for i:= 0 to Count - 1 do
  begin
    if TComentarioEnContexto(Items[i]).objeto = objeto then
    begin
      res:= i;
      Delete(i);
      break;
    end;
  end;
  result:= res;
end;

function TListaComentariosEnContexto.comentarioDelObjeto(objeto: TObject): String;
var
  i: Integer;
  encontre: boolean;
begin
  encontre:= false;
  for i:= lastIObjeto + 1 to Count - 1 do
  begin
    encontre:= objeto = TComentarioEnContexto(items[i]).objeto;
    if encontre then
    begin
      lastIObjeto:= i;
      break;
    end;
  end;

  if not encontre then
  begin
    for i:= 0 to lastIObjeto do
    begin
      encontre:= objeto = TComentarioEnContexto(items[i]).objeto;
      if encontre then
      begin
        lastIObjeto:= i;
        break;
      end;
    end;      
  end;

  if encontre then
    result:= TComentarioEnContexto(items[i]).comentario
  else
    result:= '';
end;

procedure TListaComentariosEnContexto.Free;
var
  i: Integer;
begin
  for i:= 0 to Count - 1 do
    TComentarioEnContexto(Items[i]).Free;
  inherited Free;
end;

end.
