unit uSustituirVariablesPlantilla;
{$MODE Delphi}

interface

uses
  Classes, upreprocesador, uSalasDeJuego, SysUtils,
  math,
  uconstantesSimSEE,
  ufechas,
  uauxiliares
{$IFDEF WINDOWS}
  , shellapi, windows
{$ENDIF};

type

  { TSustituirVariablesPlantilla }

  TSustituirVariablesPlantilla = class
    public
      idHilo: integer;

      Constructor Create( idHilo: integer );

      function obtenerArchiSimRes(lineaArchiSimRes: String; sala: TSalaDeJuego; semillaAleatoriaInicial: Integer): String;

      {$IFDEF DISTSIMRES3}

      function sustituirVariables(archivoPlantilla, dirCorrida: String; archivoSala: String; semillas: TStringList;
      NcronXtarea: String): String;overload;

      procedure ejecutarSimRes3(archivoPlantilla, dirCorrida: String; archivoSala: String; semillas: TStringList;
      NcronXtarea: String);overload;

      {$ENDIF}

      function sustituirVariables(archivoPlantilla: String; sala: TSalaDeJuego;
        nombre_escenario_activo: string; idPlantilla: string;
  semillaAleatoriaInicial: Integer): String; overload;
      function sustituirVariables(archivoPlantilla: String; archivoSala,
        nombre_escenario_activo, idPlantilla: String;
  semillaAleatoriaInicial: Integer): String; overload;
      function sustituirVariables(archivoPlantilla: String; idPlantilla: string;
        archivosSalas: TStringList; semillaAleatoriaInicial: Integer
  ): TStringList; overload;

      procedure ejecutarSimRes3(archivoPlantilla: String; sala: TSalaDeJuego;
        nombre_escenario_activo: string; semillaAleatoriaInicial: Integer; flg_html: boolean);
  overload;

      procedure ejecutarCMDSimRes3(archivoPlantilla: String; sala: TSalaDeJuego;
        nombre_escenario_activo: string; semillaAleatoriaInicial: Integer;
        idSubCarpetaSalida: string; idEjecutor: integer ); overload;

      procedure ejecutarSimRes3(archivoPlantilla: String; archivoSala,
        nombre_escenario_activo: String; semillaAleatoriaInicial: Integer; flg_html: boolean );
  overload;

      procedure Free;
  end;

implementation

constructor TSustituirVariablesPlantilla.Create(idHilo: integer);
begin
  inherited Create;
  self.idHilo:= idHilo;

end;

function TSustituirVariablesPlantilla.obtenerArchiSimRes(lineaArchiSimRes: String; sala: TSalaDeJuego; semillaAleatoriaInicial: Integer): String;
var
  listaVariablesPP: TListaDeVariablesPP;
  res: AnsiString;
begin
  listaVariablesPP:= TListaDeVariablesPP.Create;
  listaVariablesPP.Agregar( 'carpetaCorrida', sala.dirResultadosCorrida );
  listaVariablesPP.Agregar( 'semillaSim', IntToStr(semillaAleatoriaInicial));
  listaVariablesPP.Agregar( 'nCronicasSim', IntToStr(sala.Globs.NCronicasSim) );
  listaVariablesPP.Agregar( 'escenario', sala.EscenarioActivo.nombre );

  res:= upreprocesador.SustituirVariables(lineaArchiSimRes, listaVariablesPP);
  listaVariablesPP.Free;
  result:= res;
end;


{$IFDEF DISTSIMRES3}

function TSustituirVariablesPlantilla.sustituirVariables(archivoPlantilla,
  dirCorrida: String; archivoSala: String; semillas: TStringList;
  NcronXtarea: String): String;
var
  listaVariablesPP: TListaDeVariablesPP;
  archiModificado: String;
  sala: TSalaDeJuego;
begin
  if FileExists(archivoPlantilla) then
  begin
    // Definición de variables para el preprocesador.

//    sala:= TSalaDeJuego.cargarSala(archivoSala, true);

    setSeparadoresGlobales;
    listaVariablesPP:= TListaDeVariablesPP.Create;
    listaVariablesPP.Agregar( 'carpetaCorrida', dirCorrida );
//    listaVariablesPP.Agregar( 'semillaSim', semillas );
    listaVariablesPP.Agregar( 'nCronicasSim', NcronXtarea );
//    listaVariablesPP.Agregar( 'fechaIniSim', sala.globs.fechaIniSim.AsIsoStr );
//    listaVariablesPP.Agregar( 'fechaFinSim', sala.globs.fechaFinSim.AsIsoStr );

    // ahora creamos el archivo para el procesador crónico
    //getDir_Bin+'Plantilla-MP-simres3.txt'

//    sala.Free;

    archiModificado:= dirCorrida + DirectorySeparator + nombreArchSinExtension(archivoSala) + '.txt';
    CopiarSustituyendo( quitarRaiz_(archivoPlantilla), archiModificado, ListaVariablesPP );
    listaVariablesPP.Free;
    setSeparadoresLocales;
    result:= archiModificado;
  end
  else
    raise Exception.Create('TSustituirVariablesPlantilla.sustituirVariables: no se encuentra el archivo de plantilla "' + archivoPlantilla + '"');
end;


procedure TSustituirVariablesPlantilla.ejecutarSimRes3(archivoPlantilla,
  dirCorrida: String; archivoSala: String; semillas: TStringList;
  NcronXtarea: String);
var
  parametros: String;
begin
  parametros:= sustituirVariables(archivoPlantilla, dirCorrida, archivoSala, semillas, NcronXtarea)+ #0;

  ChDir('C:\simsee\bin');
  writeln(GetCurrentDir);
  ShellExecute( 0, 'open', 'SimRes3.exe', @parametros[1], NIL, SW_SHOWNORMAL);

end;

{$ENDIF}


function TSustituirVariablesPlantilla.sustituirVariables(
    archivoPlantilla: String;
    sala: TSalaDeJuego;
    nombre_escenario_activo: string;
    idPlantilla: string;
    semillaAleatoriaInicial: Integer): String;
var
  listaVariablesPP: TListaDeVariablesPP;
  archiModificado: String;
  fecha_aux: TFecha;
  dt_aux: double;
  kPasoVisible: integer;

begin
  if FileExists(archivoPlantilla) then
  begin
    // Definición de variables para el preprocesador.
    setSeparadoresGlobales;
    listaVariablesPP:= TListaDeVariablesPP.Create;
    listaVariablesPP.Agregar( 'carpetaCorrida', sala.dirResultadosCorrida );
    listaVariablesPP.Agregar( 'escenario', nombre_escenario_activo );
    listaVariablesPP.Agregar( 'semillaSim', IntToStr( semillaAleatoriaInicial ) );
    listaVariablesPP.Agregar( 'nCronicasSim', IntToStr(sala.Globs.NCronicasSim) );

    if sala.globs.fechaGuardaSim.dt <= sala.globs.fechaIniSim.dt then
      listaVariablesPP.Agregar( 'fechaIniSim', sala.globs.fechaIniSim.AsIsoStr )
    else
    begin
      sala.globs.CalcularConstantesBasicasDelPaso;
      fecha_aux:= TFecha.Create_Clone(sala.globs.fechaGuardaSim);
      dt_aux:= (fecha_aux.dt - sala.globs.fechaIniSim.dt);
      kPasoVisible:= ceil(dt_aux / sala.globs.dt_DelPaso );
      fecha_aux.dt:= sala.globs.fechaIniSim.dt + kPasoVisible * sala.globs.dt_DelPaso;
      listaVariablesPP.Agregar( 'fechaIniSim', fecha_aux.AsIsoStr );
      fecha_aux.free;
    end;
    listaVariablesPP.Agregar( 'fechaFinSim', sala.globs.fechaFinSim.AsIsoStr );

(*    archiModificado:= sala.dirResultadosCorrida
                      + nombreArchSinExtension(sala.archiSala_)+'_'+nombre_escenario_activo + '.txt';
  *)
    archiModificado:= sala.Calc_ArchiSR3( nombre_escenario_activo, idPlantilla );
    CopiarSustituyendo( archivoPlantilla, archiModificado, ListaVariablesPP );
    listaVariablesPP.Free;
    setSeparadoresLocales;
    result:= archiModificado;
  end
  else
    raise Exception.Create('TSustituirVariablesPlantilla.sustituirVariables: no se encuentra el archivo de plantilla "' + archivoPlantilla + '"');
end;

function TSustituirVariablesPlantilla.sustituirVariables(
  archivoPlantilla: String;
  archivoSala,
  nombre_escenario_activo, idPlantilla: String;
  semillaAleatoriaInicial: Integer): String;
var
  sala: TSalaDeJuego;
  res: String;
begin
  sala:= TSalaDeJuego.cargarSala( idHilo, archivoSala, nombre_escenario_activo, true);
  res:= sustituirVariables(archivoPlantilla, sala, nombre_escenario_activo, idPlantilla, semillaAleatoriaInicial);
  sala.Free;
  result:= res;
end;

function TSustituirVariablesPlantilla.sustituirVariables(
  archivoPlantilla: String;
  idPlantilla: string;
  archivosSalas: TStringList;
  semillaAleatoriaInicial: Integer): TStringList;
var
  i: Integer;
  res: TStringList;
begin
  res:= TStringList.Create;
  for i:= 0 to archivosSalas.Count - 1 do
    res.Add(sustituirVariables( archivoPlantilla, archivosSalas[i], '__principal__', idPlantilla,  semillaAleatoriaInicial));
  result:= res;
end;


procedure TSustituirVariablesPlantilla.ejecutarSimRes3(
   archivoPlantilla: String;
   sala: TSalaDeJuego;
   nombre_escenario_activo: string;
   semillaAleatoriaInicial: Integer; flg_html: boolean );
var
  archiSimRes: String;
  {$IFDEF WINDOWS}
  parametros: String;
  {$ELSE}
  parametros: array of string;
  {$ENDIF}
  plantillaSR3: string;

begin
  plantillaSR3:= nombreArchSinExtension( archivoPlantilla );
  archiSimRes:= sustituirVariables( archivoPlantilla, sala, nombre_escenario_activo, plantillaSR3, semillaAleatoriaInicial);

  ChDir(getDir_Bin);

  {$IFDEF WINDOWS}
  parametros:=
    '"' + archiSimRes+'"'
    + ' _no_cerrar_'
    + ' "'
    + sala.dirsala
    + nombreArchSinExtension( sala.archiSala_ )
    +'_'+plantillaSR3 +'_'+nombre_escenario_activo+'.xls"';
  parametros:= parametros+#0;
  if flg_html then
    ShellExecute( 0, 'open', 'SimRes3_html.exe', @parametros[1], NIL, SW_SHOWNORMAL)
  else
    ShellExecute( 0, 'open', 'SimRes3.exe', @parametros[1], NIL, SW_SHOWNORMAL);
  {$ELSE}
  setlength( parametros, 3);
  parametros[0]:= archiSimRes;
  parametros[1]:= '_no_cerrar_';
  parametros[2]:=  sala.dirsala+ nombreArchSinExtension( sala.archiSala_ )+'_'+plantillaSR3 +'_'+nombre_escenario_activo+'.xls"';
  if flg_html then
    RunChildAndWait( 'SimRes3_html', parametros )
  else
    RunChildAndWait( 'SimRes3', parametros );
  {$ENDIF}
  ChDir( sala.dirSala );
//  RunChildAndWAIT( 'SimRes3.exe', ['"'+ExtractFilePath(archiSimRes) + nombreArchSinExtension(archiSimRes) + '.xls"'] );
end;

procedure TSustituirVariablesPlantilla.ejecutarCMDSimRes3(
  archivoPlantilla: String; sala: TSalaDeJuego;
  nombre_escenario_activo: string; semillaAleatoriaInicial: Integer;
  idSubCarpetaSalida: string; idEjecutor: integer);
var
  archiSimRes: String;
  {$IFDEF WINDOWS}
  parametros: String;
  infoInicio:TSTARTUPINFO;
  infoProceso:TPROCESSINFORMATION;
  tiempoSimRes:integer;
  {$ELSE}
  parametros: array of string;
  {$ENDIF}
  plantillaSR3: string;

begin
  plantillaSR3:= nombreArchSinExtension( archivoPlantilla );
  archiSimRes:= sustituirVariables(archivoPlantilla, sala, nombre_escenario_activo, plantillaSR3, semillaAleatoriaInicial);
  ChDir(getDir_Bin);
  {$IFDEF WINDOWS}
  {
  parametros:=
    '"' + archiSimRes+'"'
    + ' _no_cerrar_'
    + ' "'
    + sala.dirsala
    + nombreArchSinExtension( sala.archiSala_ )
    +'_'+plantillaSR3 +'_'+nombre_escenario_activo+'.xls"';
  parametros:= parametros+#0;
        }

  parametros:='cmdsimres3.exe '+'"'+archiSimRes+'" '+ idSubCarpetaSalida +' ' +IntToStr(idEjecutor);

  //parametros:= '"C:' + archiSimRes+'" 1 '+IntToStr(idEjecutor)+#0 ;
  //ShellExecute( 0, 'open', 'cmdsimres3.exe', @parametros[1], NIL, SW_SHOWNORMAL);

  infoInicio := Default(TStartupInfo);
  tiempoSimRes:=0;
  if CreateProcess(nil,PChar(parametros),nil,nil,False,0,nil,nil,infoInicio,infoProceso) then
  begin
    while WaitForSingleObject(infoProceso.hProcess,1) > 0 do
      tiempoSimRes:=tiempoSimRes + 1;
    writeln('Simres3 ejecutado en ',tiempoSimRes, ' ms');
  end;
  {$ELSE}
  setlength( parametros, 3);
  parametros[0]:= archiSimRes;
  parametros[1]:= idSubCarpetaSalida;
  parametros[2]:=  IntToStr( idEjecutor );
  RunChildAndWait( 'cmdsimres3', parametros );
  {$ENDIF}
  ChDir( sala.dirSala );
end;


procedure TSustituirVariablesPlantilla.ejecutarSimRes3(
    archivoPlantilla: String;
    archivoSala, nombre_escenario_activo: String;
    semillaAleatoriaInicial: Integer; flg_html: boolean );
var
  archiSimRes: String;
  {$IFDEF WINDOWS}
  parametros: String;
  {$ELSE}
  parametros: array of string;
  {$ENDIF}
  plantillaSR3: string;
  dir_sala: string;
begin
  plantillaSR3:= nombreArchSinExtension(archivoPlantilla );
  archiSimRes:= sustituirVariables(archivoPlantilla, archivoSala, nombre_escenario_activo,
  plantillaSR3,
  semillaAleatoriaInicial);
  dir_sala:= ExtractFilePath( archivoSala );
  ChDir(getDir_Bin);
  {$IFDEF WINDOWS}
  parametros:=
    '"' + archiSimRes+'"'
    + ' _no_cerrar_'
    + ' "'+ dir_sala+ nombreArchSinExtension( archivoSala )+'_'+plantillaSR3 +'_'+nombre_escenario_activo+'.xls"';
  parametros:= parametros+#0;

  if flg_html then
    ShellExecute( 0, 'open', 'SimRes3_html.exe', @parametros[1], NIL, SW_SHOWNORMAL)
  else
    ShellExecute( 0, 'open', 'SimRes3.exe', @parametros[1], NIL, SW_SHOWNORMAL);
  {$ELSE}
  setlength( parametros, 3);
  parametros[0]:= archiSimRes;
  parametros[1]:= '_no_cerrar_';
  parametros[2]:=  dir_sala+ nombreArchSinExtension( archivoSala )+'_'+plantillaSR3 +'_'+nombre_escenario_activo+'.xls"';
  if flg_html then
    RunChildAndWait( 'SimRes3_html', parametros )
  else
    RunChildAndWait( 'SimRes3', parametros );
  {$ENDIF}
  ChDir( dir_Sala );

end;


procedure TSustituirVariablesPlantilla.Free;
begin
  inherited Free;
end;

end.
