unit ucronometro;

{$mode delphi}

interface

uses
  Classes, SysUtils;

type

  { TCronometro }

  TCronometro = class
    dt_Inicio: TDateTime;
    constructor Create;
    function dt_transcurrido( reinicie_cuenta: boolean = true ): TDateTime;
    procedure wrln( leyenda: string; reinicie_cuenta: boolean = true );
  end;


var
  Cronometro: TCronometro;

implementation

{ TCronometro }

constructor TCronometro.Create;
begin
  inherited Create;
  dt_inicio:= now();
end;

function TCronometro.dt_transcurrido(reinicie_cuenta: boolean): TDateTime;
var
  dt_now: TDateTime;
begin
  dt_now:= now();
  result:= dt_now - dt_inicio;
  if reinicie_cuenta then
   dt_inicio:= dt_now;
end;

procedure TCronometro.wrln(leyenda: string; reinicie_cuenta: boolean);
var
  dt: TDateTime;
begin
  dt:= dt_transcurrido( reinicie_cuenta );
  writeln( trunc( dt * 24*3600*1000 ), '[ms] ', leyenda );
end;


initialization
  Cronometro:= TCronometro.Create;
end.

