unit uTablaDataSetGenerico;
  {$MODE Delphi}

interface

uses
  Classes, uvisordetabla, uDataSetGenerico, xMatDefs, Graphics, SysUtils,
  StdCtrls;

type
  // esta despliega una simple tabla sobre un panel con
  // posibilidad de seleccion.
  TTablaDataSetGenerico = class ( TTabla )
    private
      botones: TDAofNInt;         //si estan a NIL no hay botonera
      hints: TDAofString;
      kFieldCheckBoxes: Integer;  //si vale -1 no hay checkBoxes
      hintCheckBoxes: String;
    public
      ds: TDataSetGenerico;
      constructor Create( AOwner: TComponent; Name: string;
                          cellpadding, cellspacing: integer;
                          anchoborde: integer ); reintroduce;

      procedure AgregarBotonera( botones: array of Integer; hints: array of string );
      procedure AgregarCheckBoxes( kField: integer; hint: String );

      procedure PopulateDS( ds: TDataSetGenerico );

      // si agregó checkboxes
      procedure MarcarTodos;
      procedure DesmarcarTodos;
      procedure Marcar( k: integer );
      procedure Desmarcar( k: integer );
      function getSelected: TDAofNInt;
  end;




implementation

constructor TTablaDataSetGenerico.Create( AOwner: TComponent; Name: string;
                                            cellpadding, cellspacing: integer;
                                            anchoborde: integer );
begin
  inherited Create(AOwner, Name, cellpadding, cellspacing, anchoborde);
  botones:= NIL;
  hints:= NIL;
  kFieldCheckBoxes:= -1;
  ds:= NIL;
end;

procedure TTablaDataSetGenerico.AgregarBotonera( botones: array of Integer; hints: array of string );
var
  i: Integer;
begin
  SetLength(self.botones, length(botones));
  for i:= 0 to high(botones) do
    self.botones[i]:= botones[i];

  SetLength(Self.hints, length(hints));
  for i:= 0 to high(hints) do
    Self.hints[i]:= hints[i];
end;

procedure TTablaDataSetGenerico.AgregarCheckBoxes( kField: integer; hint: String );
begin
  kFieldCheckBoxes:= kField;
  hintCheckBoxes:= hint;
end;

procedure TTablaDataSetGenerico.PopulateDS( ds: TDataSetGenerico );
var
  nColumnas: Integer;
  i: Integer;
  j: Integer;
  r: TDataRecord;
begin
  Self.ds:= ds;

  if ds = nil then
  begin
    ClearRedim( 0, 0 );
    reposicionar;
    exit;
  end;

  nColumnas:= ds.nfields;
  if botones <> NIL then
    nColumnas:= nColumnas + 1;
  //la columna de los checkboxes, si hay, la consideramos como un campo en ds
  ClearRedim(ds.nrows + 1, nColumnas);

  for i:= 0 to high(ds.descripcionDeCampos) do
  begin
    wrTexto('', 0, i, ds.descripcionDeCampos[i].nombre);
    AlinearCelda(0, 0, CAH_Izquierda, CAV_Centro );
  end;
  Self.SetBgColorFila(0, clFondoFixedCells );
  Self.SetFontColorFila( 0, clFontFixedCells );

  for i:= 0 to ds.nrows - 1 do
  begin
    r:= ds.go(i);

    if kFieldCheckBoxes = -1 then
    begin
      //Si no hay checkboxes son todos texto
      for j:= 0 to ds.nfields - 1 do
      begin
        wrTexto('', i + 1, j, r.GetByIdAsString(j));
        AlinearCelda(i + 1, j, CAH_Izquierda, CAV_Centro );
      end;
    end
    else
    begin
      for j:= 0 to kFieldCheckBoxes - 1 do
      begin
        wrTexto('', i + 1, j, r.GetByIdAsString(j));
        AlinearCelda(i + 1, j, CAH_Izquierda, CAV_Centro );
      end;

      wrCheckBox(nomChkBox(i + 1, kFieldCheckBoxes), i + 1, kFieldCheckBoxes,'', StrToBool(r.GetByIdAsString(kFieldCheckBoxes)), hintCheckBoxes);

      for j:= kFieldCheckBoxes + 1 to ds.nfields - 1 do
      begin
        wrTexto('', i + 1, j, r.GetByIdAsString(j));
        AlinearCelda(i + 1, j, CAH_Izquierda, CAV_Centro );
      end;
    end;

    if botones <> NIL then
    begin
      wrBotonera(IntToStr(i + 1), i + 1, ds.nfields, botones, hints);
    end;

    if (i + 1) mod 2 = 0 then
      SetBgColorFila(i + 1, clFondoFilaPar)
    else
      SetBgColorFila(i + 1, clFondoFilaImpar);
  end;
  reposicionar;
end;

procedure TTablaDataSetGenerico.MarcarTodos;
var
  i: Integer;
  chkBox: TCheckBox;
begin
  if kFieldCheckBoxes <> -1 then
  begin
    for i:= 1 to nfilas - 1 do
    begin
      chkBox:= TCheckBox(SearchComponent(filas[i].celdas[kFieldCheckBoxes], nomChkBox(i, kFieldCheckBoxes)));
      chkBox.Checked:= true;
    end;
  end;
end;

procedure TTablaDataSetGenerico.DesmarcarTodos;
var
  i: Integer;
  chkBox: TCheckBox;
begin
  if kFieldCheckBoxes <> -1 then
  begin
    for i:= 1 to nfilas - 1 do
    begin
      chkBox:= TCheckBox(SearchComponent(filas[i].celdas[kFieldCheckBoxes], nomChkBox(i, kFieldCheckBoxes)));
      chkBox.Checked:= false;
    end;
  end;
end;

procedure TTablaDataSetGenerico.Marcar( k: integer );
var
  chkBox: TCheckBox;
begin
  chkBox:= TCheckBox(SearchComponent(filas[k].celdas[kFieldCheckBoxes], nomChkBox(k, kFieldCheckBoxes)));
  chkBox.Checked:= true;
end;

procedure TTablaDataSetGenerico.Desmarcar( k: integer );
var
  chkBox: TCheckBox;
begin
  chkBox:= TCheckBox(SearchComponent(filas[k].celdas[kFieldCheckBoxes], nomChkBox(k, kFieldCheckBoxes)));
  chkBox.Checked:= false;
end;

function TTablaDataSetGenerico.getSelected: TDAofNInt;
var
  i: Integer;
  idChkBox: String;
  chkBox: TCheckBox;
  res: TDAofNInt;
  nChecked: Integer;
begin
  if kFieldCheckBoxes <> -1 then
  begin
    nChecked:= 0;
    SetLength(res, nfilas - 1);
    for i:= 1 to nfilas - 1 do
    begin
      idChkBox:= nomChkBox( i, kFieldCheckBoxes);
      chkBox:= TCheckBox(SearchComponent(filas[i].celdas[kFieldCheckBoxes], idChkBox));
      if chkBox.Checked then
      begin
        res[nChecked]:= i - 1;
        nChecked:= nChecked + 1;
      end;
    end;
    if nChecked <> Length(res) then
      SetLength(res, nChecked);
  end
  else
    res:= NIL;
  result:= res;
end;

end.
